/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan2.build.internal.spaces;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.plan2.build.internal.spaces.CollectionQuerySpaceImpl;
import org.hibernate.loader.plan2.build.internal.spaces.CompositePropertyMapping;
import org.hibernate.loader.plan2.build.internal.spaces.EntityQuerySpaceImpl;
import org.hibernate.loader.plan2.build.internal.spaces.Helper;
import org.hibernate.loader.plan2.build.internal.spaces.JoinImpl;
import org.hibernate.loader.plan2.build.internal.spaces.QuerySpacesImpl;
import org.hibernate.loader.plan2.build.spi.AbstractQuerySpace;
import org.hibernate.loader.plan2.build.spi.ExpandingCompositeQuerySpace;
import org.hibernate.loader.plan2.spi.QuerySpace;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.walking.spi.AttributeDefinition;
import org.hibernate.persister.walking.spi.CompositionDefinition;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;

public class CompositeQuerySpaceImpl
extends AbstractQuerySpace
implements ExpandingCompositeQuerySpace {
    private final CompositePropertyMapping compositeSubPropertyMapping;

    public CompositeQuerySpaceImpl(CompositePropertyMapping compositeSubPropertyMapping, String uid, QuerySpacesImpl querySpaces, boolean canJoinsBeRequired, SessionFactoryImplementor sessionFactory) {
        super(uid, QuerySpace.Disposition.COMPOSITE, querySpaces, canJoinsBeRequired, sessionFactory);
        this.compositeSubPropertyMapping = compositeSubPropertyMapping;
    }

    public CompositeQuerySpaceImpl(EntityQuerySpaceImpl entityQuerySpace, CompositePropertyMapping compositePropertyMapping, String uid, boolean canJoinsBeRequired) {
        this(compositePropertyMapping, uid, entityQuerySpace.getQuerySpaces(), canJoinsBeRequired, entityQuerySpace.sessionFactory());
    }

    @Override
    public PropertyMapping getPropertyMapping() {
        return this.compositeSubPropertyMapping;
    }

    @Override
    public JoinImpl addCompositeJoin(CompositionDefinition compositionDefinition, String querySpaceUid) {
        String propertyPath = compositionDefinition.getName();
        boolean required = this.canJoinsBeRequired() && !compositionDefinition.isNullable();
        CompositeQuerySpaceImpl rhs = new CompositeQuerySpaceImpl(this.compositeSubPropertyMapping, querySpaceUid, this.getQuerySpaces(), required, this.sessionFactory());
        this.getQuerySpaces().registerQuerySpace(rhs);
        JoinImpl join = new JoinImpl(this, propertyPath, rhs, null, null, required);
        this.internalGetJoins().add(join);
        return join;
    }

    @Override
    public JoinImpl addEntityJoin(AttributeDefinition attributeDefinition, EntityPersister persister, String querySpaceUid, boolean optional) {
        boolean isMultiTable = ((Queryable)Queryable.class.cast(persister)).isMultiTable();
        boolean required = this.canJoinsBeRequired() && !isMultiTable && !optional;
        EntityQuerySpaceImpl rhs = new EntityQuerySpaceImpl(persister, querySpaceUid, this.getQuerySpaces(), required, this.sessionFactory());
        this.getQuerySpaces().registerQuerySpace(rhs);
        String propertyPath = attributeDefinition.getName();
        JoinImpl join = new JoinImpl(this, propertyPath, rhs, Helper.INSTANCE.determineRhsColumnNames((EntityType)attributeDefinition.getType(), this.sessionFactory()), (EntityType)attributeDefinition.getType(), required);
        this.internalGetJoins().add(join);
        return join;
    }

    @Override
    public JoinImpl addCollectionJoin(AttributeDefinition attributeDefinition, CollectionPersister collectionPersister, String querySpaceUid) {
        boolean required = this.canJoinsBeRequired() && !attributeDefinition.isNullable();
        CollectionQuerySpaceImpl rhs = new CollectionQuerySpaceImpl(collectionPersister, querySpaceUid, this.getQuerySpaces(), required, this.sessionFactory());
        this.getQuerySpaces().registerQuerySpace(rhs);
        JoinImpl join = new JoinImpl(this, attributeDefinition.getName(), rhs, ((CollectionType)attributeDefinition.getType()).getAssociatedJoinable(this.sessionFactory()).getKeyColumnNames(), (AssociationType)attributeDefinition.getType(), required);
        this.internalGetJoins().add(join);
        return join;
    }
}

