/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan2.build.internal.spaces;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.plan2.build.internal.spaces.CompositePropertyMapping;
import org.hibernate.loader.plan2.build.internal.spaces.CompositeQuerySpaceImpl;
import org.hibernate.loader.plan2.build.internal.spaces.EntityQuerySpaceImpl;
import org.hibernate.loader.plan2.build.internal.spaces.JoinImpl;
import org.hibernate.loader.plan2.build.internal.spaces.QuerySpacesImpl;
import org.hibernate.loader.plan2.build.spi.AbstractQuerySpace;
import org.hibernate.loader.plan2.build.spi.LoadPlanBuildingContext;
import org.hibernate.loader.plan2.spi.CollectionQuerySpace;
import org.hibernate.loader.plan2.spi.Join;
import org.hibernate.loader.plan2.spi.QuerySpace;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.CompositeType;

public class CollectionQuerySpaceImpl
extends AbstractQuerySpace
implements CollectionQuerySpace {
    private final CollectionPersister persister;

    public CollectionQuerySpaceImpl(CollectionPersister persister, String uid, QuerySpacesImpl querySpaces, boolean canJoinsBeRequired, SessionFactoryImplementor sessionFactory) {
        super(uid, QuerySpace.Disposition.COLLECTION, querySpaces, canJoinsBeRequired, sessionFactory);
        this.persister = persister;
    }

    @Override
    public CollectionPersister getCollectionPersister() {
        return this.persister;
    }

    @Override
    public PropertyMapping getPropertyMapping() {
        return (PropertyMapping)((Object)this.persister);
    }

    public JoinImpl addIndexEntityJoin(EntityPersister indexPersister, LoadPlanBuildingContext context) {
        boolean required = this.canJoinsBeRequired();
        String entityQuerySpaceUid = this.getQuerySpaces().generateImplicitUid();
        EntityQuerySpaceImpl entityQuerySpace = new EntityQuerySpaceImpl(indexPersister, entityQuerySpaceUid, this.getQuerySpaces(), required, this.sessionFactory());
        this.getQuerySpaces().registerQuerySpace(entityQuerySpace);
        JoinImpl join = new JoinImpl(this, "index", entityQuerySpace, ((Queryable)indexPersister).getKeyColumnNames(), null, required);
        this.internalGetJoins().add(join);
        return join;
    }

    public JoinImpl addIndexCompositeJoin(CompositeType compositeType, LoadPlanBuildingContext context) {
        String compositeQuerySpaceUid = this.getQuerySpaces().generateImplicitUid();
        CompositeQuerySpaceImpl compositeQuerySpace = new CompositeQuerySpaceImpl(new CompositePropertyMapping(compositeType, (PropertyMapping)((Object)this.getCollectionPersister()), "index"), compositeQuerySpaceUid, this.getQuerySpaces(), this.canJoinsBeRequired(), this.sessionFactory());
        this.getQuerySpaces().registerQuerySpace(compositeQuerySpace);
        JoinImpl join = new JoinImpl(this, "index", compositeQuerySpace, null, null, this.canJoinsBeRequired());
        this.internalGetJoins().add(join);
        return join;
    }

    public JoinImpl addElementEntityJoin(EntityPersister elementPersister, LoadPlanBuildingContext context) {
        String entityQuerySpaceUid = this.getQuerySpaces().generateImplicitUid();
        EntityQuerySpaceImpl entityQuerySpace = new EntityQuerySpaceImpl(elementPersister, entityQuerySpaceUid, this.getQuerySpaces(), this.canJoinsBeRequired(), this.sessionFactory());
        ((QuerySpacesImpl)context.getQuerySpaces()).registerQuerySpace(entityQuerySpace);
        JoinImpl join = new JoinImpl(this, "id", entityQuerySpace, ((Queryable)elementPersister).getKeyColumnNames(), null, this.canJoinsBeRequired());
        this.internalGetJoins().add(join);
        return join;
    }

    public Join addElementCompositeJoin(CompositeType compositeType, LoadPlanBuildingContext context) {
        String compositeQuerySpaceUid = this.getQuerySpaces().generateImplicitUid();
        CompositeQuerySpaceImpl compositeQuerySpace = new CompositeQuerySpaceImpl(new CompositePropertyMapping(compositeType, (PropertyMapping)((Object)this.getCollectionPersister()), ""), compositeQuerySpaceUid, this.getQuerySpaces(), this.canJoinsBeRequired(), this.sessionFactory());
        ((QuerySpacesImpl)context.getQuerySpaces()).registerQuerySpace(compositeQuerySpace);
        JoinImpl join = new JoinImpl(this, "elements", compositeQuerySpace, null, null, this.canJoinsBeRequired());
        this.internalGetJoins().add(join);
        return join;
    }
}

