/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan2.build.internal.returns;

import org.hibernate.loader.plan2.build.internal.returns.AbstractCompositeFetch;
import org.hibernate.loader.plan2.build.spi.ExpandingCompositeQuerySpace;
import org.hibernate.loader.plan2.spi.CollectionFetchableIndex;
import org.hibernate.loader.plan2.spi.CollectionReference;
import org.hibernate.loader.plan2.spi.CompositeFetch;
import org.hibernate.loader.plan2.spi.FetchSource;
import org.hibernate.loader.plan2.spi.Join;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public class CollectionFetchableIndexCompositeGraph
extends AbstractCompositeFetch
implements CompositeFetch,
CollectionFetchableIndex {
    private final CollectionReference collectionReference;

    public CollectionFetchableIndexCompositeGraph(CollectionReference collectionReference, Join compositeJoin) {
        super(CollectionFetchableIndexCompositeGraph.extractIndexType(compositeJoin), (ExpandingCompositeQuerySpace)compositeJoin.getRightHandSide(), false, collectionReference.getPropertyPath().append("<index>"));
        this.collectionReference = collectionReference;
    }

    private static CompositeType extractIndexType(Join compositeJoin) {
        Type type = compositeJoin.getRightHandSide().getPropertyMapping().getType();
        if (CompositeType.class.isInstance(type)) {
            return (CompositeType)type;
        }
        throw new IllegalArgumentException("Could note extract collection composite-index");
    }

    @Override
    public CollectionReference getCollectionReference() {
        return this.collectionReference;
    }

    @Override
    public FetchSource getSource() {
        return this.collectionReference.getIndexGraph();
    }
}

