/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan2.build.internal.returns;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan2.build.internal.returns.BidirectionalEntityReferenceImpl;
import org.hibernate.loader.plan2.build.internal.returns.CollectionFetchImpl;
import org.hibernate.loader.plan2.build.internal.returns.EntityFetchImpl;
import org.hibernate.loader.plan2.build.spi.ExpandingCompositeQuerySpace;
import org.hibernate.loader.plan2.build.spi.ExpandingFetchSource;
import org.hibernate.loader.plan2.build.spi.ExpandingQuerySpace;
import org.hibernate.loader.plan2.build.spi.LoadPlanBuildingContext;
import org.hibernate.loader.plan2.spi.BidirectionalEntityReference;
import org.hibernate.loader.plan2.spi.CollectionFetch;
import org.hibernate.loader.plan2.spi.CompositeFetch;
import org.hibernate.loader.plan2.spi.EntityFetch;
import org.hibernate.loader.plan2.spi.EntityReference;
import org.hibernate.loader.plan2.spi.Fetch;
import org.hibernate.loader.plan2.spi.JoinDefinedByMetadata;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.hibernate.persister.walking.spi.CompositionDefinition;
import org.hibernate.persister.walking.spi.WalkingException;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;

public abstract class AbstractExpandingFetchSource
implements ExpandingFetchSource {
    private static final Fetch[] NO_FETCHES = new Fetch[0];
    private static final BidirectionalEntityReference[] NO_BIDIRECTIONAL_ENTITY_REFERENCES = new BidirectionalEntityReference[0];
    private final ExpandingQuerySpace querySpace;
    private final PropertyPath propertyPath;
    private List<Fetch> fetches;
    private List<BidirectionalEntityReference> bidirectionalEntityReferences;

    public AbstractExpandingFetchSource(ExpandingQuerySpace querySpace, PropertyPath propertyPath) {
        this.querySpace = querySpace;
        this.propertyPath = propertyPath;
    }

    @Override
    public final String getQuerySpaceUid() {
        return this.querySpace.getUid();
    }

    protected final ExpandingQuerySpace expandingQuerySpace() {
        return this.querySpace;
    }

    @Override
    public final PropertyPath getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public Fetch[] getFetches() {
        return this.fetches == null ? NO_FETCHES : this.fetches.toArray(new Fetch[this.fetches.size()]);
    }

    private void addFetch(Fetch fetch) {
        if (this.fetches == null) {
            this.fetches = new ArrayList<Fetch>();
        }
        this.fetches.add(fetch);
    }

    @Override
    public BidirectionalEntityReference[] getBidirectionalEntityReferences() {
        return this.bidirectionalEntityReferences == null ? NO_BIDIRECTIONAL_ENTITY_REFERENCES : this.bidirectionalEntityReferences.toArray(new BidirectionalEntityReference[this.bidirectionalEntityReferences.size()]);
    }

    private void addBidirectionalEntityReference(BidirectionalEntityReference bidirectionalEntityReference) {
        if (this.bidirectionalEntityReferences == null) {
            this.bidirectionalEntityReferences = new ArrayList<BidirectionalEntityReference>();
        }
        this.bidirectionalEntityReferences.add(bidirectionalEntityReference);
    }

    @Override
    public EntityFetch buildEntityFetch(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
        EntityType fetchedType = (EntityType)attributeDefinition.getType();
        EntityPersister fetchedPersister = loadPlanBuildingContext.getSessionFactory().getEntityPersister(fetchedType.getAssociatedEntityName());
        if (fetchedPersister == null) {
            throw new WalkingException(String.format("Unable to locate EntityPersister [%s] for fetch [%s]", fetchedType.getAssociatedEntityName(), attributeDefinition.getName()));
        }
        JoinDefinedByMetadata join = this.querySpace.addEntityJoin(attributeDefinition, fetchedPersister, loadPlanBuildingContext.getQuerySpaces().generateImplicitUid(), attributeDefinition.isNullable());
        EntityFetchImpl fetch = new EntityFetchImpl(this, attributeDefinition, fetchStrategy, join);
        this.addFetch(fetch);
        return fetch;
    }

    @Override
    public BidirectionalEntityReference buildBidirectionalEntityReference(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, EntityReference targetEntityReference, LoadPlanBuildingContext loadPlanBuildingContext) {
        EntityType fetchedType = (EntityType)attributeDefinition.getType();
        EntityPersister fetchedPersister = loadPlanBuildingContext.getSessionFactory().getEntityPersister(fetchedType.getAssociatedEntityName());
        if (fetchedPersister == null) {
            throw new WalkingException(String.format("Unable to locate EntityPersister [%s] for bidirectional entity reference [%s]", fetchedType.getAssociatedEntityName(), attributeDefinition.getName()));
        }
        BidirectionalEntityReferenceImpl bidirectionalEntityReference = new BidirectionalEntityReferenceImpl(this, attributeDefinition, targetEntityReference);
        this.addBidirectionalEntityReference(bidirectionalEntityReference);
        return bidirectionalEntityReference;
    }

    protected abstract CompositeFetch createCompositeFetch(CompositeType var1, ExpandingCompositeQuerySpace var2);

    @Override
    public CompositeFetch buildCompositeFetch(CompositionDefinition attributeDefinition, LoadPlanBuildingContext loadPlanBuildingContext) {
        ExpandingQuerySpace leftHandSide = this.expandingQuerySpace();
        JoinDefinedByMetadata join = leftHandSide.addCompositeJoin(attributeDefinition, loadPlanBuildingContext.getQuerySpaces().generateImplicitUid());
        CompositeFetch fetch = this.createCompositeFetch(attributeDefinition.getType(), (ExpandingCompositeQuerySpace)join.getRightHandSide());
        this.addFetch(fetch);
        return fetch;
    }

    @Override
    public CollectionFetch buildCollectionFetch(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
        CollectionType fetchedType = (CollectionType)attributeDefinition.getType();
        CollectionPersister fetchedPersister = loadPlanBuildingContext.getSessionFactory().getCollectionPersister(fetchedType.getRole());
        if (fetchedPersister == null) {
            throw new WalkingException(String.format("Unable to locate CollectionPersister [%s] for fetch [%s]", fetchedType.getRole(), attributeDefinition.getName()));
        }
        JoinDefinedByMetadata join = this.querySpace.addCollectionJoin(attributeDefinition, fetchedPersister, loadPlanBuildingContext.getQuerySpaces().generateImplicitUid());
        CollectionFetchImpl fetch = new CollectionFetchImpl(this, attributeDefinition, fetchStrategy, join, loadPlanBuildingContext);
        this.addFetch(fetch);
        return fetch;
    }
}

