/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan2.build.internal.returns;

import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan2.build.internal.returns.AbstractExpandingFetchSource;
import org.hibernate.loader.plan2.build.internal.returns.NestedCompositeFetchImpl;
import org.hibernate.loader.plan2.build.spi.ExpandingCompositeQuerySpace;
import org.hibernate.loader.plan2.build.spi.LoadPlanBuildingContext;
import org.hibernate.loader.plan2.spi.CollectionFetch;
import org.hibernate.loader.plan2.spi.CompositeFetch;
import org.hibernate.loader.plan2.spi.EntityReference;
import org.hibernate.loader.plan2.spi.FetchSource;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.hibernate.persister.walking.spi.AttributeDefinition;
import org.hibernate.persister.walking.spi.WalkingException;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public abstract class AbstractCompositeFetch
extends AbstractExpandingFetchSource
implements CompositeFetch {
    private static final FetchStrategy FETCH_STRATEGY = new FetchStrategy(FetchTiming.IMMEDIATE, FetchStyle.JOIN);
    private final CompositeType compositeType;
    private final boolean allowCollectionFetches;

    protected AbstractCompositeFetch(CompositeType compositeType, ExpandingCompositeQuerySpace compositeQuerySpace, boolean allowCollectionFetches, PropertyPath propertyPath) {
        super(compositeQuerySpace, propertyPath);
        this.compositeType = compositeType;
        this.allowCollectionFetches = allowCollectionFetches;
    }

    @Override
    public EntityReference resolveEntityReference() {
        return AbstractCompositeFetch.resolveFetchSourceEntityReference(this);
    }

    private static EntityReference resolveFetchSourceEntityReference(CompositeFetch fetch) {
        FetchSource fetchSource = fetch.getSource();
        if (EntityReference.class.isInstance(fetchSource)) {
            return (EntityReference)fetchSource;
        }
        if (CompositeFetch.class.isInstance(fetchSource)) {
            return AbstractCompositeFetch.resolveFetchSourceEntityReference((CompositeFetch)fetchSource);
        }
        throw new IllegalStateException(String.format("Cannot resolve FetchOwner [%s] of Fetch [%s (%s)] to an EntityReference", fetchSource, fetch, fetch.getPropertyPath()));
    }

    @Override
    public void validateFetchPlan(FetchStrategy fetchStrategy, AttributeDefinition attributeDefinition) {
    }

    @Override
    protected CompositeFetch createCompositeFetch(CompositeType compositeType, ExpandingCompositeQuerySpace compositeQuerySpace) {
        return new NestedCompositeFetchImpl(this, compositeType, compositeQuerySpace, this.allowCollectionFetches, this.getPropertyPath());
    }

    @Override
    public CollectionFetch buildCollectionFetch(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
        if (!this.allowCollectionFetches) {
            throw new WalkingException(String.format("This composite path [%s] does not allow collection fetches (composite id or composite collection index/element", this.getPropertyPath().getFullPath()));
        }
        return super.buildCollectionFetch(attributeDefinition, fetchStrategy, loadPlanBuildingContext);
    }

    @Override
    public FetchStrategy getFetchStrategy() {
        return FETCH_STRATEGY;
    }

    @Override
    public Type getFetchedType() {
        return this.compositeType;
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public String getAdditionalJoinConditions() {
        return null;
    }

    @Override
    public String[] toSqlSelectFragments(String alias) {
        return new String[0];
    }
}

