/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan2.build.internal.returns;

import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan2.build.internal.returns.CollectionFetchableElementCompositeGraph;
import org.hibernate.loader.plan2.build.internal.returns.CollectionFetchableElementEntityGraph;
import org.hibernate.loader.plan2.build.internal.returns.CollectionFetchableIndexCompositeGraph;
import org.hibernate.loader.plan2.build.internal.returns.CollectionFetchableIndexEntityGraph;
import org.hibernate.loader.plan2.build.internal.spaces.CollectionQuerySpaceImpl;
import org.hibernate.loader.plan2.build.internal.spaces.JoinImpl;
import org.hibernate.loader.plan2.build.spi.LoadPlanBuildingContext;
import org.hibernate.loader.plan2.spi.CollectionFetchableElement;
import org.hibernate.loader.plan2.spi.CollectionFetchableIndex;
import org.hibernate.loader.plan2.spi.CollectionReference;
import org.hibernate.loader.plan2.spi.Join;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public abstract class AbstractCollectionReference
implements CollectionReference {
    private final CollectionQuerySpaceImpl collectionQuerySpace;
    private final PropertyPath propertyPath;
    private final CollectionFetchableIndex index;
    private final CollectionFetchableElement element;

    protected AbstractCollectionReference(CollectionQuerySpaceImpl collectionQuerySpace, PropertyPath propertyPath, LoadPlanBuildingContext loadPlanBuildingContext) {
        this.collectionQuerySpace = collectionQuerySpace;
        this.propertyPath = propertyPath;
        this.index = this.buildIndexGraph(collectionQuerySpace, loadPlanBuildingContext);
        this.element = this.buildElementGraph(collectionQuerySpace, loadPlanBuildingContext);
    }

    private CollectionFetchableIndex buildIndexGraph(CollectionQuerySpaceImpl collectionQuerySpace, LoadPlanBuildingContext loadPlanBuildingContext) {
        CollectionPersister persister = collectionQuerySpace.getCollectionPersister();
        if (persister.hasIndex()) {
            Type type = persister.getIndexType();
            if (type.isAssociationType()) {
                if (type.isEntityType()) {
                    EntityPersister indexPersister = persister.getFactory().getEntityPersister(((EntityType)type).getAssociatedEntityName());
                    JoinImpl join = collectionQuerySpace.addIndexEntityJoin(indexPersister, loadPlanBuildingContext);
                    return new CollectionFetchableIndexEntityGraph(this, join);
                }
            } else if (type.isComponentType()) {
                JoinImpl join = collectionQuerySpace.addIndexCompositeJoin((CompositeType)type, loadPlanBuildingContext);
                return new CollectionFetchableIndexCompositeGraph(this, join);
            }
        }
        return null;
    }

    private CollectionFetchableElement buildElementGraph(CollectionQuerySpaceImpl collectionQuerySpace, LoadPlanBuildingContext loadPlanBuildingContext) {
        CollectionPersister persister = collectionQuerySpace.getCollectionPersister();
        Type type = persister.getElementType();
        if (type.isAssociationType()) {
            if (type.isEntityType()) {
                EntityPersister elementPersister = persister.getFactory().getEntityPersister(((EntityType)type).getAssociatedEntityName());
                JoinImpl join = collectionQuerySpace.addElementEntityJoin(elementPersister, loadPlanBuildingContext);
                return new CollectionFetchableElementEntityGraph(this, join);
            }
        } else if (type.isComponentType()) {
            Join join = collectionQuerySpace.addElementCompositeJoin((CompositeType)type, loadPlanBuildingContext);
            return new CollectionFetchableElementCompositeGraph(this, join);
        }
        return null;
    }

    @Override
    public String getQuerySpaceUid() {
        return this.collectionQuerySpace.getUid();
    }

    @Override
    public CollectionPersister getCollectionPersister() {
        return this.collectionQuerySpace.getCollectionPersister();
    }

    @Override
    public CollectionFetchableIndex getIndexGraph() {
        return this.index;
    }

    @Override
    public CollectionFetchableElement getElementGraph() {
        return this.element;
    }

    @Override
    public PropertyPath getPropertyPath() {
        return this.propertyPath;
    }
}

