/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan2.build.internal;

import org.hibernate.HibernateException;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.loader.plan2.build.internal.LoadPlanImpl;
import org.hibernate.loader.plan2.build.spi.AbstractLoadPlanBuildingAssociationVisitationStrategy;
import org.hibernate.loader.plan2.spi.CollectionReturn;
import org.hibernate.loader.plan2.spi.EntityReturn;
import org.hibernate.loader.plan2.spi.LoadPlan;
import org.hibernate.loader.plan2.spi.QuerySpaces;
import org.hibernate.loader.plan2.spi.Return;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.jboss.logging.Logger;

public class FetchStyleLoadPlanBuildingAssociationVisitationStrategy
extends AbstractLoadPlanBuildingAssociationVisitationStrategy {
    private static final Logger log = CoreLogging.logger(FetchStyleLoadPlanBuildingAssociationVisitationStrategy.class);
    private final LoadQueryInfluencers loadQueryInfluencers;
    private Return rootReturn;

    public FetchStyleLoadPlanBuildingAssociationVisitationStrategy(SessionFactoryImplementor sessionFactory, LoadQueryInfluencers loadQueryInfluencers) {
        super(sessionFactory);
        this.loadQueryInfluencers = loadQueryInfluencers;
    }

    @Override
    protected boolean supportsRootEntityReturns() {
        return true;
    }

    @Override
    protected boolean supportsRootCollectionReturns() {
        return true;
    }

    @Override
    protected void addRootReturn(Return rootReturn) {
        if (this.rootReturn != null) {
            throw new HibernateException("Root return already identified");
        }
        this.rootReturn = rootReturn;
    }

    @Override
    public LoadPlan buildLoadPlan() {
        log.debug((Object)"Building LoadPlan...");
        if (EntityReturn.class.isInstance(this.rootReturn)) {
            return new LoadPlanImpl((EntityReturn)this.rootReturn, (QuerySpaces)this.getQuerySpaces());
        }
        if (CollectionReturn.class.isInstance(this.rootReturn)) {
            return new LoadPlanImpl((CollectionReturn)this.rootReturn, (QuerySpaces)this.getQuerySpaces());
        }
        throw new IllegalStateException("Unexpected root Return type : " + this.rootReturn);
    }

    @Override
    protected FetchStrategy determineFetchStrategy(AssociationAttributeDefinition attributeDefinition) {
        FetchStrategy fetchStrategy = attributeDefinition.determineFetchPlan(this.loadQueryInfluencers, this.currentPropertyPath);
        if (fetchStrategy.getTiming() == FetchTiming.IMMEDIATE && fetchStrategy.getStyle() == FetchStyle.JOIN) {
            fetchStrategy = this.adjustJoinFetchIfNeeded(attributeDefinition, fetchStrategy);
        }
        return fetchStrategy;
    }

    protected FetchStrategy adjustJoinFetchIfNeeded(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy) {
        Integer maxFetchDepth = this.sessionFactory().getSettings().getMaximumFetchDepth();
        if (maxFetchDepth != null && this.currentDepth() > maxFetchDepth) {
            return new FetchStrategy(fetchStrategy.getTiming(), FetchStyle.SELECT);
        }
        if (attributeDefinition.getType().isCollectionType() && this.isTooManyCollections()) {
            return new FetchStrategy(fetchStrategy.getTiming(), FetchStyle.SELECT);
        }
        return fetchStrategy;
    }

    @Override
    protected boolean isTooManyCollections() {
        return false;
    }
}

