/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi.visit;

import java.util.List;
import org.hibernate.loader.plan.spi.CollectionFetch;
import org.hibernate.loader.plan.spi.CollectionReturn;
import org.hibernate.loader.plan.spi.CompositeFetch;
import org.hibernate.loader.plan.spi.EntityFetch;
import org.hibernate.loader.plan.spi.EntityReturn;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.hibernate.loader.plan.spi.Return;
import org.hibernate.loader.plan.spi.ScalarReturn;
import org.hibernate.loader.plan.spi.visit.ReturnGraphVisitationStrategy;

public class ReturnGraphVisitor {
    private final ReturnGraphVisitationStrategy strategy;

    public ReturnGraphVisitor(ReturnGraphVisitationStrategy strategy) {
        this.strategy = strategy;
    }

    public void visit(Return ... rootReturns) {
        for (Return rootReturn : rootReturns) {
            this.visitRootReturn(rootReturn);
        }
    }

    public void visit(List<? extends Return> rootReturns) {
        for (Return return_ : rootReturns) {
            this.visitRootReturn(return_);
        }
    }

    private void visitRootReturn(Return rootReturn) {
        this.strategy.startingRootReturn(rootReturn);
        if (ScalarReturn.class.isInstance(rootReturn)) {
            this.strategy.handleScalarReturn((ScalarReturn)rootReturn);
        } else {
            this.visitNonScalarRootReturn(rootReturn);
        }
        this.strategy.finishingRootReturn(rootReturn);
    }

    private void visitNonScalarRootReturn(Return rootReturn) {
        if (EntityReturn.class.isInstance(rootReturn)) {
            this.strategy.handleEntityReturn((EntityReturn)rootReturn);
            this.visitFetches((EntityReturn)rootReturn);
        } else if (CollectionReturn.class.isInstance(rootReturn)) {
            this.strategy.handleCollectionReturn((CollectionReturn)rootReturn);
            CollectionReturn collectionReturn = (CollectionReturn)rootReturn;
            this.visitFetches(collectionReturn.getIndexGraph());
            this.visitFetches(collectionReturn.getElementGraph());
        } else {
            throw new IllegalStateException("Unexpected return type encountered; expecting a non-scalar root return, but found " + rootReturn.getClass().getName());
        }
    }

    private void visitFetches(FetchOwner fetchOwner) {
        if (fetchOwner != null) {
            this.strategy.startingFetches(fetchOwner);
            for (Fetch fetch : fetchOwner.getFetches()) {
                this.visitFetch(fetch);
            }
            this.strategy.finishingFetches(fetchOwner);
        }
    }

    private void visitFetch(Fetch fetch) {
        if (EntityFetch.class.isInstance(fetch)) {
            this.strategy.startingEntityFetch((EntityFetch)fetch);
            this.visitFetches((EntityFetch)fetch);
            this.strategy.finishingEntityFetch((EntityFetch)fetch);
        } else if (CollectionFetch.class.isInstance(fetch)) {
            this.strategy.startingCollectionFetch((CollectionFetch)fetch);
            this.visitFetches(((CollectionFetch)fetch).getIndexGraph());
            this.visitFetches(((CollectionFetch)fetch).getElementGraph());
            this.strategy.finishingCollectionFetch((CollectionFetch)fetch);
        } else if (CompositeFetch.class.isInstance(fetch)) {
            this.strategy.startingCompositeFetch((CompositeFetch)fetch);
            this.visitFetches((CompositeFetch)fetch);
            this.strategy.finishingCompositeFetch((CompositeFetch)fetch);
        } else {
            throw new IllegalStateException("Unexpected return type encountered; expecting a fetch return, but found " + fetch.getClass().getName());
        }
    }
}

