/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi.build;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan.spi.AbstractFetchOwner;
import org.hibernate.loader.plan.spi.AbstractPlanNode;
import org.hibernate.loader.plan.spi.AnyFetch;
import org.hibernate.loader.plan.spi.BidirectionalEntityFetch;
import org.hibernate.loader.plan.spi.CollectionFetch;
import org.hibernate.loader.plan.spi.CollectionReference;
import org.hibernate.loader.plan.spi.CollectionReturn;
import org.hibernate.loader.plan.spi.CompositeFetch;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.EntityFetch;
import org.hibernate.loader.plan.spi.EntityPersisterBasedSqlSelectFragmentResolver;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.EntityReturn;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.hibernate.loader.plan.spi.IdentifierDescription;
import org.hibernate.loader.plan.spi.KeyManyToOneBidirectionalEntityFetch;
import org.hibernate.loader.plan.spi.Return;
import org.hibernate.loader.plan.spi.SqlSelectFragmentResolver;
import org.hibernate.loader.plan.spi.build.LoadPlanBuilderStrategy;
import org.hibernate.loader.plan.spi.build.LoadPlanBuildingContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.spi.HydratedCompoundValueHandler;
import org.hibernate.persister.walking.spi.AnyMappingDefinition;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.hibernate.persister.walking.spi.AssociationKey;
import org.hibernate.persister.walking.spi.AttributeDefinition;
import org.hibernate.persister.walking.spi.CollectionDefinition;
import org.hibernate.persister.walking.spi.CollectionElementDefinition;
import org.hibernate.persister.walking.spi.CollectionIndexDefinition;
import org.hibernate.persister.walking.spi.CompositionDefinition;
import org.hibernate.persister.walking.spi.EntityDefinition;
import org.hibernate.persister.walking.spi.EntityIdentifierDefinition;
import org.hibernate.persister.walking.spi.WalkingException;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;
import org.jboss.logging.MDC;

public abstract class AbstractLoadPlanBuilderStrategy
implements LoadPlanBuilderStrategy,
LoadPlanBuildingContext {
    private static final Logger log = Logger.getLogger(AbstractLoadPlanBuilderStrategy.class);
    private static final String MDC_KEY = "hibernateLoadPlanWalkPath";
    private final SessionFactoryImplementor sessionFactory;
    private ArrayDeque<FetchOwner> fetchOwnerStack = new ArrayDeque();
    private ArrayDeque<CollectionReference> collectionReferenceStack = new ArrayDeque();
    private Map<AssociationKey, FetchOwner> fetchedAssociationKeyOwnerMap = new HashMap<AssociationKey, FetchOwner>();

    protected AbstractLoadPlanBuilderStrategy(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactoryImplementor sessionFactory() {
        return this.sessionFactory;
    }

    protected FetchOwner currentFetchOwner() {
        return this.fetchOwnerStack.peekFirst();
    }

    @Override
    public void start() {
        if (!this.fetchOwnerStack.isEmpty()) {
            throw new WalkingException("Fetch owner stack was not empty on start; be sure to not use LoadPlanBuilderStrategy instances concurrently");
        }
        if (!this.collectionReferenceStack.isEmpty()) {
            throw new WalkingException("Collection reference stack was not empty on start; be sure to not use LoadPlanBuilderStrategy instances concurrently");
        }
        MDC.put((String)MDC_KEY, (Object)new MDCStack());
    }

    @Override
    public void finish() {
        MDC.remove((String)MDC_KEY);
        this.fetchOwnerStack.clear();
        this.collectionReferenceStack.clear();
    }

    @Override
    public void startingEntity(EntityDefinition entityDefinition) {
        log.tracef("%s Starting entity : %s", (Object)StringHelper.repeat(">>", this.fetchOwnerStack.size()), (Object)entityDefinition.getEntityPersister().getEntityName());
        if (this.fetchOwnerStack.isEmpty()) {
            if (!this.supportsRootEntityReturns()) {
                throw new HibernateException("This strategy does not support root entity returns");
            }
            EntityReturn entityReturn = this.buildRootEntityReturn(entityDefinition);
            this.addRootReturn(entityReturn);
            this.pushToStack(entityReturn);
        }
    }

    protected boolean supportsRootEntityReturns() {
        return false;
    }

    protected abstract void addRootReturn(Return var1);

    @Override
    public void finishingEntity(EntityDefinition entityDefinition) {
        FetchOwner poppedFetchOwner = this.popFromStack();
        if (!EntityReference.class.isInstance(poppedFetchOwner)) {
            throw new WalkingException("Mismatched FetchOwner from stack on pop");
        }
        EntityReference entityReference = (EntityReference)((Object)poppedFetchOwner);
        if (!entityReference.getEntityPersister().equals(entityDefinition.getEntityPersister())) {
            throw new WalkingException("Mismatched FetchOwner from stack on pop");
        }
        log.tracef("%s Finished entity : %s", (Object)StringHelper.repeat("<<", this.fetchOwnerStack.size()), (Object)entityDefinition.getEntityPersister().getEntityName());
    }

    @Override
    public void startingEntityIdentifier(EntityIdentifierDefinition entityIdentifierDefinition) {
        log.tracef("%s Starting entity identifier : %s", (Object)StringHelper.repeat(">>", this.fetchOwnerStack.size()), (Object)entityIdentifierDefinition.getEntityDefinition().getEntityPersister().getEntityName());
        EntityReference entityReference = (EntityReference)((Object)this.currentFetchOwner());
        if (!entityReference.getEntityPersister().equals(entityIdentifierDefinition.getEntityDefinition().getEntityPersister())) {
            throw new WalkingException(String.format("Encountered unexpected fetch owner [%s] in stack while processing entity identifier for [%s]", entityReference.getEntityPersister().getEntityName(), entityIdentifierDefinition.getEntityDefinition().getEntityPersister().getEntityName()));
        }
        AbstractIdentifierAttributeCollector identifierAttributeCollector = entityIdentifierDefinition.isEncapsulated() ? new EncapsulatedIdentifierAttributeCollector(this.sessionFactory, entityReference) : new NonEncapsulatedIdentifierAttributeCollector(this.sessionFactory, entityReference);
        this.pushToStack(identifierAttributeCollector);
    }

    @Override
    public void finishingEntityIdentifier(EntityIdentifierDefinition entityIdentifierDefinition) {
        FetchOwner poppedFetchOwner = this.popFromStack();
        if (!AbstractIdentifierAttributeCollector.class.isInstance(poppedFetchOwner)) {
            throw new WalkingException("Unexpected state in FetchOwner stack");
        }
        EntityReference entityReference = (EntityReference)((Object)poppedFetchOwner);
        if (!entityReference.getEntityPersister().equals(entityIdentifierDefinition.getEntityDefinition().getEntityPersister())) {
            throw new WalkingException(String.format("Encountered unexpected fetch owner [%s] in stack while processing entity identifier for [%s]", entityReference.getEntityPersister().getEntityName(), entityIdentifierDefinition.getEntityDefinition().getEntityPersister().getEntityName()));
        }
        FetchOwner currentFetchOwner = this.currentFetchOwner();
        if (!EntityReference.class.isInstance(currentFetchOwner)) {
            throw new WalkingException("Unexpected state in FetchOwner stack");
        }
        entityReference = (EntityReference)((Object)currentFetchOwner);
        if (!entityReference.getEntityPersister().equals(entityIdentifierDefinition.getEntityDefinition().getEntityPersister())) {
            throw new WalkingException(String.format("Encountered unexpected fetch owner [%s] in stack while processing entity identifier for [%s]", entityReference.getEntityPersister().getEntityName(), entityIdentifierDefinition.getEntityDefinition().getEntityPersister().getEntityName()));
        }
        log.tracef("%s Finished entity identifier : %s", (Object)StringHelper.repeat("<<", this.fetchOwnerStack.size()), (Object)entityIdentifierDefinition.getEntityDefinition().getEntityPersister().getEntityName());
    }

    @Override
    public void startingCollection(CollectionDefinition collectionDefinition) {
        log.tracef("%s Starting collection : %s", (Object)StringHelper.repeat(">>", this.fetchOwnerStack.size()), (Object)collectionDefinition.getCollectionPersister().getRole());
        if (this.fetchOwnerStack.isEmpty()) {
            if (!this.supportsRootCollectionReturns()) {
                throw new HibernateException("This strategy does not support root collection returns");
            }
            CollectionReturn collectionReturn = this.buildRootCollectionReturn(collectionDefinition);
            this.addRootReturn(collectionReturn);
            this.pushToCollectionStack(collectionReturn);
        }
    }

    protected boolean supportsRootCollectionReturns() {
        return false;
    }

    @Override
    public void startingCollectionIndex(CollectionIndexDefinition collectionIndexDefinition) {
        Type indexType = collectionIndexDefinition.getType();
        if (indexType.isAssociationType() || indexType.isComponentType()) {
            CollectionReference collectionReference = this.collectionReferenceStack.peekFirst();
            FetchOwner indexGraph = collectionReference.getIndexGraph();
            if (indexGraph == null) {
                throw new WalkingException("Collection reference did not return index handler");
            }
            this.pushToStack(indexGraph);
        }
    }

    @Override
    public void finishingCollectionIndex(CollectionIndexDefinition collectionIndexDefinition) {
    }

    @Override
    public void startingCollectionElements(CollectionElementDefinition elementDefinition) {
        if (elementDefinition.getType().isAssociationType() || elementDefinition.getType().isComponentType()) {
            CollectionReference collectionReference = this.collectionReferenceStack.peekFirst();
            FetchOwner elementGraph = collectionReference.getElementGraph();
            if (elementGraph == null) {
                throw new WalkingException("Collection reference did not return element handler");
            }
            this.pushToStack(elementGraph);
        }
    }

    @Override
    public void finishingCollectionElements(CollectionElementDefinition elementDefinition) {
    }

    @Override
    public void finishingCollection(CollectionDefinition collectionDefinition) {
        CollectionReference collectionReference = this.popFromCollectionStack();
        if (!collectionReference.getCollectionPersister().equals(collectionDefinition.getCollectionPersister())) {
            throw new WalkingException("Mismatched FetchOwner from stack on pop");
        }
        log.tracef("%s Finished collection : %s", (Object)StringHelper.repeat("<<", this.fetchOwnerStack.size()), (Object)collectionDefinition.getCollectionPersister().getRole());
    }

    @Override
    public void startingComposite(CompositionDefinition compositionDefinition) {
        log.tracef("%s Starting composition : %s", (Object)StringHelper.repeat(">>", this.fetchOwnerStack.size()), (Object)compositionDefinition.getName());
        if (this.fetchOwnerStack.isEmpty()) {
            throw new HibernateException("A component cannot be the root of a walk nor a graph");
        }
    }

    @Override
    public void finishingComposite(CompositionDefinition compositionDefinition) {
        FetchOwner poppedFetchOwner = this.popFromStack();
        if (!CompositeFetch.class.isInstance(poppedFetchOwner)) {
            throw new WalkingException("Mismatched FetchOwner from stack on pop");
        }
        log.tracef("%s Finished composition : %s", (Object)StringHelper.repeat("<<", this.fetchOwnerStack.size()), (Object)compositionDefinition.getName());
    }

    @Override
    public boolean startingAttribute(AttributeDefinition attributeDefinition) {
        boolean isBasicType;
        log.tracef("%s Starting attribute %s", (Object)StringHelper.repeat(">>", this.fetchOwnerStack.size()), (Object)attributeDefinition);
        Type attributeType = attributeDefinition.getType();
        boolean isComponentType = attributeType.isComponentType();
        boolean isAssociationType = attributeType.isAssociationType();
        boolean bl = isBasicType = !isComponentType && !isAssociationType;
        if (isBasicType) {
            return true;
        }
        if (isAssociationType) {
            return this.handleAssociationAttribute((AssociationAttributeDefinition)attributeDefinition);
        }
        return this.handleCompositeAttribute((CompositionDefinition)attributeDefinition);
    }

    @Override
    public void finishingAttribute(AttributeDefinition attributeDefinition) {
        log.tracef("%s Finishing up attribute : %s", (Object)StringHelper.repeat("<<", this.fetchOwnerStack.size()), (Object)attributeDefinition);
    }

    @Override
    public boolean isDuplicateAssociationKey(AssociationKey associationKey) {
        return this.fetchedAssociationKeyOwnerMap.containsKey(associationKey);
    }

    @Override
    public void associationKeyRegistered(AssociationKey associationKey) {
        this.fetchedAssociationKeyOwnerMap.put(associationKey, this.currentFetchOwner());
    }

    @Override
    public void foundCircularAssociation(AssociationAttributeDefinition attributeDefinition) {
        AssociationKey associationKey = attributeDefinition.getAssociationKey();
        FetchOwner fetchOwner = this.fetchedAssociationKeyOwnerMap.get(associationKey);
        if (fetchOwner == null) {
            throw new IllegalStateException(String.format("Expecting AssociationKey->FetchOwner mapping for %s", associationKey.toString()));
        }
        this.currentFetchOwner().addFetch(new CircularFetch(this.currentFetchOwner(), fetchOwner, attributeDefinition));
    }

    @Override
    public void foundAny(AssociationAttributeDefinition attributeDefinition, AnyMappingDefinition anyDefinition) {
        FetchStrategy fetchStrategy = this.determineFetchPlan(attributeDefinition);
        FetchOwner fetchOwner = this.currentFetchOwner();
        fetchOwner.validateFetchPlan(fetchStrategy, attributeDefinition);
        fetchOwner.buildAnyFetch(attributeDefinition, anyDefinition, fetchStrategy, this);
    }

    protected boolean handleCompositeAttribute(CompositionDefinition attributeDefinition) {
        FetchOwner fetchOwner = this.currentFetchOwner();
        CompositeFetch fetch = fetchOwner.buildCompositeFetch(attributeDefinition, this);
        this.pushToStack(fetch);
        return true;
    }

    protected boolean handleAssociationAttribute(AssociationAttributeDefinition attributeDefinition) {
        AbstractPlanNode associationFetch;
        FetchStrategy fetchStrategy = this.determineFetchPlan(attributeDefinition);
        if (fetchStrategy.getStyle() != FetchStyle.JOIN) {
            return false;
        }
        FetchOwner fetchOwner = this.currentFetchOwner();
        fetchOwner.validateFetchPlan(fetchStrategy, attributeDefinition);
        AssociationAttributeDefinition.AssociationNature nature = attributeDefinition.getAssociationNature();
        if (nature == AssociationAttributeDefinition.AssociationNature.ANY) {
            return false;
        }
        if (nature == AssociationAttributeDefinition.AssociationNature.ENTITY) {
            associationFetch = fetchOwner.buildEntityFetch(attributeDefinition, fetchStrategy, this);
        } else {
            associationFetch = fetchOwner.buildCollectionFetch(attributeDefinition, fetchStrategy, this);
            this.pushToCollectionStack((CollectionReference)((Object)associationFetch));
        }
        if (FetchOwner.class.isInstance(associationFetch)) {
            this.pushToStack((FetchOwner)((Object)associationFetch));
        }
        return true;
    }

    protected abstract FetchStrategy determineFetchPlan(AssociationAttributeDefinition var1);

    protected int currentDepth() {
        return this.fetchOwnerStack.size();
    }

    protected boolean isTooManyCollections() {
        return false;
    }

    private void pushToStack(FetchOwner fetchOwner) {
        log.trace((Object)("Pushing fetch owner to stack : " + fetchOwner));
        this.mdcStack().push(fetchOwner.getPropertyPath());
        this.fetchOwnerStack.addFirst(fetchOwner);
    }

    private MDCStack mdcStack() {
        return (MDCStack)MDC.get((String)MDC_KEY);
    }

    private FetchOwner popFromStack() {
        FetchOwner last = this.fetchOwnerStack.removeFirst();
        log.trace((Object)("Popped fetch owner from stack : " + last));
        this.mdcStack().pop();
        if (FetchStackAware.class.isInstance(last)) {
            ((FetchStackAware)((Object)last)).poppedFromStack();
        }
        return last;
    }

    private void pushToCollectionStack(CollectionReference collectionReference) {
        log.trace((Object)("Pushing collection reference to stack : " + collectionReference));
        this.mdcStack().push(collectionReference.getPropertyPath());
        this.collectionReferenceStack.addFirst(collectionReference);
    }

    private CollectionReference popFromCollectionStack() {
        CollectionReference last = this.collectionReferenceStack.removeFirst();
        log.trace((Object)("Popped collection reference from stack : " + last));
        this.mdcStack().pop();
        if (FetchStackAware.class.isInstance(last)) {
            ((FetchStackAware)((Object)last)).poppedFromStack();
        }
        return last;
    }

    protected abstract EntityReturn buildRootEntityReturn(EntityDefinition var1);

    protected abstract CollectionReturn buildRootCollectionReturn(CollectionDefinition var1);

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory();
    }

    public static class MDCStack {
        private ArrayDeque<PropertyPath> pathStack = new ArrayDeque();

        public void push(PropertyPath path) {
            this.pathStack.addFirst(path);
        }

        public void pop() {
            this.pathStack.removeFirst();
        }

        public String toString() {
            PropertyPath path = this.pathStack.peekFirst();
            return path == null ? "<no-path>" : path.getFullPath();
        }
    }

    private static class IdentifierDescriptionImpl
    implements IdentifierDescription {
        private final EntityReference entityReference;
        private final Fetch[] identifierFetches;
        private final Map<Fetch, HydratedCompoundValueHandler> fetchToHydratedStateExtractorMap;

        private IdentifierDescriptionImpl(EntityReference entityReference, Fetch[] identifierFetches, Map<Fetch, HydratedCompoundValueHandler> fetchToHydratedStateExtractorMap) {
            this.entityReference = entityReference;
            this.identifierFetches = identifierFetches;
            this.fetchToHydratedStateExtractorMap = fetchToHydratedStateExtractorMap;
        }

        @Override
        public Fetch[] getFetches() {
            return this.identifierFetches;
        }
    }

    protected static class NonEncapsulatedIdentifierAttributeCollector
    extends AbstractIdentifierAttributeCollector {
        private final PropertyPath propertyPath;

        public NonEncapsulatedIdentifierAttributeCollector(SessionFactoryImplementor sessionfactory, EntityReference entityReference) {
            super(sessionfactory, entityReference);
            this.propertyPath = ((FetchOwner)((Object)entityReference)).getPropertyPath().append("<id>");
        }

        @Override
        protected IdentifierDescription buildIdentifierDescription() {
            return new IdentifierDescriptionImpl(this.entityReference, this.getFetches(), this.fetchToHydratedStateExtractorMap);
        }

        @Override
        public PropertyPath getPropertyPath() {
            return this.propertyPath;
        }
    }

    protected static class EncapsulatedIdentifierAttributeCollector
    extends AbstractIdentifierAttributeCollector {
        private final PropertyPath propertyPath;

        public EncapsulatedIdentifierAttributeCollector(SessionFactoryImplementor sessionFactory, EntityReference entityReference) {
            super(sessionFactory, entityReference);
            this.propertyPath = ((FetchOwner)((Object)entityReference)).getPropertyPath();
        }

        @Override
        protected IdentifierDescription buildIdentifierDescription() {
            return new IdentifierDescriptionImpl(this.entityReference, this.getFetches(), null);
        }

        @Override
        public PropertyPath getPropertyPath() {
            return this.propertyPath;
        }
    }

    protected static abstract class AbstractIdentifierAttributeCollector
    extends AbstractFetchOwner
    implements FetchOwner,
    EntityReference,
    FetchStackAware {
        protected final EntityReference entityReference;
        private final EntityPersisterBasedSqlSelectFragmentResolver sqlSelectFragmentResolver;
        protected final Map<Fetch, HydratedCompoundValueHandler> fetchToHydratedStateExtractorMap = new HashMap<Fetch, HydratedCompoundValueHandler>();

        public AbstractIdentifierAttributeCollector(SessionFactoryImplementor sessionFactory, EntityReference entityReference) {
            super(sessionFactory);
            this.entityReference = entityReference;
            this.sqlSelectFragmentResolver = new EntityPersisterBasedSqlSelectFragmentResolver((Queryable)entityReference.getEntityPersister());
        }

        @Override
        public LockMode getLockMode() {
            return this.entityReference.getLockMode();
        }

        @Override
        public EntityReference getEntityReference() {
            return this;
        }

        @Override
        public EntityPersister getEntityPersister() {
            return this.entityReference.getEntityPersister();
        }

        @Override
        public IdentifierDescription getIdentifierDescription() {
            return this.entityReference.getIdentifierDescription();
        }

        @Override
        public CollectionFetch buildCollectionFetch(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
            throw new WalkingException("Entity identifier cannot contain persistent collections");
        }

        @Override
        public AnyFetch buildAnyFetch(AttributeDefinition attribute, AnyMappingDefinition anyDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
            throw new WalkingException("Entity identifier cannot contain ANY type mappings");
        }

        @Override
        public EntityFetch buildEntityFetch(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
            if (EntityFetch.class.isInstance(this.entityReference)) {
                EntityFetch entityFetch = (EntityFetch)this.entityReference;
                FetchOwner entityFetchOwner = entityFetch.getOwner();
                EntityType attributeDefinitionTypeAsEntityType = (EntityType)attributeDefinition.getType();
                boolean sameType = attributeDefinitionTypeAsEntityType.getAssociatedEntityName().equals(entityFetchOwner.retrieveFetchSourcePersister().getEntityName());
                if (sameType) {
                    return new KeyManyToOneBidirectionalEntityFetch(this.sessionFactory(), LockMode.READ, this, attributeDefinition, (EntityReference)((Object)entityFetchOwner), fetchStrategy);
                }
            }
            EntityFetch fetch = super.buildEntityFetch(attributeDefinition, fetchStrategy, loadPlanBuildingContext);
            this.fetchToHydratedStateExtractorMap.put(fetch, attributeDefinition.getHydratedCompoundValueExtractor());
            return fetch;
        }

        @Override
        public Type getType(Fetch fetch) {
            return fetch.getFetchedType();
        }

        @Override
        public boolean isNullable(Fetch fetch) {
            return fetch.isNullable();
        }

        @Override
        public String[] toSqlSelectFragments(Fetch fetch, String alias) {
            return fetch.toSqlSelectFragments(alias);
        }

        @Override
        public SqlSelectFragmentResolver toSqlSelectFragmentResolver() {
            return this.sqlSelectFragmentResolver;
        }

        @Override
        public void poppedFromStack() {
            IdentifierDescription identifierDescription = this.buildIdentifierDescription();
            this.entityReference.injectIdentifierDescription(identifierDescription);
        }

        protected abstract IdentifierDescription buildIdentifierDescription();

        @Override
        public void validateFetchPlan(FetchStrategy fetchStrategy, AttributeDefinition attributeDefinition) {
            ((FetchOwner)((Object)this.entityReference)).validateFetchPlan(fetchStrategy, attributeDefinition);
        }

        @Override
        public EntityPersister retrieveFetchSourcePersister() {
            return ((FetchOwner)((Object)this.entityReference)).retrieveFetchSourcePersister();
        }

        @Override
        public void injectIdentifierDescription(IdentifierDescription identifierDescription) {
            throw new WalkingException("IdentifierDescription collector should not get injected with IdentifierDescription");
        }
    }

    public static interface FetchStackAware {
        public void poppedFromStack();
    }

    public static class CircularFetch
    implements BidirectionalEntityFetch,
    EntityReference,
    Fetch {
        private final FetchOwner circularFetchOwner;
        private final FetchOwner associationOwner;
        private final AttributeDefinition attributeDefinition;
        private final EntityReference targetEntityReference;
        private final FetchStrategy fetchStrategy = new FetchStrategy(FetchTiming.IMMEDIATE, FetchStyle.JOIN);

        public CircularFetch(FetchOwner circularFetchOwner, FetchOwner associationOwner, AttributeDefinition attributeDefinition) {
            this.circularFetchOwner = circularFetchOwner;
            this.associationOwner = associationOwner;
            this.attributeDefinition = attributeDefinition;
            this.targetEntityReference = CircularFetch.resolveEntityReference(associationOwner);
        }

        @Override
        public EntityReference getTargetEntityReference() {
            return this.targetEntityReference;
        }

        protected static EntityReference resolveEntityReference(FetchOwner owner) {
            if (EntityReference.class.isInstance(owner)) {
                return (EntityReference)((Object)owner);
            }
            if (CompositeFetch.class.isInstance(owner)) {
                return CircularFetch.resolveEntityReference(((CompositeFetch)owner).getOwner());
            }
            throw new UnsupportedOperationException("Unexpected FetchOwner type [" + owner + "] encountered trying to build circular fetch");
        }

        @Override
        public FetchOwner getOwner() {
            return this.circularFetchOwner;
        }

        @Override
        public PropertyPath getPropertyPath() {
            return null;
        }

        @Override
        public Type getFetchedType() {
            return this.attributeDefinition.getType();
        }

        @Override
        public FetchStrategy getFetchStrategy() {
            return this.fetchStrategy;
        }

        @Override
        public boolean isNullable() {
            return this.attributeDefinition.isNullable();
        }

        @Override
        public String getAdditionalJoinConditions() {
            return null;
        }

        @Override
        public String[] toSqlSelectFragments(String alias) {
            return new String[0];
        }

        @Override
        public Fetch makeCopy(CopyContext copyContext, FetchOwner fetchOwnerCopy) {
            return null;
        }

        @Override
        public LockMode getLockMode() {
            return this.targetEntityReference.getLockMode();
        }

        @Override
        public EntityReference getEntityReference() {
            return this.targetEntityReference;
        }

        @Override
        public EntityPersister getEntityPersister() {
            return this.targetEntityReference.getEntityPersister();
        }

        @Override
        public IdentifierDescription getIdentifierDescription() {
            return this.targetEntityReference.getIdentifierDescription();
        }

        @Override
        public void injectIdentifierDescription(IdentifierDescription identifierDescription) {
            throw new IllegalStateException("IdentifierDescription should never be injected from circular fetch side");
        }
    }
}

