/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan.spi.AbstractFetchOwner;
import org.hibernate.loader.plan.spi.CollectionReference;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.EntityPersisterBasedSqlSelectFragmentResolver;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.FetchableCollectionIndex;
import org.hibernate.loader.plan.spi.IdentifierDescription;
import org.hibernate.loader.plan.spi.SqlSelectFragmentResolver;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.walking.spi.AttributeDefinition;
import org.hibernate.type.AssociationType;

public class EntityIndexGraph
extends AbstractFetchOwner
implements FetchableCollectionIndex,
EntityReference {
    private final CollectionReference collectionReference;
    private final CollectionPersister collectionPersister;
    private final AssociationType indexType;
    private final EntityPersister indexPersister;
    private final PropertyPath propertyPath;
    private final EntityPersisterBasedSqlSelectFragmentResolver sqlSelectFragmentResolver;
    private IdentifierDescription identifierDescription;

    public EntityIndexGraph(SessionFactoryImplementor sessionFactory, CollectionReference collectionReference, PropertyPath collectionPath) {
        super(sessionFactory);
        this.collectionReference = collectionReference;
        this.collectionPersister = collectionReference.getCollectionPersister();
        this.indexType = (AssociationType)this.collectionPersister.getIndexType();
        this.indexPersister = (EntityPersister)((Object)this.indexType.getAssociatedJoinable(this.sessionFactory()));
        this.propertyPath = collectionPath.append("<index>");
        this.sqlSelectFragmentResolver = new EntityPersisterBasedSqlSelectFragmentResolver((Queryable)this.indexPersister);
    }

    public EntityIndexGraph(EntityIndexGraph original, CopyContext copyContext) {
        super(original, copyContext);
        this.collectionReference = original.collectionReference;
        this.collectionPersister = original.collectionReference.getCollectionPersister();
        this.indexType = original.indexType;
        this.indexPersister = original.indexPersister;
        this.propertyPath = original.propertyPath;
        this.sqlSelectFragmentResolver = original.sqlSelectFragmentResolver;
    }

    @Override
    public LockMode getLockMode() {
        return null;
    }

    @Override
    public EntityReference getEntityReference() {
        return this;
    }

    @Override
    public EntityPersister getEntityPersister() {
        return this.indexPersister;
    }

    @Override
    public IdentifierDescription getIdentifierDescription() {
        return this.identifierDescription;
    }

    @Override
    public void validateFetchPlan(FetchStrategy fetchStrategy, AttributeDefinition attributeDefinition) {
    }

    @Override
    public EntityPersister retrieveFetchSourcePersister() {
        return this.indexPersister;
    }

    @Override
    public PropertyPath getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public void injectIdentifierDescription(IdentifierDescription identifierDescription) {
        this.identifierDescription = identifierDescription;
    }

    @Override
    public EntityIndexGraph makeCopy(CopyContext copyContext) {
        return new EntityIndexGraph(this, copyContext);
    }

    @Override
    public CollectionReference getCollectionReference() {
        return this.collectionReference;
    }

    @Override
    public SqlSelectFragmentResolver toSqlSelectFragmentResolver() {
        return this.sqlSelectFragmentResolver;
    }
}

