/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan.spi.AbstractFetchOwner;
import org.hibernate.loader.plan.spi.BidirectionalEntityFetch;
import org.hibernate.loader.plan.spi.CollectionFetch;
import org.hibernate.loader.plan.spi.CollectionReference;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.EntityFetch;
import org.hibernate.loader.plan.spi.EntityPersisterBasedSqlSelectFragmentResolver;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.hibernate.loader.plan.spi.FetchableCollectionElement;
import org.hibernate.loader.plan.spi.IdentifierDescription;
import org.hibernate.loader.plan.spi.SqlSelectFragmentResolver;
import org.hibernate.loader.plan.spi.build.LoadPlanBuildingContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.hibernate.persister.walking.spi.AttributeDefinition;
import org.hibernate.type.AssociationType;
import org.hibernate.type.EntityType;

public class EntityElementGraph
extends AbstractFetchOwner
implements FetchableCollectionElement,
EntityReference {
    private final CollectionReference collectionReference;
    private final CollectionPersister collectionPersister;
    private final AssociationType elementType;
    private final EntityPersister elementPersister;
    private final PropertyPath propertyPath;
    private final EntityPersisterBasedSqlSelectFragmentResolver sqlSelectFragmentResolver;
    private IdentifierDescription identifierDescription;

    public EntityElementGraph(SessionFactoryImplementor sessionFactory, CollectionReference collectionReference, PropertyPath collectionPath) {
        super(sessionFactory);
        this.collectionReference = collectionReference;
        this.collectionPersister = collectionReference.getCollectionPersister();
        this.elementType = (AssociationType)this.collectionPersister.getElementType();
        this.elementPersister = (EntityPersister)((Object)this.elementType.getAssociatedJoinable(this.sessionFactory()));
        this.propertyPath = collectionPath;
        this.sqlSelectFragmentResolver = new EntityPersisterBasedSqlSelectFragmentResolver((Queryable)this.elementPersister);
    }

    public EntityElementGraph(EntityElementGraph original, CopyContext copyContext) {
        super(original, copyContext);
        this.collectionReference = original.collectionReference;
        this.collectionPersister = original.collectionReference.getCollectionPersister();
        this.elementType = original.elementType;
        this.elementPersister = original.elementPersister;
        this.propertyPath = original.propertyPath;
        this.sqlSelectFragmentResolver = original.sqlSelectFragmentResolver;
    }

    @Override
    public LockMode getLockMode() {
        return null;
    }

    @Override
    public EntityReference getEntityReference() {
        return this;
    }

    @Override
    public EntityPersister getEntityPersister() {
        return this.elementPersister;
    }

    @Override
    public IdentifierDescription getIdentifierDescription() {
        return this.identifierDescription;
    }

    @Override
    public void validateFetchPlan(FetchStrategy fetchStrategy, AttributeDefinition attributeDefinition) {
    }

    @Override
    public EntityPersister retrieveFetchSourcePersister() {
        return this.elementPersister;
    }

    @Override
    public PropertyPath getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public void injectIdentifierDescription(IdentifierDescription identifierDescription) {
        this.identifierDescription = identifierDescription;
    }

    @Override
    public EntityElementGraph makeCopy(CopyContext copyContext) {
        return new EntityElementGraph(this, copyContext);
    }

    @Override
    public CollectionReference getCollectionReference() {
        return this.collectionReference;
    }

    public String toString() {
        return "EntityElementGraph(collection=" + this.collectionPersister.getRole() + ", type=" + this.elementPersister.getEntityName() + ")";
    }

    @Override
    public SqlSelectFragmentResolver toSqlSelectFragmentResolver() {
        return this.sqlSelectFragmentResolver;
    }

    @Override
    public EntityFetch buildEntityFetch(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
        boolean sameType;
        FetchOwner collectionOwner;
        EntityType attributeType = (EntityType)attributeDefinition.getType();
        FetchOwner fetchOwner = collectionOwner = CollectionFetch.class.isInstance(this.collectionReference) ? ((CollectionFetch)this.collectionReference).getOwner() : null;
        if (collectionOwner != null && (sameType = attributeType.getAssociatedEntityName().equals(collectionOwner.retrieveFetchSourcePersister().getEntityName()))) {
            return new BidirectionalEntityElementGraphFetch(this.sessionFactory(), LockMode.READ, this, attributeDefinition, fetchStrategy, collectionOwner);
        }
        return super.buildEntityFetch(attributeDefinition, fetchStrategy, loadPlanBuildingContext);
    }

    private class BidirectionalEntityElementGraphFetch
    extends EntityFetch
    implements BidirectionalEntityFetch {
        private final FetchOwner collectionOwner;

        public BidirectionalEntityElementGraphFetch(SessionFactoryImplementor sessionFactory, LockMode lockMode, FetchOwner owner, AttributeDefinition fetchedAttribute, FetchStrategy fetchStrategy, FetchOwner collectionOwner) {
            super(sessionFactory, lockMode, owner, fetchedAttribute, fetchStrategy);
            this.collectionOwner = collectionOwner;
        }

        @Override
        public EntityReference getTargetEntityReference() {
            return (EntityReference)((Object)this.collectionOwner);
        }
    }
}

