/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import java.util.Arrays;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.plan.spi.SqlSelectFragmentResolver;
import org.hibernate.persister.walking.spi.AttributeDefinition;
import org.hibernate.persister.walking.spi.WalkingException;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public class CompositeBasedSqlSelectFragmentResolver
implements SqlSelectFragmentResolver {
    private final SessionFactoryImplementor sessionFactory;
    private final CompositeType compositeType;
    private final BaseSqlSelectFragmentResolver baseResolver;

    public CompositeBasedSqlSelectFragmentResolver(SessionFactoryImplementor sessionFactory, CompositeType compositeType, BaseSqlSelectFragmentResolver baseResolver) {
        this.sessionFactory = sessionFactory;
        this.compositeType = compositeType;
        this.baseResolver = baseResolver;
    }

    @Override
    public String[] toSqlSelectFragments(String alias, AttributeDefinition attributeDefinition) {
        int subIndex = -1;
        int selectFragmentRangeStart = 0;
        int selectFragmentRangeEnd = -1;
        for (int i = 0; i < this.compositeType.getPropertyNames().length; ++i) {
            Type type = this.compositeType.getSubtypes()[i];
            int typeColSpan = type.getColumnSpan(this.sessionFactory);
            if (this.compositeType.getPropertyNames()[i].equals(attributeDefinition.getName())) {
                subIndex = i;
                selectFragmentRangeEnd = selectFragmentRangeStart + typeColSpan;
                break;
            }
            selectFragmentRangeStart += typeColSpan;
        }
        if (subIndex < 0) {
            throw new WalkingException(String.format("Owner property [%s] not found in composite properties [%s]", attributeDefinition.getName(), Arrays.asList(this.compositeType.getPropertyNames())));
        }
        return Arrays.copyOfRange(this.baseResolver.toSqlSelectFragments(alias), selectFragmentRangeStart, selectFragmentRangeEnd);
    }

    protected static interface BaseSqlSelectFragmentResolver {
        public String[] toSqlSelectFragments(String var1);
    }
}

