/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.loader.plan.spi.AbstractCollectionReference;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.hibernate.persister.walking.spi.AttributeDefinition;
import org.hibernate.type.CollectionType;
import org.jboss.logging.Logger;

public class CollectionFetch
extends AbstractCollectionReference
implements Fetch {
    private static final Logger log = CoreLogging.logger(CollectionFetch.class);
    private final FetchOwner fetchOwner;
    private final AttributeDefinition fetchedAttribute;
    private final FetchStrategy fetchStrategy;

    public CollectionFetch(SessionFactoryImplementor sessionFactory, LockMode lockMode, FetchOwner fetchOwner, FetchStrategy fetchStrategy, AttributeDefinition fetchedAttribute) {
        super(sessionFactory, lockMode, sessionFactory.getCollectionPersister(((CollectionType)fetchedAttribute.getType()).getRole()), fetchOwner.getPropertyPath().append(fetchedAttribute.getName()), (EntityReference)((Object)fetchOwner));
        this.fetchOwner = fetchOwner;
        this.fetchedAttribute = fetchedAttribute;
        this.fetchStrategy = fetchStrategy;
        fetchOwner.addFetch(this);
    }

    protected CollectionFetch(CollectionFetch original, CopyContext copyContext, FetchOwner fetchOwnerCopy) {
        super(original, copyContext);
        this.fetchOwner = fetchOwnerCopy;
        this.fetchedAttribute = original.fetchedAttribute;
        this.fetchStrategy = original.fetchStrategy;
    }

    @Override
    public FetchOwner getOwner() {
        return this.fetchOwner;
    }

    @Override
    public CollectionType getFetchedType() {
        return (CollectionType)this.fetchedAttribute.getType();
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public String getAdditionalJoinConditions() {
        return null;
    }

    @Override
    public String[] toSqlSelectFragments(String alias) {
        return this.getOwner().toSqlSelectFragmentResolver().toSqlSelectFragments(alias, this.fetchedAttribute);
    }

    @Override
    public FetchStrategy getFetchStrategy() {
        return this.fetchStrategy;
    }

    @Override
    public CollectionFetch makeCopy(CopyContext copyContext, FetchOwner fetchOwnerCopy) {
        copyContext.getReturnGraphVisitationStrategy().startingCollectionFetch(this);
        CollectionFetch copy = new CollectionFetch(this, copyContext, fetchOwnerCopy);
        copyContext.getReturnGraphVisitationStrategy().finishingCollectionFetch(this);
        return copy;
    }
}

