/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan.spi.AbstractPlanNode;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.hibernate.persister.walking.spi.AnyMappingDefinition;
import org.hibernate.persister.walking.spi.AttributeDefinition;
import org.hibernate.type.AnyType;

public class AnyFetch
extends AbstractPlanNode
implements Fetch {
    private final FetchOwner owner;
    private final AttributeDefinition fetchedAttribute;
    private final AnyMappingDefinition definition;
    private final FetchStrategy fetchStrategy;
    private final PropertyPath propertyPath;

    public AnyFetch(SessionFactoryImplementor sessionFactory, FetchOwner owner, AttributeDefinition ownerProperty, AnyMappingDefinition definition, FetchStrategy fetchStrategy) {
        super(sessionFactory);
        this.owner = owner;
        this.fetchedAttribute = ownerProperty;
        this.definition = definition;
        this.fetchStrategy = fetchStrategy;
        this.propertyPath = owner.getPropertyPath().append(ownerProperty.getName());
        owner.addFetch(this);
    }

    protected AnyFetch(AnyFetch original, CopyContext copyContext, FetchOwner fetchOwnerCopy) {
        super(original);
        this.owner = fetchOwnerCopy;
        this.fetchedAttribute = original.fetchedAttribute;
        this.definition = original.definition;
        this.fetchStrategy = original.fetchStrategy;
        this.propertyPath = original.propertyPath;
    }

    @Override
    public FetchOwner getOwner() {
        return this.owner;
    }

    @Override
    public AnyType getFetchedType() {
        return (AnyType)this.fetchedAttribute.getType();
    }

    @Override
    public boolean isNullable() {
        return this.owner.isNullable(this);
    }

    @Override
    public String[] toSqlSelectFragments(String alias) {
        return this.owner.toSqlSelectFragments(this, alias);
    }

    @Override
    public String getAdditionalJoinConditions() {
        return null;
    }

    @Override
    public FetchStrategy getFetchStrategy() {
        return this.fetchStrategy;
    }

    @Override
    public PropertyPath getPropertyPath() {
        return this.propertyPath;
    }

    @Override
    public AnyFetch makeCopy(CopyContext copyContext, FetchOwner fetchOwnerCopy) {
        copyContext.getReturnGraphVisitationStrategy().startingAnyFetch(this);
        AnyFetch copy = new AnyFetch(this, copyContext, fetchOwnerCopy);
        copyContext.getReturnGraphVisitationStrategy().startingAnyFetch(this);
        return copy;
    }
}

