/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import org.hibernate.HibernateException;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan.spi.AbstractFetchOwner;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.hibernate.persister.walking.spi.AttributeDefinition;
import org.hibernate.type.Type;

public abstract class AbstractSingularAttributeFetch
extends AbstractFetchOwner
implements Fetch {
    private final FetchOwner owner;
    private final AttributeDefinition fetchedAttribute;
    private final FetchStrategy fetchStrategy;
    private final PropertyPath propertyPath;

    public AbstractSingularAttributeFetch(SessionFactoryImplementor factory, FetchOwner owner, AttributeDefinition fetchedAttribute, FetchStrategy fetchStrategy) {
        super(factory);
        this.owner = owner;
        this.fetchedAttribute = fetchedAttribute;
        this.fetchStrategy = fetchStrategy;
        owner.addFetch(this);
        this.propertyPath = owner.getPropertyPath().append(fetchedAttribute.getName());
    }

    public AbstractSingularAttributeFetch(AbstractSingularAttributeFetch original, CopyContext copyContext, FetchOwner fetchOwnerCopy) {
        super(original, copyContext);
        this.owner = fetchOwnerCopy;
        this.fetchedAttribute = original.fetchedAttribute;
        this.fetchStrategy = original.fetchStrategy;
        this.propertyPath = original.propertyPath;
    }

    @Override
    public FetchOwner getOwner() {
        return this.owner;
    }

    public AttributeDefinition getFetchedAttribute() {
        return this.fetchedAttribute;
    }

    @Override
    public Type getFetchedType() {
        return this.fetchedAttribute.getType();
    }

    @Override
    public boolean isNullable() {
        return this.fetchedAttribute.isNullable();
    }

    @Override
    public String[] toSqlSelectFragments(String alias) {
        return this.owner.toSqlSelectFragments(this, alias);
    }

    @Override
    public FetchStrategy getFetchStrategy() {
        return this.fetchStrategy;
    }

    @Override
    public String getAdditionalJoinConditions() {
        return null;
    }

    @Override
    public void validateFetchPlan(FetchStrategy fetchStrategy, AttributeDefinition attributeDefinition) {
        if (fetchStrategy.getStyle() == FetchStyle.JOIN && this.fetchStrategy.getStyle() != FetchStyle.JOIN) {
            throw new HibernateException(String.format("Cannot specify join fetch from owner [%s] that is a non-joined fetch : %s", this.getPropertyPath().getFullPath(), attributeDefinition.getName()));
        }
    }

    @Override
    public PropertyPath getPropertyPath() {
        return this.propertyPath;
    }

    public String toString() {
        return "Fetch(" + this.propertyPath.getFullPath() + ")";
    }
}

