/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.plan.internal.LoadPlanBuildingHelper;
import org.hibernate.loader.plan.spi.AbstractPlanNode;
import org.hibernate.loader.plan.spi.AnyFetch;
import org.hibernate.loader.plan.spi.CollectionFetch;
import org.hibernate.loader.plan.spi.CompositeFetch;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.EntityFetch;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.hibernate.loader.plan.spi.build.LoadPlanBuildingContext;
import org.hibernate.persister.walking.spi.AnyMappingDefinition;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.hibernate.persister.walking.spi.AttributeDefinition;
import org.hibernate.persister.walking.spi.CompositionDefinition;
import org.hibernate.type.Type;

public abstract class AbstractFetchOwner
extends AbstractPlanNode
implements FetchOwner {
    private List<Fetch> fetches;

    public AbstractFetchOwner(SessionFactoryImplementor factory) {
        super(factory);
        this.validate();
    }

    private void validate() {
    }

    protected AbstractFetchOwner(AbstractFetchOwner original, CopyContext copyContext) {
        super(original);
        this.validate();
        copyContext.getReturnGraphVisitationStrategy().startingFetches(original);
        if (this.fetches == null || this.fetches.size() == 0) {
            this.fetches = Collections.emptyList();
        } else {
            ArrayList<Fetch> fetchesCopy = new ArrayList<Fetch>();
            for (Fetch fetch : this.fetches) {
                fetchesCopy.add(fetch.makeCopy(copyContext, this));
            }
            this.fetches = fetchesCopy;
        }
        copyContext.getReturnGraphVisitationStrategy().finishingFetches(original);
    }

    @Override
    public void addFetch(Fetch fetch) {
        if (fetch.getOwner() != this) {
            throw new IllegalArgumentException("Fetch and owner did not match");
        }
        if (this.fetches == null) {
            this.fetches = new ArrayList<Fetch>();
        }
        this.fetches.add(fetch);
    }

    @Override
    public Fetch[] getFetches() {
        return this.fetches == null ? NO_FETCHES : this.fetches.toArray(new Fetch[this.fetches.size()]);
    }

    @Override
    public boolean isNullable(Fetch fetch) {
        return fetch.isNullable();
    }

    @Override
    public Type getType(Fetch fetch) {
        return fetch.getFetchedType();
    }

    @Override
    public String[] toSqlSelectFragments(Fetch fetch, String alias) {
        return fetch.toSqlSelectFragments(alias);
    }

    @Override
    public AnyFetch buildAnyFetch(AttributeDefinition attribute, AnyMappingDefinition anyDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
        return LoadPlanBuildingHelper.buildAnyFetch(this, attribute, anyDefinition, fetchStrategy, loadPlanBuildingContext);
    }

    @Override
    public CollectionFetch buildCollectionFetch(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
        return LoadPlanBuildingHelper.buildStandardCollectionFetch(this, attributeDefinition, fetchStrategy, loadPlanBuildingContext);
    }

    @Override
    public EntityFetch buildEntityFetch(AssociationAttributeDefinition attributeDefinition, FetchStrategy fetchStrategy, LoadPlanBuildingContext loadPlanBuildingContext) {
        return LoadPlanBuildingHelper.buildStandardEntityFetch(this, attributeDefinition, fetchStrategy, loadPlanBuildingContext);
    }

    @Override
    public CompositeFetch buildCompositeFetch(CompositionDefinition attributeDefinition, LoadPlanBuildingContext loadPlanBuildingContext) {
        return LoadPlanBuildingHelper.buildStandardCompositeFetch(this, attributeDefinition, loadPlanBuildingContext);
    }
}

