/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.exec.spi;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.plan.exec.internal.AliasResolutionContextImpl;
import org.hibernate.loader.plan.exec.internal.Helper;
import org.hibernate.loader.plan.exec.internal.LoadQueryBuilderHelper;
import org.hibernate.loader.plan.exec.process.internal.CollectionReferenceReader;
import org.hibernate.loader.plan.exec.process.internal.EntityIdentifierReader;
import org.hibernate.loader.plan.exec.process.internal.EntityIdentifierReaderImpl;
import org.hibernate.loader.plan.exec.process.internal.EntityReferenceReader;
import org.hibernate.loader.plan.exec.process.internal.EntityReturnReader;
import org.hibernate.loader.plan.exec.process.internal.ResultSetProcessingContextImpl;
import org.hibernate.loader.plan.exec.process.internal.ResultSetProcessorImpl;
import org.hibernate.loader.plan.exec.process.spi.AbstractRowReader;
import org.hibernate.loader.plan.exec.process.spi.ResultSetProcessor;
import org.hibernate.loader.plan.exec.query.internal.SelectStatementBuilder;
import org.hibernate.loader.plan.exec.query.spi.QueryBuildingParameters;
import org.hibernate.loader.plan.exec.spi.AliasResolutionContext;
import org.hibernate.loader.plan.exec.spi.LoadQueryDetails;
import org.hibernate.loader.plan.exec.spi.ReaderCollector;
import org.hibernate.loader.plan.exec.spi.RowReader;
import org.hibernate.loader.plan.spi.EntityReturn;
import org.hibernate.loader.plan.spi.LoadPlan;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.ConditionFragment;
import org.hibernate.sql.DisjunctionFragment;
import org.hibernate.sql.InFragment;

public class EntityLoadQueryDetails
implements LoadQueryDetails {
    private final LoadPlan loadPlan;
    private final String sqlStatement;
    private final ResultSetProcessor resultSetProcessor;

    public static EntityLoadQueryDetails makeForBatching(LoadPlan loadPlan, String[] keyColumnNames, QueryBuildingParameters buildingParameters, SessionFactoryImplementor factory) {
        int batchSize = buildingParameters.getBatchSize();
        boolean shouldUseOptionalEntityInformation = batchSize == 1;
        return new EntityLoadQueryDetails(loadPlan, keyColumnNames, shouldUseOptionalEntityInformation, buildingParameters, factory);
    }

    protected EntityLoadQueryDetails(LoadPlan loadPlan, String[] keyColumnNames, boolean shouldUseOptionalEntityInformation, QueryBuildingParameters buildingParameters, SessionFactoryImplementor factory) {
        this.loadPlan = loadPlan;
        SelectStatementBuilder select = new SelectStatementBuilder(factory.getDialect());
        EntityReturn rootReturn = Helper.INSTANCE.extractRootReturn(loadPlan, EntityReturn.class);
        AliasResolutionContextImpl aliasResolutionContext = new AliasResolutionContextImpl(factory);
        ReaderCollectorImpl readerCollector = new ReaderCollectorImpl();
        String[] keyColumnNamesToUse = keyColumnNames != null ? keyColumnNames : ((Queryable)rootReturn.getEntityPersister()).getIdentifierColumnNames();
        this.applyRootReturnSpecifics(select, keyColumnNamesToUse, rootReturn, factory, buildingParameters, aliasResolutionContext);
        readerCollector.addReader(new EntityReturnReader(rootReturn, aliasResolutionContext.resolveAliases(rootReturn), (EntityIdentifierReader)new EntityIdentifierReaderImpl(rootReturn, aliasResolutionContext.resolveAliases(rootReturn), Collections.<EntityReferenceReader>emptyList())));
        LoadQueryBuilderHelper.FetchStats fetchStats = LoadQueryBuilderHelper.applyJoinFetches(select, factory, rootReturn, buildingParameters, aliasResolutionContext, readerCollector);
        this.sqlStatement = select.toStatementString();
        this.resultSetProcessor = new ResultSetProcessorImpl(loadPlan, readerCollector.buildRowReader(), fetchStats.hasSubselectFetches());
    }

    protected void applyRootReturnSpecifics(SelectStatementBuilder select, String[] keyColumnNames, EntityReturn rootReturn, SessionFactoryImplementor factory, QueryBuildingParameters buildingParameters, AliasResolutionContext aliasResolutionContext) {
        String fromTableFragment;
        String rootAlias = aliasResolutionContext.resolveAliases(rootReturn).getTableAlias();
        OuterJoinLoadable rootLoadable = (OuterJoinLoadable)rootReturn.getEntityPersister();
        Queryable rootQueryable = (Queryable)rootReturn.getEntityPersister();
        this.applyKeyRestriction(select, rootAlias, keyColumnNames, buildingParameters.getBatchSize());
        select.appendRestrictions(rootQueryable.filterFragment(rootAlias, buildingParameters.getQueryInfluencers().getEnabledFilters()));
        select.appendRestrictions(rootLoadable.whereJoinFragment(rootAlias, true, true));
        select.appendSelectClauseFragment(rootLoadable.selectFragment(rootAlias, aliasResolutionContext.resolveAliases(rootReturn).getColumnAliases().getSuffix()));
        if (buildingParameters.getLockOptions() != null) {
            fromTableFragment = factory.getDialect().appendLockHint(buildingParameters.getLockOptions(), rootLoadable.fromTableFragment(rootAlias));
            select.setLockOptions(buildingParameters.getLockOptions());
        } else if (buildingParameters.getLockMode() != null) {
            fromTableFragment = factory.getDialect().appendLockHint(buildingParameters.getLockMode(), rootLoadable.fromTableFragment(rootAlias));
            select.setLockMode(buildingParameters.getLockMode());
        } else {
            fromTableFragment = rootLoadable.fromTableFragment(rootAlias);
        }
        select.appendFromClauseFragment(fromTableFragment + rootLoadable.fromJoinFragment(rootAlias, true, true));
    }

    private void applyKeyRestriction(SelectStatementBuilder select, String alias, String[] keyColumnNames, int batchSize) {
        if (keyColumnNames.length == 1) {
            InFragment in = new InFragment().setColumn(alias, keyColumnNames[0]);
            for (int i = 0; i < batchSize; ++i) {
                in.addValue("?");
            }
            select.appendRestrictions(in.toFragmentString());
        } else {
            ConditionFragment keyRestrictionBuilder = new ConditionFragment().setTableAlias(alias).setCondition(keyColumnNames, "?");
            String keyRestrictionFragment = keyRestrictionBuilder.toFragmentString();
            StringBuilder restrictions = new StringBuilder();
            if (batchSize == 1) {
                restrictions.append(keyRestrictionFragment);
            } else {
                restrictions.append('(');
                DisjunctionFragment df = new DisjunctionFragment();
                for (int i = 0; i < batchSize; ++i) {
                    df.addCondition(keyRestrictionFragment);
                }
                restrictions.append(df.toFragmentString());
                restrictions.append(')');
            }
            select.appendRestrictions(restrictions.toString());
        }
    }

    @Override
    public String getSqlStatement() {
        return this.sqlStatement;
    }

    @Override
    public ResultSetProcessor getResultSetProcessor() {
        return this.resultSetProcessor;
    }

    public static class EntityLoaderRowReader
    extends AbstractRowReader
    implements RowReader {
        private final EntityReturnReader rootReturnReader;
        private final List<EntityReferenceReader> entityReferenceReaders;
        private final List<CollectionReferenceReader> collectionReferenceReaders;

        public EntityLoaderRowReader(EntityReturnReader rootReturnReader, List<EntityReferenceReader> entityReferenceReaders, List<CollectionReferenceReader> collectionReferenceReaders) {
            this.rootReturnReader = rootReturnReader;
            this.entityReferenceReaders = entityReferenceReaders != null ? entityReferenceReaders : Collections.emptyList();
            this.collectionReferenceReaders = collectionReferenceReaders != null ? collectionReferenceReaders : Collections.emptyList();
        }

        @Override
        protected List<EntityReferenceReader> getEntityReferenceReaders() {
            return this.entityReferenceReaders;
        }

        @Override
        protected List<CollectionReferenceReader> getCollectionReferenceReaders() {
            return this.collectionReferenceReaders;
        }

        @Override
        protected Object readLogicalRow(ResultSet resultSet, ResultSetProcessingContextImpl context) throws SQLException {
            return this.rootReturnReader.read(resultSet, context);
        }
    }

    private static class ReaderCollectorImpl
    implements ReaderCollector {
        private EntityReturnReader rootReturnReader;
        private List<EntityReferenceReader> entityReferenceReaders;
        private List<CollectionReferenceReader> collectionReferenceReaders;

        private ReaderCollectorImpl() {
        }

        @Override
        public void addReader(CollectionReferenceReader collectionReferenceReader) {
            if (this.collectionReferenceReaders == null) {
                this.collectionReferenceReaders = new ArrayList<CollectionReferenceReader>();
            }
            this.collectionReferenceReaders.add(collectionReferenceReader);
        }

        @Override
        public void addReader(EntityReferenceReader entityReferenceReader) {
            if (EntityReturnReader.class.isInstance(entityReferenceReader)) {
                if (this.rootReturnReader != null) {
                    throw new IllegalStateException("Root return reader already set");
                }
                this.rootReturnReader = (EntityReturnReader)entityReferenceReader;
            }
            if (this.entityReferenceReaders == null) {
                this.entityReferenceReaders = new ArrayList<EntityReferenceReader>();
            }
            this.entityReferenceReaders.add(entityReferenceReader);
        }

        public RowReader buildRowReader() {
            return new EntityLoaderRowReader(this.rootReturnReader, this.entityReferenceReaders, this.collectionReferenceReaders);
        }
    }
}

