/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.exec.process.internal;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.LockMode;
import org.hibernate.engine.internal.TwoPhaseLoad;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.loader.plan.exec.process.internal.ResultSetProcessorHelper;
import org.hibernate.loader.plan.exec.process.spi.ResultSetProcessingContext;
import org.hibernate.loader.plan.exec.query.spi.NamedParameterContext;
import org.hibernate.loader.plan.exec.spi.LockModeResolver;
import org.hibernate.loader.plan.spi.CollectionFetch;
import org.hibernate.loader.plan.spi.CollectionReturn;
import org.hibernate.loader.plan.spi.CompositeFetch;
import org.hibernate.loader.plan.spi.EntityFetch;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.hibernate.loader.plan.spi.LoadPlan;
import org.hibernate.loader.plan.spi.visit.LoadPlanVisitationStrategyAdapter;
import org.hibernate.loader.plan.spi.visit.LoadPlanVisitor;
import org.hibernate.loader.spi.AfterLoadAction;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.type.EntityType;
import org.jboss.logging.Logger;

public class ResultSetProcessingContextImpl
implements ResultSetProcessingContext {
    private static final Logger LOG = Logger.getLogger(ResultSetProcessingContextImpl.class);
    private final ResultSet resultSet;
    private final SessionImplementor session;
    private final LoadPlan loadPlan;
    private final boolean readOnly;
    private final boolean shouldUseOptionalEntityInformation;
    private final boolean forceFetchLazyAttributes;
    private final boolean shouldReturnProxies;
    private final QueryParameters queryParameters;
    private final NamedParameterContext namedParameterContext;
    private final boolean hadSubselectFetches;
    private List<HydratedEntityRegistration> currentRowHydratedEntityRegistrationList;
    private Map<EntityPersister, Set<EntityKey>> subselectLoadableEntityKeyMap;
    private List<HydratedEntityRegistration> hydratedEntityRegistrationList;
    private LockModeResolver lockModeResolverDelegate = new LockModeResolver(){

        @Override
        public LockMode resolveLockMode(EntityReference entityReference) {
            return LockMode.NONE;
        }
    };
    private Map<EntityReference, ResultSetProcessingContext.EntityReferenceProcessingState> identifierResolutionContextMap;

    public ResultSetProcessingContextImpl(ResultSet resultSet, SessionImplementor session, LoadPlan loadPlan, boolean readOnly, boolean shouldUseOptionalEntityInformation, boolean forceFetchLazyAttributes, boolean shouldReturnProxies, QueryParameters queryParameters, NamedParameterContext namedParameterContext, boolean hadSubselectFetches) {
        this.resultSet = resultSet;
        this.session = session;
        this.loadPlan = loadPlan;
        this.readOnly = readOnly;
        this.shouldUseOptionalEntityInformation = shouldUseOptionalEntityInformation;
        this.forceFetchLazyAttributes = forceFetchLazyAttributes;
        this.shouldReturnProxies = shouldReturnProxies;
        this.queryParameters = queryParameters;
        this.namedParameterContext = namedParameterContext;
        this.hadSubselectFetches = hadSubselectFetches;
        if (shouldUseOptionalEntityInformation && queryParameters.getOptionalId() != null && loadPlan.getReturns().size() > 1) {
            throw new IllegalStateException("Cannot specify 'optional entity' values with multi-return load plans");
        }
    }

    @Override
    public SessionImplementor getSession() {
        return this.session;
    }

    @Override
    public boolean shouldUseOptionalEntityInformation() {
        return this.shouldUseOptionalEntityInformation;
    }

    @Override
    public QueryParameters getQueryParameters() {
        return this.queryParameters;
    }

    @Override
    public boolean shouldReturnProxies() {
        return this.shouldReturnProxies;
    }

    @Override
    public LoadPlan getLoadPlan() {
        return this.loadPlan;
    }

    @Override
    public LockMode resolveLockMode(EntityReference entityReference) {
        LockMode lockMode = this.lockModeResolverDelegate.resolveLockMode(entityReference);
        return LockMode.NONE == lockMode ? LockMode.NONE : lockMode;
    }

    @Override
    public ResultSetProcessingContext.EntityReferenceProcessingState getProcessingState(final EntityReference entityReference) {
        ResultSetProcessingContext.EntityReferenceProcessingState context;
        if (this.identifierResolutionContextMap == null) {
            this.identifierResolutionContextMap = new IdentityHashMap<EntityReference, ResultSetProcessingContext.EntityReferenceProcessingState>();
        }
        if ((context = this.identifierResolutionContextMap.get(entityReference)) == null) {
            context = new ResultSetProcessingContext.EntityReferenceProcessingState(){
                private boolean wasMissingIdentifier;
                private Object identifierHydratedForm;
                private EntityKey entityKey;
                private Object[] hydratedState;
                private Object entityInstance;

                @Override
                public EntityReference getEntityReference() {
                    return entityReference;
                }

                @Override
                public void registerMissingIdentifier() {
                    if (!EntityFetch.class.isInstance(entityReference)) {
                        throw new IllegalStateException("Missing return row identifier");
                    }
                    ResultSetProcessingContextImpl.this.registerNonExists((EntityFetch)entityReference);
                    this.wasMissingIdentifier = true;
                }

                @Override
                public boolean isMissingIdentifier() {
                    return this.wasMissingIdentifier;
                }

                @Override
                public void registerIdentifierHydratedForm(Object identifierHydratedForm) {
                    this.identifierHydratedForm = identifierHydratedForm;
                }

                @Override
                public Object getIdentifierHydratedForm() {
                    return this.identifierHydratedForm;
                }

                @Override
                public void registerEntityKey(EntityKey entityKey) {
                    this.entityKey = entityKey;
                }

                @Override
                public EntityKey getEntityKey() {
                    return this.entityKey;
                }

                @Override
                public void registerHydratedState(Object[] hydratedState) {
                    this.hydratedState = hydratedState;
                }

                @Override
                public Object[] getHydratedState() {
                    return this.hydratedState;
                }

                @Override
                public void registerEntityInstance(Object entityInstance) {
                    this.entityInstance = entityInstance;
                }

                @Override
                public Object getEntityInstance() {
                    return this.entityInstance;
                }
            };
            this.identifierResolutionContextMap.put(entityReference, context);
        }
        return context;
    }

    private void registerNonExists(EntityFetch fetch) {
        EntityType fetchedType = fetch.getFetchedType();
        if (!fetchedType.isOneToOne()) {
            return;
        }
        ResultSetProcessingContext.EntityReferenceProcessingState fetchOwnerState = this.getOwnerProcessingState(fetch);
        if (fetchOwnerState == null) {
            throw new IllegalStateException("Could not locate fetch owner state");
        }
        EntityKey ownerEntityKey = fetchOwnerState.getEntityKey();
        if (ownerEntityKey == null) {
            throw new IllegalStateException("Could not locate fetch owner EntityKey");
        }
        this.session.getPersistenceContext().addNullProperty(ownerEntityKey, fetchedType.getPropertyName());
    }

    @Override
    public ResultSetProcessingContext.EntityReferenceProcessingState getOwnerProcessingState(Fetch fetch) {
        return this.getProcessingState(this.resolveFetchOwnerEntityReference(fetch));
    }

    private EntityReference resolveFetchOwnerEntityReference(Fetch fetch) {
        FetchOwner fetchOwner = fetch.getOwner();
        if (EntityReference.class.isInstance(fetchOwner)) {
            return (EntityReference)((Object)fetchOwner);
        }
        if (CompositeFetch.class.isInstance(fetchOwner)) {
            return this.resolveFetchOwnerEntityReference((CompositeFetch)fetchOwner);
        }
        throw new IllegalStateException(String.format("Cannot resolve FetchOwner [%s] of Fetch [%s (%s)] to an EntityReference", fetchOwner, fetch, fetch.getPropertyPath()));
    }

    @Override
    public void registerHydratedEntity(EntityReference entityReference, EntityKey entityKey, Object entityInstance) {
        if (this.currentRowHydratedEntityRegistrationList == null) {
            this.currentRowHydratedEntityRegistrationList = new ArrayList<HydratedEntityRegistration>();
        }
        this.currentRowHydratedEntityRegistrationList.add(new HydratedEntityRegistration(entityReference, entityKey, entityInstance));
    }

    void finishUpRow() {
        if (this.currentRowHydratedEntityRegistrationList == null) {
            return;
        }
        if (this.hydratedEntityRegistrationList == null) {
            this.hydratedEntityRegistrationList = new ArrayList<HydratedEntityRegistration>();
        }
        this.hydratedEntityRegistrationList.addAll(this.currentRowHydratedEntityRegistrationList);
        if (this.hadSubselectFetches) {
            if (this.subselectLoadableEntityKeyMap == null) {
                this.subselectLoadableEntityKeyMap = new HashMap<EntityPersister, Set<EntityKey>>();
            }
            for (HydratedEntityRegistration registration : this.currentRowHydratedEntityRegistrationList) {
                Set<EntityKey> entityKeys = this.subselectLoadableEntityKeyMap.get(registration.entityReference.getEntityPersister());
                if (entityKeys == null) {
                    entityKeys = new HashSet<EntityKey>();
                    this.subselectLoadableEntityKeyMap.put(registration.entityReference.getEntityPersister(), entityKeys);
                }
                entityKeys.add(registration.key);
            }
        }
        this.currentRowHydratedEntityRegistrationList.clear();
        this.identifierResolutionContextMap.clear();
    }

    void finishUp(List<AfterLoadAction> afterLoadActionList) {
        this.initializeEntitiesAndCollections(afterLoadActionList);
        this.createSubselects();
        if (this.hydratedEntityRegistrationList != null) {
            this.hydratedEntityRegistrationList.clear();
            this.hydratedEntityRegistrationList = null;
        }
        if (this.subselectLoadableEntityKeyMap != null) {
            this.subselectLoadableEntityKeyMap.clear();
            this.subselectLoadableEntityKeyMap = null;
        }
    }

    private void initializeEntitiesAndCollections(List<AfterLoadAction> afterLoadActionList) {
        PostLoadEvent postLoadEvent;
        PreLoadEvent preLoadEvent;
        this.finishLoadingArrays();
        if (this.session.isEventSource()) {
            preLoadEvent = new PreLoadEvent((EventSource)this.session);
            postLoadEvent = new PostLoadEvent((EventSource)this.session);
        } else {
            preLoadEvent = null;
            postLoadEvent = null;
        }
        this.performTwoPhaseLoad(preLoadEvent);
        this.finishLoadingCollections();
        this.postLoad(postLoadEvent, afterLoadActionList);
    }

    private void finishLoadingArrays() {
        LoadPlanVisitor.visit(this.loadPlan, new LoadPlanVisitationStrategyAdapter(){

            @Override
            public void handleCollectionReturn(CollectionReturn rootCollectionReturn) {
                this.endLoadingArray(rootCollectionReturn.getCollectionPersister());
            }

            @Override
            public void startingCollectionFetch(CollectionFetch collectionFetch) {
                this.endLoadingArray(collectionFetch.getCollectionPersister());
            }

            private void endLoadingArray(CollectionPersister persister) {
                if (persister.isArray()) {
                    ResultSetProcessingContextImpl.this.session.getPersistenceContext().getLoadContexts().getCollectionLoadContext(ResultSetProcessingContextImpl.this.resultSet).endLoadingCollections(persister);
                }
            }
        });
    }

    private void performTwoPhaseLoad(PreLoadEvent preLoadEvent) {
        int numberOfHydratedObjects = this.hydratedEntityRegistrationList == null ? 0 : this.hydratedEntityRegistrationList.size();
        LOG.tracev("Total objects hydrated: {0}", (Object)numberOfHydratedObjects);
        if (this.hydratedEntityRegistrationList == null) {
            return;
        }
        for (HydratedEntityRegistration registration : this.hydratedEntityRegistrationList) {
            TwoPhaseLoad.initializeEntity(registration.instance, this.readOnly, this.session, preLoadEvent);
        }
    }

    private void finishLoadingCollections() {
        LoadPlanVisitor.visit(this.loadPlan, new LoadPlanVisitationStrategyAdapter(){

            @Override
            public void handleCollectionReturn(CollectionReturn rootCollectionReturn) {
                this.endLoadingCollection(rootCollectionReturn.getCollectionPersister());
            }

            @Override
            public void startingCollectionFetch(CollectionFetch collectionFetch) {
                this.endLoadingCollection(collectionFetch.getCollectionPersister());
            }

            private void endLoadingCollection(CollectionPersister persister) {
                if (!persister.isArray()) {
                    ResultSetProcessingContextImpl.this.session.getPersistenceContext().getLoadContexts().getCollectionLoadContext(ResultSetProcessingContextImpl.this.resultSet).endLoadingCollections(persister);
                }
            }
        });
    }

    private void postLoad(PostLoadEvent postLoadEvent, List<AfterLoadAction> afterLoadActionList) {
        if (this.hydratedEntityRegistrationList == null) {
            return;
        }
        for (HydratedEntityRegistration registration : this.hydratedEntityRegistrationList) {
            TwoPhaseLoad.postLoad(registration.instance, this.session, postLoadEvent);
            if (afterLoadActionList == null) continue;
            for (AfterLoadAction afterLoadAction : afterLoadActionList) {
                afterLoadAction.afterLoad(this.session, registration.instance, (Loadable)registration.entityReference.getEntityPersister());
            }
        }
    }

    private void createSubselects() {
        if (this.subselectLoadableEntityKeyMap == null || this.subselectLoadableEntityKeyMap.size() <= 1) {
            return;
        }
        Map<String, int[]> namedParameterLocMap = ResultSetProcessorHelper.buildNamedParameterLocMap(this.queryParameters, this.namedParameterContext);
        for (Map.Entry<EntityPersister, Set<EntityKey>> entry : this.subselectLoadableEntityKeyMap.entrySet()) {
            if (!entry.getKey().hasSubselectLoadableCollections()) continue;
            SubselectFetch subselectFetch = new SubselectFetch(null, (Loadable)entry.getKey(), this.queryParameters, entry.getValue(), namedParameterLocMap);
            for (EntityKey key : entry.getValue()) {
                this.session.getPersistenceContext().getBatchFetchQueue().addSubselect(key, subselectFetch);
            }
        }
    }

    private static class HydratedEntityRegistration {
        private final EntityReference entityReference;
        private final EntityKey key;
        private Object instance;

        private HydratedEntityRegistration(EntityReference entityReference, EntityKey key, Object instance) {
            this.entityReference = entityReference;
            this.key = key;
            this.instance = instance;
        }
    }
}

