/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.exec.process.internal;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.internal.CoreLogging;
import org.hibernate.loader.plan.exec.process.internal.EntityIdentifierReader;
import org.hibernate.loader.plan.exec.process.internal.EntityReferenceReader;
import org.hibernate.loader.plan.exec.process.internal.ResultSetProcessorHelper;
import org.hibernate.loader.plan.exec.process.spi.ResultSetProcessingContext;
import org.hibernate.loader.plan.exec.spi.EntityReferenceAliases;
import org.hibernate.loader.plan.spi.EntityFetch;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.EntityReturn;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.hibernate.persister.walking.internal.FetchStrategyHelper;
import org.hibernate.persister.walking.spi.WalkingException;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class EntityIdentifierReaderImpl
implements EntityIdentifierReader {
    private static final Logger log = CoreLogging.logger(EntityIdentifierReaderImpl.class);
    private final EntityReference entityReference;
    private final EntityReferenceAliases aliases;
    private final List<EntityReferenceReader> identifierFetchReaders;
    private final boolean isReturn;
    private final Type identifierType;

    public EntityIdentifierReaderImpl(EntityReference entityReference, EntityReferenceAliases aliases, List<EntityReferenceReader> identifierFetchReaders) {
        this.entityReference = entityReference;
        this.aliases = aliases;
        this.isReturn = EntityReturn.class.isInstance(entityReference);
        this.identifierType = entityReference.getEntityPersister().getIdentifierType();
        this.identifierFetchReaders = identifierFetchReaders;
    }

    @Override
    public void hydrate(ResultSet resultSet, ResultSetProcessingContext context) throws SQLException {
        EntityKey entityKey;
        ResultSetProcessingContext.EntityReferenceProcessingState processingState = context.getProcessingState(this.entityReference);
        if (context.shouldUseOptionalEntityInformation() && this.isReturn && (entityKey = ResultSetProcessorHelper.getOptionalObjectKey(context.getQueryParameters(), context.getSession())) != null) {
            processingState.registerEntityKey(entityKey);
            return;
        }
        Object identifierHydratedForm = processingState.getIdentifierHydratedForm();
        if (identifierHydratedForm == null) {
            identifierHydratedForm = this.readIdentifierHydratedState(resultSet, context);
            processingState.registerIdentifierHydratedForm(identifierHydratedForm);
            for (EntityReferenceReader reader : this.identifierFetchReaders) {
                reader.hydrateIdentifier(resultSet, context);
            }
        }
    }

    private Object readIdentifierHydratedState(ResultSet resultSet, ResultSetProcessingContext context) throws SQLException {
        if (EntityFetch.class.isInstance(this.entityReference) && !FetchStrategyHelper.isJoinFetched(((EntityFetch)this.entityReference).getFetchStrategy())) {
            EntityFetch fetch = (EntityFetch)this.entityReference;
            FetchOwner fetchOwner = fetch.getOwner();
            if (EntityReference.class.isInstance(fetchOwner)) {
                throw new NotYetImplementedException();
            }
            throw new WalkingException("Cannot locate association column names");
        }
        String[] columnNames = this.aliases.getColumnAliases().getSuffixedKeyAliases();
        try {
            return this.entityReference.getEntityPersister().getIdentifierType().hydrate(resultSet, columnNames, context.getSession(), null);
        }
        catch (Exception e) {
            throw new HibernateException("Encountered problem trying to hydrate identifier for entity [" + this.entityReference.getEntityPersister() + "]", e);
        }
    }

    @Override
    public void resolve(ResultSet resultSet, ResultSetProcessingContext context) throws SQLException {
        ResultSetProcessingContext.EntityReferenceProcessingState processingState = context.getProcessingState(this.entityReference);
        EntityKey entityKey = processingState.getEntityKey();
        if (entityKey != null) {
            log.debugf("On call to EntityIdentifierReaderImpl#resolve [for %s], EntityKey was already known; should only happen on root returns with an optional identifier specified", new Object[0]);
            return;
        }
        Object identifierHydratedForm = processingState.getIdentifierHydratedForm();
        if (identifierHydratedForm == null) {
            return;
        }
        Type identifierType = this.entityReference.getEntityPersister().getIdentifierType();
        Serializable resolvedId = (Serializable)identifierType.resolve(identifierHydratedForm, context.getSession(), null);
        if (resolvedId != null) {
            processingState.registerEntityKey(context.getSession().generateEntityKey(resolvedId, this.entityReference.getEntityPersister()));
        }
    }
}

