/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.exec.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.internal.JoinHelper;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.EntityAliases;
import org.hibernate.loader.plan.exec.process.internal.CollectionReferenceReader;
import org.hibernate.loader.plan.exec.process.internal.EntityIdentifierReader;
import org.hibernate.loader.plan.exec.process.internal.EntityIdentifierReaderImpl;
import org.hibernate.loader.plan.exec.process.internal.EntityReferenceReader;
import org.hibernate.loader.plan.exec.process.internal.OneToOneFetchReader;
import org.hibernate.loader.plan.exec.query.internal.SelectStatementBuilder;
import org.hibernate.loader.plan.exec.query.spi.QueryBuildingParameters;
import org.hibernate.loader.plan.exec.spi.AliasResolutionContext;
import org.hibernate.loader.plan.exec.spi.CollectionReferenceAliases;
import org.hibernate.loader.plan.exec.spi.EntityReferenceAliases;
import org.hibernate.loader.plan.exec.spi.ReaderCollector;
import org.hibernate.loader.plan.spi.AnyFetch;
import org.hibernate.loader.plan.spi.BidirectionalEntityFetch;
import org.hibernate.loader.plan.spi.CollectionFetch;
import org.hibernate.loader.plan.spi.CompositeElementGraph;
import org.hibernate.loader.plan.spi.CompositeFetch;
import org.hibernate.loader.plan.spi.CompositeIndexGraph;
import org.hibernate.loader.plan.spi.EntityElementGraph;
import org.hibernate.loader.plan.spi.EntityFetch;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.persister.walking.internal.FetchStrategyHelper;
import org.hibernate.persister.walking.spi.WalkingException;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.JoinType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class LoadQueryBuilderHelper {
    private static final Logger log = CoreLogging.logger(LoadQueryBuilderHelper.class);

    private LoadQueryBuilderHelper() {
    }

    public static void applyIdentifierJoinFetches(SelectStatementBuilder selectStatementBuilder, SessionFactoryImplementor factory, FetchOwner fetchOwner, QueryBuildingParameters buildingParameters, AliasResolutionContext aliasResolutionContext, ReaderCollector readerCollector) {
    }

    public static FetchStats applyJoinFetches(SelectStatementBuilder selectStatementBuilder, SessionFactoryImplementor factory, FetchOwner fetchOwner, QueryBuildingParameters buildingParameters, AliasResolutionContext aliasResolutionContext, ReaderCollector readerCollector) {
        JoinFragment joinFragment = factory.getDialect().createOuterJoinFragment();
        FetchStatsImpl stats = new FetchStatsImpl();
        if (EntityReference.class.isInstance(fetchOwner)) {
            EntityReference fetchOwnerAsEntityReference = (EntityReference)((Object)fetchOwner);
            for (Fetch fetch : fetchOwnerAsEntityReference.getIdentifierDescription().getFetches()) {
                LoadQueryBuilderHelper.processFetch(selectStatementBuilder, factory, joinFragment, fetchOwner, fetch, buildingParameters, aliasResolutionContext, readerCollector, stats);
            }
        }
        LoadQueryBuilderHelper.processJoinFetches(selectStatementBuilder, factory, joinFragment, fetchOwner, buildingParameters, aliasResolutionContext, readerCollector, stats);
        selectStatementBuilder.setOuterJoins(joinFragment.toFromFragmentString(), joinFragment.toWhereFragmentString());
        return stats;
    }

    private static void processJoinFetches(SelectStatementBuilder selectStatementBuilder, SessionFactoryImplementor factory, JoinFragment joinFragment, FetchOwner fetchOwner, QueryBuildingParameters buildingParameters, AliasResolutionContext aliasResolutionContext, ReaderCollector readerCollector, FetchStatsImpl stats) {
        for (Fetch fetch : fetchOwner.getFetches()) {
            LoadQueryBuilderHelper.processFetch(selectStatementBuilder, factory, joinFragment, fetchOwner, fetch, buildingParameters, aliasResolutionContext, readerCollector, stats);
        }
    }

    private static void processFetch(SelectStatementBuilder selectStatementBuilder, SessionFactoryImplementor factory, JoinFragment joinFragment, FetchOwner fetchOwner, Fetch fetch, QueryBuildingParameters buildingParameters, AliasResolutionContext aliasResolutionContext, ReaderCollector readerCollector, FetchStatsImpl stats) {
        if (!FetchStrategyHelper.isJoinFetched(fetch.getFetchStrategy())) {
            return;
        }
        if (EntityFetch.class.isInstance(fetch)) {
            EntityFetch entityFetch = (EntityFetch)fetch;
            LoadQueryBuilderHelper.processEntityFetch(selectStatementBuilder, factory, joinFragment, fetchOwner, entityFetch, buildingParameters, aliasResolutionContext, readerCollector, stats);
        } else if (CollectionFetch.class.isInstance(fetch)) {
            CollectionFetch collectionFetch = (CollectionFetch)fetch;
            LoadQueryBuilderHelper.processCollectionFetch(selectStatementBuilder, factory, joinFragment, fetchOwner, collectionFetch, buildingParameters, aliasResolutionContext, readerCollector, stats);
            if (collectionFetch.getIndexGraph() != null) {
                LoadQueryBuilderHelper.processJoinFetches(selectStatementBuilder, factory, joinFragment, collectionFetch.getIndexGraph(), buildingParameters, aliasResolutionContext, readerCollector, stats);
            }
            if (collectionFetch.getElementGraph() != null) {
                LoadQueryBuilderHelper.processJoinFetches(selectStatementBuilder, factory, joinFragment, collectionFetch.getElementGraph(), buildingParameters, aliasResolutionContext, readerCollector, stats);
            }
        } else if (FetchOwner.class.isInstance(fetch)) {
            LoadQueryBuilderHelper.processJoinFetches(selectStatementBuilder, factory, joinFragment, (FetchOwner)((Object)fetch), buildingParameters, aliasResolutionContext, readerCollector, stats);
        }
    }

    private static void processEntityFetch(SelectStatementBuilder selectStatementBuilder, SessionFactoryImplementor factory, JoinFragment joinFragment, FetchOwner fetchOwner, EntityFetch fetch, QueryBuildingParameters buildingParameters, AliasResolutionContext aliasResolutionContext, ReaderCollector readerCollector, FetchStatsImpl stats) {
        if (BidirectionalEntityFetch.class.isInstance(fetch)) {
            log.tracef("Skipping bi-directional entity fetch [%s]", (Object)fetch);
            return;
        }
        stats.processingFetch(fetch);
        EntityReferenceAliases aliases = LoadQueryBuilderHelper.renderSqlFragments(selectStatementBuilder, factory, joinFragment, fetchOwner, fetch, buildingParameters, aliasResolutionContext);
        EntityIdentifierReader identifierReader = LoadQueryBuilderHelper.buildIdentifierReader(selectStatementBuilder, factory, joinFragment, fetch, buildingParameters, aliasResolutionContext, readerCollector, aliases, stats);
        if (fetch.getFetchedType().isOneToOne()) {
            readerCollector.addReader(new OneToOneFetchReader(fetch, aliases, identifierReader, (EntityReference)((Object)fetchOwner)));
        } else {
            readerCollector.addReader(new EntityReferenceReader(fetch, aliases, identifierReader));
        }
        LoadQueryBuilderHelper.processJoinFetches(selectStatementBuilder, factory, joinFragment, fetch, buildingParameters, aliasResolutionContext, readerCollector, stats);
    }

    private static EntityReferenceAliases renderSqlFragments(SelectStatementBuilder selectStatementBuilder, SessionFactoryImplementor factory, JoinFragment joinFragment, FetchOwner fetchOwner, EntityFetch fetch, QueryBuildingParameters buildingParameters, AliasResolutionContext aliasResolutionContext) {
        EntityReferenceAliases aliases = aliasResolutionContext.resolveAliases(fetch);
        String rhsAlias = aliases.getTableAlias();
        String[] rhsColumnNames = JoinHelper.getRHSColumnNames(fetch.getFetchedType(), factory);
        String lhsTableAlias = LoadQueryBuilderHelper.resolveLhsTableAlias(fetchOwner, fetch, aliasResolutionContext);
        String[] aliasedLhsColumnNames = fetch.toSqlSelectFragments(lhsTableAlias);
        String additionalJoinConditions = LoadQueryBuilderHelper.resolveAdditionalJoinCondition(factory, rhsAlias, fetchOwner, fetch, buildingParameters.getQueryInfluencers(), aliasResolutionContext);
        Joinable joinable = (Joinable)((Object)fetch.getEntityPersister());
        LoadQueryBuilderHelper.addJoins(joinFragment, joinable, fetch.isNullable() ? JoinType.LEFT_OUTER_JOIN : JoinType.INNER_JOIN, rhsAlias, rhsColumnNames, aliasedLhsColumnNames, additionalJoinConditions);
        selectStatementBuilder.appendSelectClauseFragment(joinable.selectFragment(null, null, rhsAlias, aliases.getColumnAliases().getSuffix(), null, true));
        return aliases;
    }

    private static EntityIdentifierReader buildIdentifierReader(SelectStatementBuilder selectStatementBuilder, SessionFactoryImplementor factory, JoinFragment joinFragment, EntityReference entityReference, QueryBuildingParameters buildingParameters, AliasResolutionContext aliasResolutionContext, ReaderCollector readerCollector, EntityReferenceAliases aliases, FetchStatsImpl stats) {
        final ArrayList<EntityReferenceReader> identifierFetchReaders = new ArrayList<EntityReferenceReader>();
        ReaderCollector identifierFetchReaderCollector = new ReaderCollector(){

            @Override
            public void addReader(CollectionReferenceReader collectionReferenceReader) {
                throw new IllegalStateException("Identifier cannot contain collection fetches");
            }

            @Override
            public void addReader(EntityReferenceReader entityReferenceReader) {
                identifierFetchReaders.add(entityReferenceReader);
            }
        };
        for (Fetch fetch : entityReference.getIdentifierDescription().getFetches()) {
            LoadQueryBuilderHelper.processFetch(selectStatementBuilder, factory, joinFragment, (FetchOwner)((Object)entityReference), fetch, buildingParameters, aliasResolutionContext, identifierFetchReaderCollector, stats);
        }
        return new EntityIdentifierReaderImpl(entityReference, aliases, identifierFetchReaders);
    }

    private static List<EntityReferenceReader> collectIdentifierFetchReaders(EntityReference entityReference, AliasResolutionContext aliasResolutionContext, ReaderCollector readerCollector) {
        Type identifierType = entityReference.getEntityPersister().getIdentifierType();
        if (!identifierType.isComponentType()) {
            return Collections.emptyList();
        }
        Fetch[] fetches = entityReference.getIdentifierDescription().getFetches();
        if (fetches == null || fetches.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<EntityReferenceReader> readers = new ArrayList<EntityReferenceReader>();
        for (Fetch fetch : fetches) {
            LoadQueryBuilderHelper.collectIdentifierFetchReaders(aliasResolutionContext, readers, entityReference, fetch, readerCollector);
        }
        return readers;
    }

    private static void collectIdentifierFetchReaders(AliasResolutionContext aliasResolutionContext, List<EntityReferenceReader> readers, EntityReference entityReference, Fetch fetch, ReaderCollector readerCollector) {
        if (CompositeFetch.class.isInstance(fetch)) {
            for (Fetch subFetch : ((CompositeFetch)fetch).getFetches()) {
                LoadQueryBuilderHelper.collectIdentifierFetchReaders(aliasResolutionContext, readers, entityReference, subFetch, readerCollector);
            }
        } else {
            if (!EntityReference.class.isInstance(fetch)) {
                throw new IllegalStateException(String.format("Non-entity (and non-composite) fetch [%s] was found as part of entity identifier : %s", fetch, entityReference.getEntityPersister().getEntityName()));
            }
            EntityReference fetchedEntityReference = (EntityReference)((Object)fetch);
            EntityReferenceAliases fetchedAliases = aliasResolutionContext.resolveAliases(fetchedEntityReference);
            if (BidirectionalEntityFetch.class.isInstance(fetchedEntityReference)) {
                return;
            }
            EntityReferenceReader reader = new EntityReferenceReader(fetchedEntityReference, aliasResolutionContext.resolveAliases(fetchedEntityReference), new EntityIdentifierReaderImpl(fetchedEntityReference, fetchedAliases, Collections.<EntityReferenceReader>emptyList()));
            readerCollector.addReader(reader);
        }
    }

    private static String[] resolveAliasedLhsJoinColumns(FetchOwner fetchOwner, Fetch fetch, AliasResolutionContext aliasResolutionContext) {
        String lhsTableAlias = LoadQueryBuilderHelper.resolveLhsTableAlias(fetchOwner, fetch, aliasResolutionContext);
        return fetch.toSqlSelectFragments(lhsTableAlias);
    }

    private static String resolveLhsTableAlias(FetchOwner fetchOwner, Fetch fetch, AliasResolutionContext aliasResolutionContext) {
        if (AnyFetch.class.isInstance(fetchOwner)) {
            throw new WalkingException("Any type should never be joined!");
        }
        if (EntityReference.class.isInstance(fetchOwner)) {
            return aliasResolutionContext.resolveAliases((EntityReference)((Object)fetchOwner)).getTableAlias();
        }
        if (CompositeFetch.class.isInstance(fetchOwner)) {
            return aliasResolutionContext.resolveAliases(LoadQueryBuilderHelper.locateCompositeFetchEntityReferenceSource((CompositeFetch)fetchOwner)).getTableAlias();
        }
        if (CompositeElementGraph.class.isInstance(fetchOwner)) {
            CompositeElementGraph compositeElementGraph = (CompositeElementGraph)fetchOwner;
            return aliasResolutionContext.resolveAliases(compositeElementGraph.getCollectionReference()).getCollectionTableAlias();
        }
        if (CompositeIndexGraph.class.isInstance(fetchOwner)) {
            CompositeIndexGraph compositeIndexGraph = (CompositeIndexGraph)fetchOwner;
            return aliasResolutionContext.resolveAliases(compositeIndexGraph.getCollectionReference()).getCollectionTableAlias();
        }
        throw new NotYetImplementedException("Cannot determine LHS alias for FetchOwner.");
    }

    private static EntityReference locateCompositeFetchEntityReferenceSource(CompositeFetch composite) {
        FetchOwner owner = composite.getOwner();
        if (EntityReference.class.isInstance(owner)) {
            return (EntityReference)((Object)owner);
        }
        if (CompositeFetch.class.isInstance(owner)) {
            return LoadQueryBuilderHelper.locateCompositeFetchEntityReferenceSource((CompositeFetch)owner);
        }
        throw new WalkingException("Cannot resolve entity source for a CompositeFetch");
    }

    private static String resolveAdditionalJoinCondition(SessionFactoryImplementor factory, String rhsTableAlias, FetchOwner fetchOwner, Fetch fetch, LoadQueryInfluencers influencers, AliasResolutionContext aliasResolutionContext) {
        String withClause = StringHelper.isEmpty(fetch.getAdditionalJoinConditions()) ? "" : " and ( " + fetch.getAdditionalJoinConditions() + " )";
        return ((AssociationType)fetch.getFetchedType()).getOnCondition(rhsTableAlias, factory, influencers.getEnabledFilters()) + withClause;
    }

    private static void addJoins(JoinFragment joinFragment, Joinable joinable, JoinType joinType, String rhsAlias, String[] rhsColumnNames, String[] aliasedLhsColumnNames, String additionalJoinConditions) {
        joinFragment.addJoin(joinable.getTableName(), rhsAlias, aliasedLhsColumnNames, rhsColumnNames, joinType, additionalJoinConditions);
        joinFragment.addJoins(joinable.fromJoinFragment(rhsAlias, false, true), joinable.whereJoinFragment(rhsAlias, false, true));
    }

    private static void processCollectionFetch(SelectStatementBuilder selectStatementBuilder, SessionFactoryImplementor factory, JoinFragment joinFragment, FetchOwner fetchOwner, CollectionFetch fetch, QueryBuildingParameters buildingParameters, AliasResolutionContext aliasResolutionContext, ReaderCollector readerCollector, FetchStatsImpl stats) {
        stats.processingFetch(fetch);
        final CollectionReferenceAliases aliases = aliasResolutionContext.resolveAliases(fetch);
        if (fetch.getCollectionPersister().isManyToMany()) {
            String ordering;
            QueryableCollection queryableCollection = (QueryableCollection)fetch.getCollectionPersister();
            Joinable joinableCollection = (Joinable)((Object)fetch.getCollectionPersister());
            String ownerTableAlias = LoadQueryBuilderHelper.resolveLhsTableAlias(fetchOwner, fetch, aliasResolutionContext);
            String collectionTableAlias = aliases.getCollectionTableAlias();
            String elementTableAlias = aliases.getElementTableAlias();
            String filterFragment = ((Joinable)((Object)fetch.getCollectionPersister())).filterFragment(collectionTableAlias, buildingParameters.getQueryInfluencers().getEnabledFilters());
            joinFragment.addJoin(joinableCollection.getTableName(), collectionTableAlias, StringHelper.qualify(ownerTableAlias, LoadQueryBuilderHelper.extractJoinable(fetchOwner).getKeyColumnNames()), queryableCollection.getKeyColumnNames(), fetch.isNullable() ? JoinType.LEFT_OUTER_JOIN : JoinType.INNER_JOIN, filterFragment);
            joinFragment.addJoins(joinableCollection.fromJoinFragment(collectionTableAlias, false, true), joinableCollection.whereJoinFragment(collectionTableAlias, false, true));
            selectStatementBuilder.appendSelectClauseFragment(joinableCollection.selectFragment((Joinable)((Object)queryableCollection.getElementPersister()), ownerTableAlias, collectionTableAlias, aliases.getEntityElementColumnAliases().getSuffix(), aliases.getCollectionColumnAliases().getSuffix(), true));
            String additionalJoinConditions = LoadQueryBuilderHelper.resolveAdditionalJoinCondition(factory, elementTableAlias, fetchOwner, fetch, buildingParameters.getQueryInfluencers(), aliasResolutionContext);
            String manyToManyFilter = fetch.getCollectionPersister().getManyToManyFilterFragment(collectionTableAlias, buildingParameters.getQueryInfluencers().getEnabledFilters());
            String condition = "".equals(manyToManyFilter) ? additionalJoinConditions : ("".equals(additionalJoinConditions) ? manyToManyFilter : additionalJoinConditions + " and " + manyToManyFilter);
            OuterJoinLoadable elementPersister = (OuterJoinLoadable)queryableCollection.getElementPersister();
            LoadQueryBuilderHelper.addJoins(joinFragment, elementPersister, JoinType.LEFT_OUTER_JOIN, elementTableAlias, elementPersister.getIdentifierColumnNames(), StringHelper.qualify(collectionTableAlias, queryableCollection.getElementColumnNames()), condition);
            selectStatementBuilder.appendSelectClauseFragment(elementPersister.selectFragment(aliases.getElementTableAlias(), aliases.getEntityElementColumnAliases().getSuffix()));
            String manyToManyOrdering = queryableCollection.getManyToManyOrderByString(collectionTableAlias);
            if (StringHelper.isNotEmpty(manyToManyOrdering)) {
                selectStatementBuilder.appendOrderByFragment(manyToManyOrdering);
            }
            if (StringHelper.isNotEmpty(ordering = queryableCollection.getSQLOrderByString(collectionTableAlias))) {
                selectStatementBuilder.appendOrderByFragment(ordering);
            }
            EntityReferenceAliases entityReferenceAliases = new EntityReferenceAliases(){

                @Override
                public String getTableAlias() {
                    return aliases.getElementTableAlias();
                }

                @Override
                public EntityAliases getColumnAliases() {
                    return aliases.getEntityElementColumnAliases();
                }
            };
            EntityReference elementEntityReference = (EntityReference)((Object)fetch.getElementGraph());
            readerCollector.addReader(new EntityReferenceReader(elementEntityReference, entityReferenceAliases, LoadQueryBuilderHelper.buildIdentifierReader(selectStatementBuilder, factory, joinFragment, elementEntityReference, buildingParameters, aliasResolutionContext, readerCollector, entityReferenceAliases, stats)));
        } else {
            String ordering;
            QueryableCollection queryableCollection = (QueryableCollection)fetch.getCollectionPersister();
            Joinable joinableCollection = (Joinable)((Object)fetch.getCollectionPersister());
            String rhsTableAlias = aliases.getElementTableAlias();
            String[] rhsColumnNames = JoinHelper.getRHSColumnNames(fetch.getFetchedType(), factory);
            String lhsTableAlias = LoadQueryBuilderHelper.resolveLhsTableAlias(fetchOwner, fetch, aliasResolutionContext);
            String[] aliasedLhsColumnNames = fetch.toSqlSelectFragments(lhsTableAlias);
            String on = LoadQueryBuilderHelper.resolveAdditionalJoinCondition(factory, rhsTableAlias, fetchOwner, fetch, buildingParameters.getQueryInfluencers(), aliasResolutionContext);
            LoadQueryBuilderHelper.addJoins(joinFragment, joinableCollection, fetch.isNullable() ? JoinType.LEFT_OUTER_JOIN : JoinType.INNER_JOIN, rhsTableAlias, rhsColumnNames, aliasedLhsColumnNames, on);
            selectStatementBuilder.appendSelectClauseFragment(queryableCollection.selectFragment(rhsTableAlias, aliases.getCollectionColumnAliases().getSuffix()));
            if (fetch.getCollectionPersister().isOneToMany()) {
                OuterJoinLoadable elementPersister = (OuterJoinLoadable)queryableCollection.getElementPersister();
                selectStatementBuilder.appendSelectClauseFragment(elementPersister.selectFragment(aliases.getElementTableAlias(), aliases.getEntityElementColumnAliases().getSuffix()));
                EntityReferenceAliases entityReferenceAliases = new EntityReferenceAliases(){

                    @Override
                    public String getTableAlias() {
                        return aliases.getElementTableAlias();
                    }

                    @Override
                    public EntityAliases getColumnAliases() {
                        return aliases.getEntityElementColumnAliases();
                    }
                };
                EntityReference elementEntityReference = (EntityReference)((Object)fetch.getElementGraph());
                readerCollector.addReader(new EntityReferenceReader(elementEntityReference, entityReferenceAliases, LoadQueryBuilderHelper.buildIdentifierReader(selectStatementBuilder, factory, joinFragment, elementEntityReference, buildingParameters, aliasResolutionContext, readerCollector, entityReferenceAliases, stats)));
            }
            if (StringHelper.isNotEmpty(ordering = queryableCollection.getSQLOrderByString(rhsTableAlias))) {
                selectStatementBuilder.appendOrderByFragment(ordering);
            }
        }
        readerCollector.addReader(new CollectionReferenceReader(fetch, aliases));
    }

    private static Joinable extractJoinable(FetchOwner fetchOwner) {
        if (EntityReference.class.isInstance(fetchOwner)) {
            return (Joinable)((Object)((EntityReference)((Object)fetchOwner)).getEntityPersister());
        }
        if (CompositeFetch.class.isInstance(fetchOwner)) {
            return (Joinable)((Object)LoadQueryBuilderHelper.locateCompositeFetchEntityReferenceSource((CompositeFetch)fetchOwner).getEntityPersister());
        }
        if (EntityElementGraph.class.isInstance(fetchOwner)) {
            return (Joinable)((Object)((EntityElementGraph)fetchOwner).getEntityPersister());
        }
        throw new IllegalStateException("Uncertain how to extract Joinable from given FetchOwner : " + fetchOwner);
    }

    private static class FetchStatsImpl
    implements FetchStats {
        private boolean hasSubselectFetch;

        private FetchStatsImpl() {
        }

        public void processingFetch(Fetch fetch) {
            if (!this.hasSubselectFetch && fetch.getFetchStrategy().getStyle() == FetchStyle.SUBSELECT && fetch.getFetchStrategy().getTiming() != FetchTiming.IMMEDIATE) {
                this.hasSubselectFetch = true;
            }
        }

        @Override
        public boolean hasSubselectFetches() {
            return this.hasSubselectFetch;
        }
    }

    public static interface FetchStats {
        public boolean hasSubselectFetches();
    }
}

