/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.Map;
import org.hibernate.Filter;
import org.hibernate.MappingException;
import org.hibernate.loader.internal.AbstractJoinableAssociationImpl;
import org.hibernate.loader.plan.spi.CollectionReference;
import org.hibernate.loader.plan.spi.EntityFetch;
import org.hibernate.loader.spi.JoinableAssociation;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.EntityType;

public class EntityJoinableAssociationImpl
extends AbstractJoinableAssociationImpl {
    private final AssociationType joinableType;
    private final Joinable joinable;

    public EntityJoinableAssociationImpl(EntityFetch entityFetch, CollectionReference currentCollectionReference, String withClause, boolean hasRestriction, Map<String, Filter> enabledFilters) throws MappingException {
        super(entityFetch, entityFetch, currentCollectionReference, withClause, hasRestriction, enabledFilters);
        this.joinableType = entityFetch.getFetchedType();
        this.joinable = (Joinable)((Object)entityFetch.getEntityPersister());
    }

    @Override
    public AssociationType getAssociationType() {
        return this.joinableType;
    }

    @Override
    public Joinable getJoinable() {
        return this.joinable;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public boolean isManyToManyWith(JoinableAssociation other) {
        return false;
    }

    protected boolean isOneToOne() {
        EntityType entityType = (EntityType)this.joinableType;
        return entityType.isOneToOne();
    }
}

