/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.engine.internal.JoinHelper;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.loader.EntityAliases;
import org.hibernate.loader.plan.exec.spi.AliasResolutionContext;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.spi.JoinableAssociation;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.walking.internal.FetchStrategyHelper;
import org.hibernate.sql.ConditionFragment;
import org.hibernate.sql.DisjunctionFragment;
import org.hibernate.sql.InFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.JoinType;

public abstract class AbstractLoadQueryImpl {
    private final List<JoinableAssociation> associations;

    protected AbstractLoadQueryImpl(List<JoinableAssociation> associations) {
        this.associations = associations;
    }

    protected String orderBy(String orderBy, AliasResolutionContext aliasResolutionContext) {
        return AbstractLoadQueryImpl.mergeOrderings(AbstractLoadQueryImpl.orderBy(this.associations, aliasResolutionContext), orderBy);
    }

    protected static String mergeOrderings(String ordering1, String ordering2) {
        if (ordering1.length() == 0) {
            return ordering2;
        }
        if (ordering2.length() == 0) {
            return ordering1;
        }
        return ordering1 + ", " + ordering2;
    }

    protected final JoinFragment mergeOuterJoins(SessionFactoryImplementor factory, AliasResolutionContext aliasResolutionContext) throws MappingException {
        JoinFragment joinFragment = factory.getDialect().createOuterJoinFragment();
        JoinableAssociation previous = null;
        for (JoinableAssociation association : this.associations) {
            String rhsAlias = aliasResolutionContext.resolveAssociationRhsTableAlias(association);
            String[] aliasedLhsColumnNames = aliasResolutionContext.resolveAssociationAliasedLhsColumnNames(association);
            String[] rhsColumnNames = JoinHelper.getRHSColumnNames(association.getAssociationType(), factory);
            String on = this.resolveOnCondition(factory, association, aliasResolutionContext);
            if (previous != null && previous.isManyToManyWith(association)) {
                this.addManyToManyJoin(joinFragment, association, (QueryableCollection)previous.getJoinable(), rhsAlias, aliasedLhsColumnNames, rhsColumnNames, on);
            } else {
                this.addJoins(joinFragment, association, rhsAlias, aliasedLhsColumnNames, rhsColumnNames, on);
            }
            previous = association;
        }
        return joinFragment;
    }

    protected static String orderBy(List<JoinableAssociation> associations, AliasResolutionContext aliasResolutionContext) throws MappingException {
        StringBuilder buf = new StringBuilder();
        JoinableAssociation previous = null;
        for (JoinableAssociation association : associations) {
            String rhsAlias = aliasResolutionContext.resolveAssociationRhsTableAlias(association);
            if (association.getJoinType() == JoinType.LEFT_OUTER_JOIN) {
                String orderByString;
                QueryableCollection queryableCollection;
                if (association.getJoinable().isCollection()) {
                    queryableCollection = (QueryableCollection)association.getJoinable();
                    if (queryableCollection.hasOrdering()) {
                        orderByString = queryableCollection.getSQLOrderByString(rhsAlias);
                        buf.append(orderByString).append(", ");
                    }
                } else if (previous != null && previous.getJoinable().isCollection() && (queryableCollection = (QueryableCollection)previous.getJoinable()).isManyToMany() && previous.isManyToManyWith(association) && queryableCollection.hasManyToManyOrdering()) {
                    orderByString = queryableCollection.getManyToManyOrderByString(rhsAlias);
                    buf.append(orderByString).append(", ");
                }
            }
            previous = association;
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 2);
        }
        return buf.toString();
    }

    protected StringBuilder whereString(String alias, String[] columnNames, int batchSize) {
        if (columnNames.length == 1) {
            InFragment in = new InFragment().setColumn(alias, columnNames[0]);
            for (int i = 0; i < batchSize; ++i) {
                in.addValue("?");
            }
            return new StringBuilder(in.toFragmentString());
        }
        ConditionFragment byId = new ConditionFragment().setTableAlias(alias).setCondition(columnNames, "?");
        StringBuilder whereString = new StringBuilder();
        if (batchSize == 1) {
            whereString.append(byId.toFragmentString());
        } else {
            whereString.append('(');
            DisjunctionFragment df = new DisjunctionFragment();
            for (int i = 0; i < batchSize; ++i) {
                df.addCondition(byId);
            }
            whereString.append(df.toFragmentString());
            whereString.append(')');
        }
        return whereString;
    }

    protected final String associationSelectString(AliasResolutionContext aliasResolutionContext) throws MappingException {
        if (this.associations.size() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(this.associations.size() * 100);
        for (int i = 0; i < this.associations.size(); ++i) {
            JoinableAssociation next;
            JoinableAssociation association = this.associations.get(i);
            JoinableAssociation joinableAssociation = next = i == this.associations.size() - 1 ? null : this.associations.get(i + 1);
            if (!this.shouldAddToSql(association.getCurrentFetch())) continue;
            Joinable joinable = association.getJoinable();
            EntityAliases currentEntityAliases = association.getCurrentEntityReference() == null ? null : aliasResolutionContext.resolveAliases(association.getCurrentEntityReference()).getColumnAliases();
            CollectionAliases currentCollectionAliases = association.getCurrentCollectionReference() == null ? null : aliasResolutionContext.resolveAliases(association.getCurrentCollectionReference()).getCollectionColumnAliases();
            String selectFragment = joinable.selectFragment(next == null ? null : next.getJoinable(), next == null ? null : aliasResolutionContext.resolveAssociationRhsTableAlias(next), aliasResolutionContext.resolveAssociationRhsTableAlias(association), currentEntityAliases == null ? null : currentEntityAliases.getSuffix(), currentCollectionAliases == null ? null : currentCollectionAliases.getSuffix(), association.getJoinType() == JoinType.LEFT_OUTER_JOIN);
            if (selectFragment.trim().length() <= 0) continue;
            buf.append(", ").append(selectFragment);
        }
        return buf.toString();
    }

    private boolean shouldAddToSql(Fetch fetch) {
        return FetchStrategyHelper.isJoinFetched(fetch.getFetchStrategy());
    }

    private void addJoins(JoinFragment joinFragment, JoinableAssociation association, String rhsAlias, String[] aliasedLhsColumnNames, String[] rhsColumnNames, String on) throws MappingException {
        joinFragment.addJoin(association.getJoinable().getTableName(), rhsAlias, aliasedLhsColumnNames, rhsColumnNames, association.getJoinType(), on);
        joinFragment.addJoins(association.getJoinable().fromJoinFragment(rhsAlias, false, true), association.getJoinable().whereJoinFragment(rhsAlias, false, true));
    }

    private String resolveOnCondition(SessionFactoryImplementor factory, JoinableAssociation joinableAssociation, AliasResolutionContext aliasResolutionContext) {
        String withClause = StringHelper.isEmpty(joinableAssociation.getWithClause()) ? "" : " and ( " + joinableAssociation.getWithClause() + " )";
        return joinableAssociation.getAssociationType().getOnCondition(aliasResolutionContext.resolveAssociationRhsTableAlias(joinableAssociation), factory, joinableAssociation.getEnabledFilters()) + withClause;
    }

    private void addManyToManyJoin(JoinFragment outerjoin, JoinableAssociation association, QueryableCollection collection, String rhsAlias, String[] aliasedLhsColumnNames, String[] rhsColumnNames, String on) throws MappingException {
        String manyToManyFilter = collection.getManyToManyFilterFragment(rhsAlias, association.getEnabledFilters());
        String condition = "".equals(manyToManyFilter) ? on : ("".equals(on) ? manyToManyFilter : on + " and " + manyToManyFilter);
        outerjoin.addJoin(association.getJoinable().getTableName(), rhsAlias, aliasedLhsColumnNames, rhsColumnNames, association.getJoinType(), condition);
        outerjoin.addJoins(association.getJoinable().fromJoinFragment(rhsAlias, false, true), association.getJoinable().whereJoinFragment(rhsAlias, false, true));
    }
}

