/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.cursor.internal.StandardRefCursorSupport;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseMetaDataDialectResolutionInfoAdapter;
import org.hibernate.engine.jdbc.dialect.spi.DialectFactory;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfoSource;
import org.hibernate.engine.jdbc.internal.LobCreatorBuilder;
import org.hibernate.engine.jdbc.internal.ResultSetWrapperImpl;
import org.hibernate.engine.jdbc.spi.ExtractedDatabaseMetaData;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.ResultSetWrapper;
import org.hibernate.engine.jdbc.spi.SchemaNameResolver;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.jdbc.spi.TypeInfo;
import org.hibernate.exception.internal.SQLExceptionTypeDelegate;
import org.hibernate.exception.internal.SQLStateConversionDelegate;
import org.hibernate.exception.internal.StandardSQLExceptionConverter;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public class JdbcServicesImpl
implements JdbcServices,
ServiceRegistryAwareService,
Configurable {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)JdbcServicesImpl.class.getName());
    private ServiceRegistryImplementor serviceRegistry;
    private Dialect dialect;
    private ConnectionProvider connectionProvider;
    private SqlStatementLogger sqlStatementLogger;
    private SqlExceptionHelper sqlExceptionHelper;
    private ExtractedDatabaseMetaData extractedMetaDataSupport;
    private LobCreatorBuilder lobCreatorBuilder;
    public static final String SCHEMA_NAME_RESOLVER = "hibernate.schema_name_resolver";

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(Map configValues) {
        JdbcConnectionAccess jdbcConnectionAccess = this.buildJdbcConnectionAccess(configValues);
        DialectFactory dialectFactory = this.serviceRegistry.getService(DialectFactory.class);
        Dialect dialect = null;
        LobCreatorBuilder lobCreatorBuilder = null;
        boolean metaSupportsRefCursors = false;
        boolean metaSupportsNamedParams = false;
        boolean metaSupportsScrollable = false;
        boolean metaSupportsGetGeneratedKeys = false;
        boolean metaSupportsBatchUpdates = false;
        boolean metaReportsDDLCausesTxnCommit = false;
        boolean metaReportsDDLInTxnSupported = true;
        String extraKeywordsString = "";
        int sqlStateType = -1;
        boolean lobLocatorUpdateCopy = false;
        String catalogName = null;
        String schemaName = null;
        LinkedHashSet<TypeInfo> typeInfoSet = new LinkedHashSet<TypeInfo>();
        boolean useJdbcMetadata = ConfigurationHelper.getBoolean("hibernate.temp.use_jdbc_metadata_defaults", configValues, true);
        if (useJdbcMetadata) {
            try {
                final Connection connection = jdbcConnectionAccess.obtainConnection();
                try {
                    DatabaseMetaData meta = connection.getMetaData();
                    if (LOG.isDebugEnabled()) {
                        LOG.debugf("Database ->\n       name : %s\n    version : %s\n      major : %s\n      minor : %s", new Object[]{meta.getDatabaseProductName(), meta.getDatabaseProductVersion(), meta.getDatabaseMajorVersion(), meta.getDatabaseMinorVersion()});
                        LOG.debugf("Driver ->\n       name : %s\n    version : %s\n      major : %s\n      minor : %s", new Object[]{meta.getDriverName(), meta.getDriverVersion(), meta.getDriverMajorVersion(), meta.getDriverMinorVersion()});
                        LOG.debugf("JDBC version : %s.%s", meta.getJDBCMajorVersion(), meta.getJDBCMinorVersion());
                    }
                    metaSupportsRefCursors = StandardRefCursorSupport.supportsRefCursors(meta);
                    metaSupportsNamedParams = meta.supportsNamedParameters();
                    metaSupportsScrollable = meta.supportsResultSetType(1004);
                    metaSupportsBatchUpdates = meta.supportsBatchUpdates();
                    metaReportsDDLCausesTxnCommit = meta.dataDefinitionCausesTransactionCommit();
                    metaReportsDDLInTxnSupported = !meta.dataDefinitionIgnoredInTransactions();
                    metaSupportsGetGeneratedKeys = meta.supportsGetGeneratedKeys();
                    extraKeywordsString = meta.getSQLKeywords();
                    sqlStateType = meta.getSQLStateType();
                    lobLocatorUpdateCopy = meta.locatorsUpdateCopy();
                    typeInfoSet.addAll(TypeInfo.extractTypeInfo(meta));
                    dialect = dialectFactory.buildDialect(configValues, new DialectResolutionInfoSource(){

                        @Override
                        public DialectResolutionInfo getDialectResolutionInfo() {
                            try {
                                return new DatabaseMetaDataDialectResolutionInfoAdapter(connection.getMetaData());
                            }
                            catch (SQLException sqlException) {
                                throw new HibernateException("Unable to access java.sql.DatabaseMetaData to determine appropriate Dialect to use", sqlException);
                            }
                        }
                    });
                    catalogName = connection.getCatalog();
                    SchemaNameResolver schemaNameResolver = this.determineExplicitSchemaNameResolver(configValues);
                    if (schemaNameResolver == null) {
                        // empty if block
                    }
                    if (schemaNameResolver != null) {
                        schemaName = schemaNameResolver.resolveSchemaName(connection);
                    }
                    lobCreatorBuilder = new LobCreatorBuilder(configValues, connection);
                }
                catch (SQLException sqle) {
                    LOG.unableToObtainConnectionMetadata(sqle.getMessage());
                }
                finally {
                    if (connection != null) {
                        jdbcConnectionAccess.releaseConnection(connection);
                    }
                }
            }
            catch (SQLException sqle) {
                LOG.unableToObtainConnectionToQueryMetadata(sqle.getMessage());
                dialect = dialectFactory.buildDialect(configValues, null);
            }
            catch (UnsupportedOperationException uoe) {
                dialect = dialectFactory.buildDialect(configValues, null);
            }
        } else {
            dialect = dialectFactory.buildDialect(configValues, null);
        }
        boolean showSQL = ConfigurationHelper.getBoolean("hibernate.show_sql", configValues, false);
        boolean formatSQL = ConfigurationHelper.getBoolean("hibernate.format_sql", configValues, false);
        this.dialect = dialect;
        this.lobCreatorBuilder = lobCreatorBuilder == null ? new LobCreatorBuilder(configValues, null) : lobCreatorBuilder;
        this.sqlStatementLogger = new SqlStatementLogger(showSQL, formatSQL);
        this.extractedMetaDataSupport = new ExtractedDatabaseMetaDataImpl(metaSupportsRefCursors, metaSupportsNamedParams, metaSupportsScrollable, metaSupportsGetGeneratedKeys, metaSupportsBatchUpdates, metaReportsDDLInTxnSupported, metaReportsDDLCausesTxnCommit, this.parseKeywords(extraKeywordsString), this.parseSQLStateType(sqlStateType), lobLocatorUpdateCopy, schemaName, catalogName, typeInfoSet);
        SQLExceptionConverter sqlExceptionConverter = dialect.buildSQLExceptionConverter();
        if (sqlExceptionConverter == null) {
            StandardSQLExceptionConverter converter = new StandardSQLExceptionConverter();
            sqlExceptionConverter = converter;
            converter.addDelegate(dialect.buildSQLExceptionConversionDelegate());
            converter.addDelegate(new SQLExceptionTypeDelegate(dialect));
            converter.addDelegate(new SQLStateConversionDelegate(dialect));
        }
        this.sqlExceptionHelper = new SqlExceptionHelper(sqlExceptionConverter);
    }

    private JdbcConnectionAccess buildJdbcConnectionAccess(Map configValues) {
        MultiTenancyStrategy multiTenancyStrategy = MultiTenancyStrategy.determineMultiTenancyStrategy(configValues);
        if (MultiTenancyStrategy.NONE == multiTenancyStrategy) {
            this.connectionProvider = this.serviceRegistry.getService(ConnectionProvider.class);
            return new ConnectionProviderJdbcConnectionAccess(this.connectionProvider);
        }
        this.connectionProvider = null;
        MultiTenantConnectionProvider multiTenantConnectionProvider = this.serviceRegistry.getService(MultiTenantConnectionProvider.class);
        return new MultiTenantConnectionProviderJdbcConnectionAccess(multiTenantConnectionProvider);
    }

    private SchemaNameResolver determineExplicitSchemaNameResolver(Map configValues) {
        Object setting = configValues.get(SCHEMA_NAME_RESOLVER);
        if (SchemaNameResolver.class.isInstance(setting)) {
            return (SchemaNameResolver)setting;
        }
        String resolverClassName = (String)setting;
        if (resolverClassName != null) {
            try {
                Class resolverClass = ReflectHelper.classForName(resolverClassName, this.getClass());
                return (SchemaNameResolver)ReflectHelper.getDefaultConstructor(resolverClass).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                LOG.unableToLocateConfiguredSchemaNameResolver(resolverClassName, e.toString());
            }
            catch (InvocationTargetException e) {
                LOG.unableToInstantiateConfiguredSchemaNameResolver(resolverClassName, e.getTargetException().toString());
            }
            catch (Exception e) {
                LOG.unableToInstantiateConfiguredSchemaNameResolver(resolverClassName, e.toString());
            }
        }
        return null;
    }

    private Set<String> parseKeywords(String extraKeywordsString) {
        HashSet<String> keywordSet = new HashSet<String>();
        keywordSet.addAll(Arrays.asList(extraKeywordsString.split(",")));
        return keywordSet;
    }

    private ExtractedDatabaseMetaData.SQLStateType parseSQLStateType(int sqlStateType) {
        switch (sqlStateType) {
            case 2: {
                return ExtractedDatabaseMetaData.SQLStateType.SQL99;
            }
            case 1: {
                return ExtractedDatabaseMetaData.SQLStateType.XOpen;
            }
        }
        return ExtractedDatabaseMetaData.SQLStateType.UNKOWN;
    }

    @Override
    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public SqlStatementLogger getSqlStatementLogger() {
        return this.sqlStatementLogger;
    }

    @Override
    public SqlExceptionHelper getSqlExceptionHelper() {
        return this.sqlExceptionHelper;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public ExtractedDatabaseMetaData getExtractedMetaDataSupport() {
        return this.extractedMetaDataSupport;
    }

    @Override
    public LobCreator getLobCreator(LobCreationContext lobCreationContext) {
        return this.lobCreatorBuilder.buildLobCreator(lobCreationContext);
    }

    @Override
    public ResultSetWrapper getResultSetWrapper() {
        return ResultSetWrapperImpl.INSTANCE;
    }

    private static class ExtractedDatabaseMetaDataImpl
    implements ExtractedDatabaseMetaData {
        private final boolean supportsRefCursors;
        private final boolean supportsNamedParameters;
        private final boolean supportsScrollableResults;
        private final boolean supportsGetGeneratedKeys;
        private final boolean supportsBatchUpdates;
        private final boolean supportsDataDefinitionInTransaction;
        private final boolean doesDataDefinitionCauseTransactionCommit;
        private final Set<String> extraKeywords;
        private final ExtractedDatabaseMetaData.SQLStateType sqlStateType;
        private final boolean lobLocatorUpdateCopy;
        private final String connectionSchemaName;
        private final String connectionCatalogName;
        private final LinkedHashSet<TypeInfo> typeInfoSet;

        private ExtractedDatabaseMetaDataImpl(boolean supportsRefCursors, boolean supportsNamedParameters, boolean supportsScrollableResults, boolean supportsGetGeneratedKeys, boolean supportsBatchUpdates, boolean supportsDataDefinitionInTransaction, boolean doesDataDefinitionCauseTransactionCommit, Set<String> extraKeywords, ExtractedDatabaseMetaData.SQLStateType sqlStateType, boolean lobLocatorUpdateCopy, String connectionSchemaName, String connectionCatalogName, LinkedHashSet<TypeInfo> typeInfoSet) {
            this.supportsRefCursors = supportsRefCursors;
            this.supportsNamedParameters = supportsNamedParameters;
            this.supportsScrollableResults = supportsScrollableResults;
            this.supportsGetGeneratedKeys = supportsGetGeneratedKeys;
            this.supportsBatchUpdates = supportsBatchUpdates;
            this.supportsDataDefinitionInTransaction = supportsDataDefinitionInTransaction;
            this.doesDataDefinitionCauseTransactionCommit = doesDataDefinitionCauseTransactionCommit;
            this.extraKeywords = extraKeywords;
            this.sqlStateType = sqlStateType;
            this.lobLocatorUpdateCopy = lobLocatorUpdateCopy;
            this.connectionSchemaName = connectionSchemaName;
            this.connectionCatalogName = connectionCatalogName;
            this.typeInfoSet = typeInfoSet;
        }

        @Override
        public boolean supportsRefCursors() {
            return this.supportsRefCursors;
        }

        @Override
        public boolean supportsNamedParameters() {
            return this.supportsNamedParameters;
        }

        @Override
        public boolean supportsScrollableResults() {
            return this.supportsScrollableResults;
        }

        @Override
        public boolean supportsGetGeneratedKeys() {
            return this.supportsGetGeneratedKeys;
        }

        @Override
        public boolean supportsBatchUpdates() {
            return this.supportsBatchUpdates;
        }

        @Override
        public boolean supportsDataDefinitionInTransaction() {
            return this.supportsDataDefinitionInTransaction;
        }

        @Override
        public boolean doesDataDefinitionCauseTransactionCommit() {
            return this.doesDataDefinitionCauseTransactionCommit;
        }

        @Override
        public Set<String> getExtraKeywords() {
            return this.extraKeywords;
        }

        @Override
        public ExtractedDatabaseMetaData.SQLStateType getSqlStateType() {
            return this.sqlStateType;
        }

        @Override
        public boolean doesLobLocatorUpdateCopy() {
            return this.lobLocatorUpdateCopy;
        }

        @Override
        public String getConnectionSchemaName() {
            return this.connectionSchemaName;
        }

        @Override
        public String getConnectionCatalogName() {
            return this.connectionCatalogName;
        }

        @Override
        public LinkedHashSet<TypeInfo> getTypeInfoSet() {
            return this.typeInfoSet;
        }
    }

    private static class MultiTenantConnectionProviderJdbcConnectionAccess
    implements JdbcConnectionAccess {
        private final MultiTenantConnectionProvider connectionProvider;

        public MultiTenantConnectionProviderJdbcConnectionAccess(MultiTenantConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        @Override
        public Connection obtainConnection() throws SQLException {
            return this.connectionProvider.getAnyConnection();
        }

        @Override
        public void releaseConnection(Connection connection) throws SQLException {
            this.connectionProvider.releaseAnyConnection(connection);
        }

        @Override
        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }

    private static class ConnectionProviderJdbcConnectionAccess
    implements JdbcConnectionAccess {
        private final ConnectionProvider connectionProvider;

        public ConnectionProviderJdbcConnectionAccess(ConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        @Override
        public Connection obtainConnection() throws SQLException {
            return this.connectionProvider.getConnection();
        }

        @Override
        public void releaseConnection(Connection connection) throws SQLException {
            this.connectionProvider.closeConnection(connection);
        }

        @Override
        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }
}

