/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.persistence.EntityNotFoundException;
import org.hibernate.HibernateException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.QueryCache;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.UpdateTimestampsCache;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.jboss.logging.Logger;

public class StandardQueryCache
implements QueryCache {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)StandardQueryCache.class.getName());
    private static final boolean DEBUGGING = LOG.isDebugEnabled();
    private static final boolean TRACING = LOG.isTraceEnabled();
    private QueryResultsRegion cacheRegion;
    private UpdateTimestampsCache updateTimestampsCache;

    public StandardQueryCache(Settings settings, Properties props, UpdateTimestampsCache updateTimestampsCache, String regionName) {
        String prefix;
        String regionNameToUse = regionName;
        if (regionNameToUse == null) {
            regionNameToUse = StandardQueryCache.class.getName();
        }
        if ((prefix = settings.getCacheRegionPrefix()) != null) {
            regionNameToUse = prefix + '.' + regionNameToUse;
        }
        LOG.startingQueryCache(regionNameToUse);
        this.cacheRegion = settings.getRegionFactory().buildQueryResultsRegion(regionNameToUse, props);
        this.updateTimestampsCache = updateTimestampsCache;
    }

    @Override
    public QueryResultsRegion getRegion() {
        return this.cacheRegion;
    }

    @Override
    public void destroy() {
        try {
            this.cacheRegion.destroy();
        }
        catch (Exception e) {
            LOG.unableToDestroyQueryCache(this.cacheRegion.getName(), e.getMessage());
        }
    }

    @Override
    public void clear() throws CacheException {
        this.cacheRegion.evictAll();
    }

    @Override
    public boolean put(QueryKey key, Type[] returnTypes, List result, boolean isNaturalKeyLookup, SessionImplementor session) throws HibernateException {
        if (isNaturalKeyLookup && result.isEmpty()) {
            return false;
        }
        long ts = this.cacheRegion.nextTimestamp();
        if (DEBUGGING) {
            LOG.debugf("Caching query results in region: %s; timestamp=%s", this.cacheRegion.getName(), ts);
        }
        ArrayList<Object> cacheable = new ArrayList<Object>(result.size() + 1);
        StandardQueryCache.logCachedResultDetails(key, null, returnTypes, cacheable);
        cacheable.add(ts);
        boolean isSingleResult = returnTypes.length == 1;
        for (Object aResult : result) {
            Serializable[] cacheItem = isSingleResult ? returnTypes[0].disassemble(aResult, session, null) : TypeHelper.disassemble((Object[])aResult, returnTypes, null, session, null);
            cacheable.add(cacheItem);
            StandardQueryCache.logCachedResultRowDetails(returnTypes, aResult);
        }
        this.cacheRegion.put(key, cacheable);
        return true;
    }

    @Override
    public List get(QueryKey key, Type[] returnTypes, boolean isNaturalKeyLookup, Set<Serializable> spaces, SessionImplementor session) throws HibernateException {
        if (DEBUGGING) {
            LOG.debugf("Checking cached query results in region: %s", this.cacheRegion.getName());
        }
        List cacheable = (List)this.cacheRegion.get(key);
        StandardQueryCache.logCachedResultDetails(key, spaces, returnTypes, cacheable);
        if (cacheable == null) {
            if (DEBUGGING) {
                LOG.debug("Query results were not found in cache");
            }
            return null;
        }
        Long timestamp = (Long)cacheable.get(0);
        if (!isNaturalKeyLookup && !this.isUpToDate(spaces, timestamp)) {
            if (DEBUGGING) {
                LOG.debug("Cached query results were not up-to-date");
            }
            return null;
        }
        if (DEBUGGING) {
            LOG.debug("Returning cached query results");
        }
        boolean singleResult = returnTypes.length == 1;
        for (int i = 1; i < cacheable.size(); ++i) {
            if (singleResult) {
                returnTypes[0].beforeAssemble((Serializable)cacheable.get(i), session);
                continue;
            }
            TypeHelper.beforeAssemble((Serializable[])cacheable.get(i), returnTypes, session);
        }
        ArrayList<Object> result = new ArrayList<Object>(cacheable.size() - 1);
        for (int i = 1; i < cacheable.size(); ++i) {
            try {
                if (singleResult) {
                    result.add(returnTypes[0].assemble((Serializable)cacheable.get(i), session, null));
                } else {
                    result.add(TypeHelper.assemble((Serializable[])cacheable.get(i), returnTypes, session, null));
                }
                StandardQueryCache.logCachedResultRowDetails(returnTypes, result.get(i - 1));
                continue;
            }
            catch (RuntimeException ex) {
                if (isNaturalKeyLookup && (UnresolvableObjectException.class.isInstance(ex) || EntityNotFoundException.class.isInstance(ex))) {
                    if (DEBUGGING) {
                        LOG.debug("Unable to reassemble cached natural-id query result");
                    }
                    this.cacheRegion.evict(key);
                    return null;
                }
                throw ex;
            }
        }
        return result;
    }

    protected boolean isUpToDate(Set<Serializable> spaces, Long timestamp) {
        if (DEBUGGING) {
            LOG.debugf("Checking query spaces are up-to-date: %s", spaces);
        }
        return this.updateTimestampsCache.isUpToDate(spaces, timestamp);
    }

    public String toString() {
        return "StandardQueryCache(" + this.cacheRegion.getName() + ')';
    }

    private static void logCachedResultDetails(QueryKey key, Set querySpaces, Type[] returnTypes, List result) {
        if (!TRACING) {
            return;
        }
        LOG.trace("key.hashCode=" + key.hashCode());
        LOG.trace("querySpaces=" + querySpaces);
        if (returnTypes == null || returnTypes.length == 0) {
            LOG.trace("Unexpected returnTypes is " + (returnTypes == null ? "null" : "empty") + "! result" + (result == null ? " is null" : ".size()=" + result.size()));
        } else {
            StringBuilder returnTypeInfo = new StringBuilder();
            for (Type returnType : returnTypes) {
                returnTypeInfo.append("typename=").append(returnType.getName()).append(" class=").append(returnType.getReturnedClass().getName()).append(' ');
            }
            LOG.trace("unexpected returnTypes is " + returnTypeInfo.toString() + "! result");
        }
    }

    private static void logCachedResultRowDetails(Type[] returnTypes, Object result) {
        Object[] objectArray;
        if (!TRACING) {
            return;
        }
        if (result instanceof Object[]) {
            objectArray = (Object[])result;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = result;
        }
        StandardQueryCache.logCachedResultRowDetails(returnTypes, objectArray);
    }

    private static void logCachedResultRowDetails(Type[] returnTypes, Object[] tuple) {
        if (!TRACING) {
            return;
        }
        if (tuple == null) {
            LOG.tracef("tuple is null; returnTypes is %s", returnTypes == null ? "null" : "Type[" + returnTypes.length + "]");
            if (returnTypes != null && returnTypes.length > 1) {
                LOG.trace("Unexpected result tuple! tuple is null; should be Object[" + returnTypes.length + "]!");
            }
        } else {
            if (returnTypes == null || returnTypes.length == 0) {
                LOG.trace("Unexpected result tuple! tuple is null; returnTypes is " + (returnTypes == null ? "null" : "empty"));
            }
            LOG.tracef("tuple is Object[%s]; returnTypes is %s", tuple.length, returnTypes == null ? "null" : "Type[" + returnTypes.length + "]");
            if (returnTypes != null && tuple.length != returnTypes.length) {
                LOG.trace("Unexpected tuple length! transformer= expected=" + returnTypes.length + " got=" + tuple.length);
            } else {
                for (int j = 0; j < tuple.length; ++j) {
                    if (tuple[j] == null || returnTypes == null || returnTypes[j].getReturnedClass().isInstance(tuple[j])) continue;
                    LOG.trace("Unexpected tuple value type! transformer= expected=" + returnTypes[j].getReturnedClass().getName() + " got=" + tuple[j].getClass().getName());
                }
            }
        }
    }
}

