/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.jboss.logging.Logger;

public abstract class BasicExtractor<J>
implements ValueExtractor<J> {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)BasicExtractor.class.getName());
    private final JavaTypeDescriptor<J> javaDescriptor;
    private final SqlTypeDescriptor sqlDescriptor;

    public BasicExtractor(JavaTypeDescriptor<J> javaDescriptor, SqlTypeDescriptor sqlDescriptor) {
        this.javaDescriptor = javaDescriptor;
        this.sqlDescriptor = sqlDescriptor;
    }

    public JavaTypeDescriptor<J> getJavaDescriptor() {
        return this.javaDescriptor;
    }

    public SqlTypeDescriptor getSqlDescriptor() {
        return this.sqlDescriptor;
    }

    @Override
    public J extract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
        J value = this.doExtract(rs, name, options);
        if (value == null || rs.wasNull()) {
            LOG.tracev("Found [null] as column [{0}]", name);
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Found [{0}] as column [{1}]", this.getJavaDescriptor().extractLoggableRepresentation(value), name);
        }
        return value;
    }

    protected abstract J doExtract(ResultSet var1, String var2, WrapperOptions var3) throws SQLException;

    @Override
    public J extract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
        J value = this.doExtract(statement, index, options);
        if (value == null || statement.wasNull()) {
            LOG.tracev("Found [null] as procedure output  parameter [{0}]", index);
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Found [{0}] as procedure output parameter [{1}]", this.getJavaDescriptor().extractLoggableRepresentation(value), index);
        }
        return value;
    }

    protected abstract J doExtract(CallableStatement var1, int var2, WrapperOptions var3) throws SQLException;

    @Override
    public J extract(CallableStatement statement, String[] paramNames, WrapperOptions options) throws SQLException {
        if (paramNames.length > 1) {
            throw new IllegalArgumentException("Basic value extraction cannot handle multiple output parameters");
        }
        String paramName = paramNames[0];
        J value = this.doExtract(statement, paramName, options);
        if (value == null || statement.wasNull()) {
            LOG.tracev("Found [null] as procedure output  parameter [{0}]", paramName);
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Found [{0}] as procedure output parameter [{1}]", this.getJavaDescriptor().extractLoggableRepresentation(value), paramName);
        }
        return value;
    }

    protected abstract J doExtract(CallableStatement var1, String var2, WrapperOptions var3) throws SQLException;
}

