/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.engine.jdbc.cursor.spi.RefCursorSupport;
import org.hibernate.procedure.ParameterRegistration;
import org.hibernate.procedure.ProcedureResult;
import org.hibernate.procedure.internal.ParameterRegistrationImplementor;
import org.hibernate.procedure.internal.ProcedureCallImpl;
import org.hibernate.result.Return;
import org.hibernate.result.internal.ResultImpl;

public class ProcedureResultImpl
extends ResultImpl
implements ProcedureResult {
    private final ProcedureCallImpl procedureCall;
    private final CallableStatement callableStatement;
    private final ParameterRegistrationImplementor[] refCursorParameters;
    private int refCursorParamIndex = 0;

    ProcedureResultImpl(ProcedureCallImpl procedureCall, CallableStatement callableStatement) {
        super(procedureCall, callableStatement);
        this.procedureCall = procedureCall;
        this.callableStatement = callableStatement;
        this.refCursorParameters = procedureCall.collectRefCursorParameters();
    }

    @Override
    public <T> T getOutputParameterValue(ParameterRegistration<T> parameterRegistration) {
        return ((ParameterRegistrationImplementor)parameterRegistration).extract(this.callableStatement);
    }

    @Override
    public Object getOutputParameterValue(String name) {
        return this.procedureCall.getParameterRegistration(name).extract(this.callableStatement);
    }

    @Override
    public Object getOutputParameterValue(int position) {
        return this.procedureCall.getParameterRegistration(position).extract(this.callableStatement);
    }

    @Override
    protected ResultImpl.CurrentReturnDescriptor buildCurrentReturnDescriptor(boolean isResultSet, int updateCount) {
        return new ProcedureCurrentReturnDescriptor(isResultSet, updateCount, this.refCursorParamIndex);
    }

    @Override
    protected boolean hasMoreReturns(ResultImpl.CurrentReturnDescriptor descriptor) {
        return super.hasMoreReturns(descriptor) || ((ProcedureCurrentReturnDescriptor)descriptor).refCursorParamIndex < this.refCursorParameters.length;
    }

    @Override
    protected Return buildExtendedReturn(ResultImpl.CurrentReturnDescriptor returnDescriptor) {
        ++this.refCursorParamIndex;
        int refCursorParamIndex = ((ProcedureCurrentReturnDescriptor)returnDescriptor).refCursorParamIndex;
        ParameterRegistrationImplementor refCursorParam = this.refCursorParameters[refCursorParamIndex];
        ResultSet resultSet = refCursorParam.getName() != null ? this.procedureCall.getSession().getFactory().getServiceRegistry().getService(RefCursorSupport.class).getResultSet(this.callableStatement, refCursorParam.getName()) : this.procedureCall.getSession().getFactory().getServiceRegistry().getService(RefCursorSupport.class).getResultSet(this.callableStatement, refCursorParam.getPosition());
        return new ResultImpl.ResultSetReturn(this, resultSet);
    }

    @Override
    protected JDBCException convert(SQLException e, String message) {
        return this.procedureCall.getSession().getFactory().getSQLExceptionHelper().convert(e, message, this.procedureCall.getProcedureName());
    }

    protected static class ProcedureCurrentReturnDescriptor
    extends ResultImpl.CurrentReturnDescriptor {
        private final int refCursorParamIndex;

        private ProcedureCurrentReturnDescriptor(boolean isResultSet, int updateCount, int refCursorParamIndex) {
            super(isResultSet, updateCount);
            this.refCursorParamIndex = refCursorParamIndex;
        }
    }
}

