/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.ParameterMode;
import javax.persistence.TemporalType;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.jdbc.cursor.spi.RefCursorSupport;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.procedure.ParameterBind;
import org.hibernate.procedure.ParameterMisuseException;
import org.hibernate.procedure.internal.ParameterBindImpl;
import org.hibernate.procedure.internal.ParameterRegistrationImplementor;
import org.hibernate.procedure.internal.ParameterStrategy;
import org.hibernate.procedure.internal.ProcedureCallImpl;
import org.hibernate.type.DateType;
import org.hibernate.type.ProcedureParameterExtractionAware;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public abstract class AbstractParameterRegistrationImpl<T>
implements ParameterRegistrationImplementor<T> {
    private static final Logger log = Logger.getLogger(AbstractParameterRegistrationImpl.class);
    private final ProcedureCallImpl procedureCall;
    private final Integer position;
    private final String name;
    private final ParameterMode mode;
    private final Class<T> type;
    private ParameterBindImpl bind;
    private int startIndex;
    private Type hibernateType;
    private int[] sqlTypes;

    protected AbstractParameterRegistrationImpl(ProcedureCallImpl procedureCall, Integer position, Class<T> type, ParameterMode mode) {
        this(procedureCall, position, null, type, mode);
    }

    protected AbstractParameterRegistrationImpl(ProcedureCallImpl procedureCall, String name, Class<T> type, ParameterMode mode) {
        this(procedureCall, null, name, type, mode);
    }

    private AbstractParameterRegistrationImpl(ProcedureCallImpl procedureCall, Integer position, String name, Class<T> type, ParameterMode mode) {
        this.procedureCall = procedureCall;
        this.position = position;
        this.name = name;
        this.mode = mode;
        this.type = type;
        this.setHibernateType(this.session().getFactory().getTypeResolver().heuristicType(type.getName()));
    }

    protected SessionImplementor session() {
        return this.procedureCall.getSession();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public ParameterMode getMode() {
        return this.mode;
    }

    @Override
    public void setHibernateType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        this.hibernateType = type;
        this.sqlTypes = this.hibernateType.sqlTypes(this.session().getFactory());
    }

    @Override
    public ParameterBind<T> getBind() {
        return this.bind;
    }

    @Override
    public void bindValue(T value) {
        this.validateBindability();
        this.bind = new ParameterBindImpl<T>(value);
    }

    private void validateBindability() {
        if (!this.canBind()) {
            throw new ParameterMisuseException("Cannot bind value to non-input parameter : " + this);
        }
    }

    private boolean canBind() {
        return this.mode == ParameterMode.IN || this.mode == ParameterMode.INOUT;
    }

    @Override
    public void bindValue(T value, TemporalType explicitTemporalType) {
        this.validateBindability();
        if (explicitTemporalType != null && !this.isDateTimeType()) {
            throw new IllegalArgumentException("TemporalType should not be specified for non date/time type");
        }
        this.bind = new ParameterBindImpl<T>(value, explicitTemporalType);
    }

    private boolean isDateTimeType() {
        return Date.class.isAssignableFrom(this.type) || Calendar.class.isAssignableFrom(this.type);
    }

    @Override
    public void prepare(CallableStatement statement, int startIndex) throws SQLException {
        if (this.mode == ParameterMode.REF_CURSOR) {
            throw new NotYetImplementedException("Support for REF_CURSOR parameters not yet supported");
        }
        this.startIndex = startIndex;
        if (this.mode == ParameterMode.IN || this.mode == ParameterMode.INOUT || this.mode == ParameterMode.OUT) {
            if (this.mode == ParameterMode.INOUT || this.mode == ParameterMode.OUT) {
                if (!(this.sqlTypes.length <= 1 || ProcedureParameterExtractionAware.class.isInstance(this.hibernateType) && ((ProcedureParameterExtractionAware)this.hibernateType).canDoExtraction())) {
                    throw new UnsupportedOperationException("Type [" + this.hibernateType + "] does support multi-parameter value extraction");
                }
                for (int i = 0; i < this.sqlTypes.length; ++i) {
                    statement.registerOutParameter(startIndex + i, this.sqlTypes[i]);
                }
            }
            if (this.mode == ParameterMode.INOUT || this.mode == ParameterMode.IN) {
                if (this.bind == null || this.bind.getValue() == null) {
                    log.debugf("Stored procedure [%s] IN/INOUT parameter [%s] not bound; assuming procedure defines default value", (Object)this.procedureCall.getProcedureName(), (Object)this);
                } else {
                    Type typeToUse = this.bind.getExplicitTemporalType() != null && this.bind.getExplicitTemporalType() == TemporalType.TIMESTAMP ? this.hibernateType : (this.bind.getExplicitTemporalType() != null && this.bind.getExplicitTemporalType() == TemporalType.DATE ? DateType.INSTANCE : this.hibernateType);
                    typeToUse.nullSafeSet(statement, this.bind.getValue(), startIndex, this.session());
                }
            }
        } else if (this.procedureCall.getParameterStrategy() == ParameterStrategy.NAMED) {
            this.session().getFactory().getServiceRegistry().getService(RefCursorSupport.class).registerRefCursorParameter(statement, this.getName());
        } else {
            this.session().getFactory().getServiceRegistry().getService(RefCursorSupport.class).registerRefCursorParameter(statement, this.getPosition());
        }
    }

    @Override
    public int[] getSqlTypes() {
        return this.sqlTypes;
    }

    @Override
    public T extract(CallableStatement statement) {
        if (this.mode == ParameterMode.IN) {
            throw new ParameterMisuseException("IN parameter not valid for output extraction");
        }
        if (this.mode == ParameterMode.REF_CURSOR) {
            throw new ParameterMisuseException("REF_CURSOR parameters should be accessed via results");
        }
        try {
            if (ProcedureParameterExtractionAware.class.isInstance(this.hibernateType)) {
                return ((ProcedureParameterExtractionAware)this.hibernateType).extract(statement, this.startIndex, this.session());
            }
            return (T)statement.getObject(this.startIndex);
        }
        catch (SQLException e) {
            throw this.procedureCall.getSession().getFactory().getSQLExceptionHelper().convert(e, "Unable to extract OUT/INOUT parameter value");
        }
    }
}

