/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.DoubleType;
import org.hibernate.type.Type;

public class AvgFunction
implements SQLFunction {
    public final Type getReturnType(Type columnType, Mapping mapping) throws QueryException {
        int[] sqlTypes;
        try {
            sqlTypes = columnType.sqlTypes(mapping);
        }
        catch (MappingException me) {
            throw new QueryException(me);
        }
        if (sqlTypes.length != 1) {
            throw new QueryException("multiple-column type in avg()");
        }
        return DoubleType.INSTANCE;
    }

    public final boolean hasArguments() {
        return true;
    }

    public final boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public String render(List args, SessionFactoryImplementor factory) throws QueryException {
        return "avg(" + args.get(0) + ")";
    }

    public final String toString() {
        return "avg";
    }
}

