/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.hibernate.HibernateException;
import org.hibernate.event.DirtyCheckEvent;
import org.hibernate.event.DirtyCheckEventListener;
import org.hibernate.event.def.AbstractFlushingEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDirtyCheckEventListener
extends AbstractFlushingEventListener
implements DirtyCheckEventListener {
    private static final Logger log = LoggerFactory.getLogger((Class)DefaultDirtyCheckEventListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDirtyCheck(DirtyCheckEvent event) throws HibernateException {
        int oldSize = event.getSession().getActionQueue().numberOfCollectionRemovals();
        try {
            this.flushEverythingToExecutions(event);
            boolean wasNeeded = event.getSession().getActionQueue().hasAnyQueuedActions();
            log.debug(wasNeeded ? "session dirty" : "session not dirty");
            event.setDirty(wasNeeded);
        }
        finally {
            event.getSession().getActionQueue().clearFromFlushNeededCheck(oldSize);
        }
    }
}

