/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TransactionHelper;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.jdbc.util.FormatStyle;
import org.hibernate.jdbc.util.SQLStatementLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStructure
extends TransactionHelper
implements DatabaseStructure {
    private static final Logger log = LoggerFactory.getLogger((Class)TableStructure.class);
    private static final SQLStatementLogger SQL_STATEMENT_LOGGER = new SQLStatementLogger(false, false);
    private final String tableName;
    private final String valueColumnName;
    private final int initialValue;
    private final int incrementSize;
    private final String selectQuery;
    private final String updateQuery;
    private boolean applyIncrementSizeToSourceValues;
    private int accessCounter;

    public TableStructure(Dialect dialect, String tableName, String valueColumnName, int initialValue, int incrementSize) {
        this.tableName = tableName;
        this.initialValue = initialValue;
        this.incrementSize = incrementSize;
        this.valueColumnName = valueColumnName;
        this.selectQuery = "select " + valueColumnName + " as id_val" + " from " + dialect.appendLockHint(LockMode.PESSIMISTIC_WRITE, tableName) + dialect.getForUpdateString();
        this.updateQuery = "update " + tableName + " set " + valueColumnName + "= ?" + " where " + valueColumnName + "=?";
    }

    public String getName() {
        return this.tableName;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public int getIncrementSize() {
        return this.incrementSize;
    }

    public int getTimesAccessed() {
        return this.accessCounter;
    }

    public void prepare(Optimizer optimizer) {
        this.applyIncrementSizeToSourceValues = optimizer.applyIncrementSizeToSourceValues();
    }

    public AccessCallback buildCallback(final SessionImplementor session) {
        return new AccessCallback(){

            public long getNextValue() {
                return ((Number)TableStructure.this.doWorkInNewTransaction(session)).longValue();
            }
        };
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getCreateTableString() + " " + this.tableName + " ( " + this.valueColumnName + " " + dialect.getTypeName(-5) + " )", "insert into " + this.tableName + " values ( " + this.initialValue + " )"};
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        StringBuffer sqlDropString = new StringBuffer().append("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            sqlDropString.append("if exists ");
        }
        sqlDropString.append(this.tableName).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            sqlDropString.append(" if exists");
        }
        return new String[]{sqlDropString.toString()};
    }

    protected Serializable doWorkInCurrentTransaction(Connection conn, String sql) throws SQLException {
        long result;
        int rows;
        do {
            Object var12_12;
            Object var10_11;
            SQL_STATEMENT_LOGGER.logStatement(this.selectQuery, FormatStyle.BASIC);
            PreparedStatement selectPS = conn.prepareStatement(this.selectQuery);
            try {
                try {
                    ResultSet selectRS = selectPS.executeQuery();
                    if (!selectRS.next()) {
                        String err = "could not read a hi value - you need to populate the table: " + this.tableName;
                        log.error(err);
                        throw new IdentifierGenerationException(err);
                    }
                    result = selectRS.getLong(1);
                    selectRS.close();
                }
                catch (SQLException sqle) {
                    log.error("could not read a hi value", (Throwable)sqle);
                    throw sqle;
                }
                var10_11 = null;
            }
            catch (Throwable throwable) {
                var10_11 = null;
                selectPS.close();
                throw throwable;
            }
            selectPS.close();
            SQL_STATEMENT_LOGGER.logStatement(this.updateQuery, FormatStyle.BASIC);
            PreparedStatement updatePS = conn.prepareStatement(this.updateQuery);
            try {
                try {
                    int increment = this.applyIncrementSizeToSourceValues ? this.incrementSize : 1;
                    updatePS.setLong(1, result + (long)increment);
                    updatePS.setLong(2, result);
                    rows = updatePS.executeUpdate();
                }
                catch (SQLException sqle) {
                    log.error("could not updateQuery hi value in: " + this.tableName, (Throwable)sqle);
                    throw sqle;
                }
                var12_12 = null;
            }
            catch (Throwable throwable) {
                var12_12 = null;
                updatePS.close();
                throw throwable;
            }
            updatePS.close();
        } while (rows == 0);
        ++this.accessCounter;
        return new Long(result);
    }
}

