/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.lang.reflect.Array;
import java.util.List;
import java.util.StringTokenizer;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.h5.H5File;

public class H5Datatype
extends Datatype {
    public static final long serialVersionUID = 240L;
    private List attributeList;
    private boolean isNamed = false;
    private int nAttributes = -1;
    private boolean isVLEN = false;
    private String description = null;

    public H5Datatype(FileFormat fileFormat, String string, String string2) {
        super(fileFormat, string, string2, null);
    }

    @Deprecated
    public H5Datatype(FileFormat fileFormat, String string, String string2, long[] lArray) {
        super(fileFormat, string, string2, lArray);
        if (lArray == null && fileFormat != null) {
            try {
                byte[] byArray = H5.H5Rcreate(fileFormat.getFID(), this.getFullName(), HDF5Constants.H5R_OBJECT, -1);
                this.oid = new long[1];
                this.oid[0] = HDFNativeData.byteToLong(byArray, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public H5Datatype(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public H5Datatype(int n) {
        super(n);
        this.description = H5Datatype.getDatatypeDescription(n);
        this.fromNative(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAttribute() {
        if (this.nAttributes < 0) {
            int n = -1;
            try {
                n = H5.H5Topen(this.getFID(), this.getPath() + this.getName());
                this.fromNative(n);
                this.nAttributes = H5.H5Aget_num_attrs(n);
                this.isNamed = true;
            }
            catch (Exception exception) {
                this.nAttributes = 0;
            }
            finally {
                try {
                    H5.H5Tclose(n);
                }
                catch (Exception exception) {}
            }
        }
        return this.nAttributes > 0;
    }

    public static final String[] convertEnumValueToName(int n, Object object, String[] stringArray) throws HDF5Exception {
        int n2;
        int n3 = 0;
        if (object == null || (n3 = Array.getLength(object)) <= 0 || stringArray != null && n3 != Array.getLength(stringArray)) {
            return null;
        }
        int n4 = H5.H5Tget_nmembers(n);
        if (n4 <= 0) {
            return null;
        }
        if (stringArray == null) {
            stringArray = new String[n3];
        } else {
            for (int i = 0; i < n3; ++i) {
                stringArray[i] = null;
            }
        }
        String[] stringArray2 = new String[n4];
        int[] nArray = new int[n4];
        int[] nArray2 = new int[]{0};
        for (n2 = 0; n2 < n4; ++n2) {
            stringArray2[n2] = H5.H5Tget_member_name(n, n2);
            H5.H5Tget_member_value(n, n2, nArray2);
            nArray[n2] = nArray2[0];
        }
        n2 = -1;
        block2: for (int i = 0; i < n3; ++i) {
            n2 = Array.getInt(object, i);
            for (int j = 0; j < n4; ++j) {
                if (n2 != nArray[j]) continue;
                stringArray[i] = stringArray2[j];
                continue block2;
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fromNative(int n) {
        int n2 = -1;
        int n3 = -1;
        boolean bl = false;
        boolean bl2 = false;
        try {
            n2 = H5.H5Tget_class(n);
            n3 = H5.H5Tget_size(n);
            this.isVLEN = n2 == HDF5Constants.H5T_VLEN;
        }
        catch (Exception exception) {
            this.datatypeClass = -1;
        }
        try {
            bl2 = H5.H5Tequal(n, HDF5Constants.H5T_NATIVE_UCHAR);
            bl = H5.H5Tequal(n, HDF5Constants.H5T_NATIVE_CHAR) || bl2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 == HDF5Constants.H5T_ARRAY) {
            int n4 = -1;
            this.datatypeClass = 10;
            try {
                int n5 = H5.H5Tget_array_ndims(n);
                this.dims = new int[n5];
                H5.H5Tget_array_dims(n, this.dims, null);
                n4 = H5.H5Tget_super(n);
                this.baseType = new H5Datatype(n4);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    H5.H5Tclose(n4);
                }
                catch (Exception exception) {}
            }
        } else if (bl) {
            this.datatypeClass = 2;
            if (bl2) {
                this.datatypeSign = 0;
            }
        } else if (n2 == HDF5Constants.H5T_INTEGER) {
            this.datatypeClass = 0;
            try {
                int n6 = H5.H5Tget_sign(n);
                if (n6 == HDF5Constants.H5T_SGN_NONE) {
                    this.datatypeSign = 0;
                }
            }
            catch (Exception exception) {}
        } else if (n2 == HDF5Constants.H5T_FLOAT) {
            this.datatypeClass = 1;
        } else if (n2 == HDF5Constants.H5T_STRING) {
            try {
                this.isVLEN = H5.H5Tis_variable_str(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.datatypeClass = 3;
        } else if (n2 == HDF5Constants.H5T_REFERENCE) {
            this.datatypeClass = 7;
        } else if (n2 == HDF5Constants.H5T_ENUM) {
            this.datatypeClass = 8;
            try {
                int n7 = H5.H5Tget_nmembers(n);
                String string = null;
                int[] nArray = new int[1];
                String string2 = "";
                for (int i = 0; i < n7; ++i) {
                    string = H5.H5Tget_member_name(n, i);
                    H5.H5Tget_member_value(n, i, nArray);
                    string2 = string2 + string + "=" + nArray[0] + ",";
                }
                this.enumMembers = string2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.datatypeSize = this.isVLEN ? -1 : n3;
        this.datatypeOrder = -1;
    }

    @Deprecated
    public static int toNative(int n) {
        int n2 = -1;
        try {
            n2 = H5.H5Tget_native_type(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (H5.H5Tis_variable_str(n)) {
                H5.H5Tset_size(n2, HDF5Constants.H5T_VARIABLE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int toNative() {
        int n = -1;
        int n2 = -1;
        if (this.isNamed) {
            try {
                n = H5.H5Topen(this.getFID(), this.getPath() + this.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n >= 0) {
            return n;
        }
        try {
            switch (this.datatypeClass) {
                case 10: {
                    try {
                        n2 = this.baseType.toNative();
                        n = H5.H5Tarray_create(n2, this.dims.length, this.dims, null);
                        break;
                    }
                    finally {
                        this.close(n2);
                    }
                }
                case 0: 
                case 8: {
                    n = this.datatypeSize == 1 ? H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT8) : (this.datatypeSize == 2 ? H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT16) : (this.datatypeSize == 4 ? H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT32) : (this.datatypeSize == 8 ? H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT64) : H5.H5Tcopy(HDF5Constants.H5T_NATIVE_INT))));
                    if (this.datatypeOrder == 1) {
                        H5.H5Tset_order(n, HDF5Constants.H5T_ORDER_BE);
                    } else if (this.datatypeOrder == 0) {
                        H5.H5Tset_order(n, HDF5Constants.H5T_ORDER_LE);
                    }
                    if (this.datatypeSign != 0) break;
                    H5.H5Tset_sign(n, HDF5Constants.H5T_SGN_NONE);
                    break;
                }
                case 1: {
                    n = this.datatypeSize == 8 ? H5.H5Tcopy(HDF5Constants.H5T_NATIVE_DOUBLE) : H5.H5Tcopy(HDF5Constants.H5T_NATIVE_FLOAT);
                    if (this.datatypeOrder == 1) {
                        H5.H5Tset_order(n, HDF5Constants.H5T_ORDER_BE);
                        break;
                    }
                    if (this.datatypeOrder != 0) break;
                    H5.H5Tset_order(n, HDF5Constants.H5T_ORDER_LE);
                    break;
                }
                case 2: {
                    if (this.datatypeSign == 0) {
                        n = H5.H5Tcopy(HDF5Constants.H5T_NATIVE_UCHAR);
                        break;
                    }
                    n = H5.H5Tcopy(HDF5Constants.H5T_NATIVE_CHAR);
                    break;
                }
                case 3: {
                    n = H5.H5Tcopy(HDF5Constants.H5T_C_S1);
                    if (this.isVLEN) {
                        H5.H5Tset_size(n, HDF5Constants.H5T_VARIABLE);
                    } else {
                        H5.H5Tset_size(n, this.datatypeSize);
                    }
                    H5.H5Tset_strpad(n, HDF5Constants.H5T_STR_NULLPAD);
                    break;
                }
                case 7: {
                    n = this.datatypeSize > H5.H5Tget_size(HDF5Constants.H5T_STD_REF_OBJ) ? H5.H5Tcopy(HDF5Constants.H5T_STD_REF_DSETREG) : H5.H5Tcopy(HDF5Constants.H5T_STD_REF_OBJ);
                }
            }
        }
        catch (Exception exception) {
            n = -1;
        }
        if (this.datatypeClass == 8) {
            int n3 = n;
            try {
                n = H5.H5Tenum_create(n3);
                int n4 = 0;
                StringTokenizer stringTokenizer = this.enumMembers == null ? new StringTokenizer("0,1", ",") : new StringTokenizer(this.enumMembers, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string;
                    String string2 = stringTokenizer.nextToken();
                    if (string2 != null) {
                        string2 = string2.trim();
                    }
                    if (string2 == null || string2.length() < 1) continue;
                    int n5 = string2.indexOf(61);
                    if (n5 > 0) {
                        string = string2.substring(0, n5);
                        n4 = Integer.parseInt(string2.substring(n5 + 1));
                    } else {
                        string = string2;
                        ++n4;
                    }
                    H5.H5Tenum_insert(n, string, n4);
                }
            }
            catch (Exception exception) {
                n = -1;
            }
            try {
                H5.H5Tclose(n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object allocateArray(int n, int n2) throws OutOfMemoryError {
        Object object = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n2 < 0) {
            return null;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        try {
            n3 = H5.H5Tget_class(n);
            n4 = H5.H5Tget_size(n);
            n5 = H5.H5Tget_sign(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bl2 = H5.H5Tis_variable_str(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bl = n3 == HDF5Constants.H5T_VLEN;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bl3 = H5.H5Tequal(n, HDF5Constants.H5T_STD_REF_DSETREG);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl2 || bl || bl3) {
            object = new String[n2];
            for (int i = 0; i < n2; ++i) {
                object[i] = "";
            }
        } else if (n3 == HDF5Constants.H5T_INTEGER) {
            if (n4 == 1) {
                object = new byte[n2];
            } else if (n4 == 2) {
                object = new short[n2];
            } else if (n4 == 4) {
                object = new int[n2];
            } else if (n4 == 8) {
                object = new long[n2];
            }
        } else if (n3 == HDF5Constants.H5T_ENUM) {
            int n6 = -1;
            try {
                n6 = H5.H5Tget_super(n);
                object = H5Datatype.allocateArray(n6, n2);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    H5.H5Tclose(n6);
                }
                catch (Exception exception) {}
            }
        } else if (n3 == HDF5Constants.H5T_FLOAT) {
            if (n4 == 4) {
                object = new float[n2];
            } else if (n4 == 8) {
                object = new double[n2];
            }
        } else if (n3 == HDF5Constants.H5T_STRING || n3 == HDF5Constants.H5T_REFERENCE || n3 == HDF5Constants.H5T_BITFIELD) {
            object = new byte[n2 * n4];
        } else if (n3 == HDF5Constants.H5T_ARRAY) {
            int n7 = -1;
            try {
                int n8 = H5.H5Tget_array_ndims(n);
                int[] nArray = new int[n8];
                H5.H5Tget_array_dims(n, nArray, null);
                int n9 = 1;
                for (int i = 0; i < n8; ++i) {
                    n9 *= nArray[i];
                }
                n7 = H5.H5Tget_super(n);
                object = H5Datatype.allocateArray(n7, n2 * n9);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    H5.H5Tclose(n7);
                }
                catch (Exception exception) {}
            }
        } else {
            object = null;
        }
        return object;
    }

    public static final int getDatatypeSize(int n) {
        int n2 = -1;
        try {
            n2 = H5.H5Tget_size(n);
        }
        catch (Exception exception) {
            n2 = -1;
        }
        return n2;
    }

    @Override
    public String getDatatypeDescription() {
        if (this.description == null) {
            int n = this.toNative();
            this.description = H5Datatype.getDatatypeDescription(n);
            this.close(n);
        }
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getDatatypeDescription(int n) {
        String string;
        block75: {
            string = "Unknown";
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            try {
                n2 = H5.H5Tget_class(n);
                n3 = H5.H5Tget_size(n);
                n4 = H5.H5Tget_sign(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n2 == HDF5Constants.H5T_INTEGER) {
                if (n3 == 1) {
                    try {
                        if (H5.H5Tequal(n, HDF5Constants.H5T_NATIVE_UCHAR)) {
                            string = "8-bit unsigned character";
                            break block75;
                        }
                        if (H5.H5Tequal(n, HDF5Constants.H5T_NATIVE_CHAR)) {
                            string = "8-bit character";
                            break block75;
                        }
                        if (n4 == HDF5Constants.H5T_SGN_NONE) {
                            string = "8-bit unsigned integer";
                            break block75;
                        }
                        string = "8-bit integer";
                    }
                    catch (Exception exception) {
                        string = "Unknown";
                    }
                } else if (n3 == 2) {
                    string = n4 == HDF5Constants.H5T_SGN_NONE ? "16-bit unsigned integer" : "16-bit integer";
                } else if (n3 == 4) {
                    string = n4 == HDF5Constants.H5T_SGN_NONE ? "32-bit unsigned integer" : "32-bit integer";
                } else if (n3 == 8) {
                    string = n4 == HDF5Constants.H5T_SGN_NONE ? "64-bit unsigned integer" : "64-bit integer";
                }
            } else if (n2 == HDF5Constants.H5T_FLOAT) {
                if (n3 == 4) {
                    string = "32-bit floating-point";
                } else if (n3 == 8) {
                    string = "64-bit floating-point";
                }
            } else if (n2 == HDF5Constants.H5T_STRING) {
                try {
                    if (H5.H5Tis_variable_str(n)) {
                        string = "String, length = variable";
                        break block75;
                    }
                    string = "String, length = " + H5.H5Tget_size(n);
                }
                catch (Exception exception) {
                    string = "String";
                }
            } else if (n2 == HDF5Constants.H5T_REFERENCE) {
                boolean bl = false;
                try {
                    bl = H5.H5Tequal(n, HDF5Constants.H5T_STD_REF_DSETREG);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string = bl ? "Dataset region reference" : "Object reference";
            } else if (n2 == HDF5Constants.H5T_BITFIELD) {
                string = "Bitfield";
            } else if (n2 == HDF5Constants.H5T_ENUM) {
                string = "enum";
                String string2 = " ( ";
                int[] nArray = new int[]{0};
                try {
                    int n6 = H5.H5Tget_nmembers(n);
                    for (int i = 0; i < n6; ++i) {
                        H5.H5Tget_member_value(n, i, nArray);
                        string2 = string2 + H5.H5Tget_member_name(n, i);
                        string2 = string2 + "=" + nArray[0] + "  ";
                    }
                    string2 = string2 + ")";
                    string = string + string2;
                }
                catch (Exception exception) {}
            } else if (n2 == HDF5Constants.H5T_ARRAY) {
                string = "Array of ";
                int n7 = -1;
                try {
                    n7 = H5.H5Tget_super(n);
                    string = string + H5Datatype.getDatatypeDescription(n7);
                    int n8 = H5.H5Tget_array_ndims(n);
                    int[] nArray = new int[n8];
                    try {
                        H5.H5Tget_array_dims(n, nArray, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    string = string + " (" + nArray[0];
                    for (int i = 1; i < n8; ++i) {
                        string = string + "x" + nArray[i];
                    }
                    string = string + ")";
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        H5.H5Tclose(n7);
                    }
                    catch (Exception exception) {}
                }
            } else if (n2 == HDF5Constants.H5T_COMPOUND) {
                string = "Compound ";
                try {
                    string = string + "{";
                    int n9 = H5.H5Tget_nmembers(n);
                    int n10 = 0;
                    try {
                        H5.H5Tclose(n10);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    for (int i = 0; i < n9; ++i) {
                        n10 = H5.H5Tget_member_type(n, i);
                        string = string + H5Datatype.getDatatypeDescription(n10) + ", ";
                        try {
                            H5.H5Tclose(n10);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    string = string + "}";
                }
                catch (Exception exception) {}
            } else if (n2 == HDF5Constants.H5T_VLEN) {
                int n11 = -1;
                try {
                    n11 = H5.H5Tget_super(n);
                    string = "Variable-length of " + H5Datatype.getDatatypeDescription(n11);
                }
                catch (Exception exception) {
                    string = "Variable-length";
                }
                finally {
                    try {
                        H5.H5Tclose(n11);
                    }
                    catch (Exception exception) {}
                }
            } else {
                string = n2 == HDF5Constants.H5T_OPAQUE ? "Opaque" : "Unknown";
            }
        }
        return string;
    }

    @Override
    public boolean isUnsigned() {
        return this.datatypeSign == 0;
    }

    public static final boolean isUnsigned(int n) {
        boolean bl = false;
        try {
            int n2 = H5.H5Tget_sign(n);
            if (n2 == HDF5Constants.H5T_SGN_NONE) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    @Override
    public int open() {
        int n = -1;
        try {
            n = H5.H5Topen(this.getFID(), this.getPath() + this.getName());
        }
        catch (HDF5Exception hDF5Exception) {
            n = -1;
        }
        return n;
    }

    @Override
    public void close(int n) {
        try {
            H5.H5Tclose(n);
        }
        catch (HDF5Exception hDF5Exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getMetadata() throws HDF5Exception {
        if (this.attributeList == null) {
            int n = this.open();
            try {
                this.attributeList = H5File.getAttribute(n);
            }
            catch (Exception exception) {
            }
            finally {
                this.close(n);
            }
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        boolean bl = false;
        Attribute attribute = (Attribute)object;
        String string = attribute.getName();
        if (this.attributeList == null) {
            this.getMetadata();
        } else {
            bl = this.attributeList.contains(attribute);
        }
        this.getFileFormat().writeAttribute(this, attribute, bl);
        if (!bl) {
            this.attributeList.add(attribute);
            this.nAttributes = this.attributeList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetadata(Object object) throws HDF5Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        Attribute attribute = (Attribute)object;
        int n = this.open();
        try {
            H5.H5Adelete(n, attribute.getName());
            List list = this.getMetadata();
            list.remove(attribute);
            this.nAttributes = this.attributeList.size();
        }
        finally {
            this.close(n);
        }
    }
}

