/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "cu" locale.
 */
public class LocalizedNamesImpl_cu extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AD",
        "AE",
        "AF",
        "AG",
        "AI",
        "AL",
        "AM",
        "AO",
        "AQ",
        "AR",
        "AS",
        "AT",
        "AW",
        "AX",
        "AZ",
        "BA",
        "BB",
        "BD",
        "BE",
        "BF",
        "BG",
        "BH",
        "BI",
        "BJ",
        "BL",
        "BM",
        "BN",
        "BO",
        "BQ",
        "BS",
        "BT",
        "BV",
        "BW",
        "BZ",
        "CC",
        "CD",
        "CF",
        "CG",
        "CH",
        "CI",
        "CK",
        "CL",
        "CM",
        "CO",
        "CP",
        "CR",
        "CU",
        "CV",
        "CW",
        "CX",
        "CY",
        "CZ",
        "DG",
        "DJ",
        "DM",
        "DO",
        "DZ",
        "EA",
        "EC",
        "EE",
        "EG",
        "EH",
        "ER",
        "ES",
        "ET",
        "EU",
        "EZ",
        "FI",
        "FJ",
        "FK",
        "FM",
        "FO",
        "GA",
        "GD",
        "GE",
        "GF",
        "GG",
        "GH",
        "GI",
        "GL",
        "GM",
        "GN",
        "GP",
        "GQ",
        "GR",
        "GS",
        "GT",
        "GU",
        "GW",
        "GY",
        "HK",
        "HM",
        "HN",
        "HR",
        "HT",
        "HU",
        "IC",
        "ID",
        "IE",
        "IL",
        "IM",
        "IO",
        "IQ",
        "IR",
        "IS",
        "JE",
        "JM",
        "JO",
        "KE",
        "KH",
        "KI",
        "KM",
        "KN",
        "KP",
        "KR",
        "KW",
        "KY",
        "LA",
        "LB",
        "LC",
        "LI",
        "LK",
        "LR",
        "LS",
        "LT",
        "LU",
        "LV",
        "LY",
        "MA",
        "MC",
        "MD",
        "ME",
        "MF",
        "MG",
        "MH",
        "MK",
        "ML",
        "MM",
        "MN",
        "MO",
        "MP",
        "MQ",
        "MR",
        "MS",
        "MT",
        "MU",
        "MV",
        "MW",
        "MY",
        "MZ",
        "NA",
        "NC",
        "NE",
        "NF",
        "NG",
        "NI",
        "NL",
        "NO",
        "NP",
        "NR",
        "NU",
        "NZ",
        "OM",
        "PA",
        "PE",
        "PF",
        "PG",
        "PH",
        "PK",
        "PL",
        "PM",
        "PN",
        "PR",
        "PS",
        "PT",
        "PW",
        "PY",
        "QA",
        "QO",
        "RE",
        "RO",
        "RS",
        "RW",
        "SA",
        "SB",
        "SC",
        "SD",
        "SE",
        "SG",
        "SH",
        "SI",
        "SJ",
        "SK",
        "SL",
        "SM",
        "SN",
        "SO",
        "SR",
        "SS",
        "ST",
        "SV",
        "SX",
        "SY",
        "SZ",
        "TA",
        "TC",
        "TD",
        "TF",
        "TG",
        "TH",
        "TJ",
        "TK",
        "TL",
        "TM",
        "TN",
        "TO",
        "TR",
        "TT",
        "TV",
        "TW",
        "TZ",
        "UG",
        "UM",
        "UN",
        "UY",
        "UZ",
        "VA",
        "VC",
        "VE",
        "VG",
        "VI",
        "VN",
        "VU",
        "WF",
        "WS",
        "XA",
        "XB",
        "XK",
        "YE",
        "YT",
        "ZA",
        "ZM",
        "ZW",
        "AU",
        "GB",
        "DK",
        "CA",
        "MX",
        "US",
        "BR",
        "BY",
        "FR",
        "DE",
        "KZ",
        "KG",
        "RU",
        "CN",
        "IN",
        "IT",
        "UA",
        "JP",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AU", "А҆ѵстралі́ѧ");
    namesMap.put("BR", "бразі́лїа");
    namesMap.put("BY", "бѣ́лаѧ рꙋ́сь");
    namesMap.put("CA", "Кана́да");
    namesMap.put("CN", "хи́нскаѧ страна̀");
    namesMap.put("DE", "герма́нїа");
    namesMap.put("DK", "Дані́ѧ");
    namesMap.put("FR", "га́ллїа");
    namesMap.put("GB", "Вели́каѧ брїта́нїа");
    namesMap.put("IN", "і҆́ндїа");
    namesMap.put("IT", "і҆та́лїа");
    namesMap.put("JP", "ꙗ҆пѡ́нїа");
    namesMap.put("KG", "кирги́зїа");
    namesMap.put("KZ", "казахста́нъ");
    namesMap.put("MX", "Ме́ѯїко");
    namesMap.put("RU", "рѡссі́а");
    namesMap.put("UA", "ᲂу҆краи́на");
    namesMap.put("US", "а҆мерїка̑нскїѧ соединє́нныѧ держа̑вы");
    namesMap.put("ZZ", "невѣ́домаѧ страна̀");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AU": "А҆ѵстралі́ѧ",
        "BR": "бразі́лїа",
        "BY": "бѣ́лаѧ рꙋ́сь",
        "CA": "Кана́да",
        "CN": "хи́нскаѧ страна̀",
        "DE": "герма́нїа",
        "DK": "Дані́ѧ",
        "FR": "га́ллїа",
        "GB": "Вели́каѧ брїта́нїа",
        "IN": "і҆́ндїа",
        "IT": "і҆та́лїа",
        "JP": "ꙗ҆пѡ́нїа",
        "KG": "кирги́зїа",
        "KZ": "казахста́нъ",
        "MX": "Ме́ѯїко",
        "RU": "рѡссі́а",
        "UA": "ᲂу҆краи́на",
        "US": "а҆мерїка̑нскїѧ соединє́нныѧ держа̑вы",
        "ZZ": "невѣ́домаѧ страна̀"
    };
  }-*/;
}
