/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.taglib;

import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.web.taglib.GroovySyntaxTag;
import org.codehaus.groovy.grails.web.taglib.exceptions.GrailsTagException;

abstract class GroovyConditionalTag
extends GroovySyntaxTag {
    static final String ATTRIBUTE_TEST = "test";
    static final String ATTRIBUTE_ENV = "env";

    GroovyConditionalTag() {
    }

    public void doStartTag() {
        String env = this.attributeValueOrNull(ATTRIBUTE_ENV);
        String test = this.attributeValueOrNull(ATTRIBUTE_TEST);
        if (env == null && test == null) {
            throw new GrailsTagException("Tag [" + this.getName() + "] must have one or both of the attributes [" + ATTRIBUTE_TEST + "] or [" + ATTRIBUTE_ENV + "]");
        }
        String envExpression = this.environmentExpressionOrTrue(env);
        String testExpression = this.testExpressionOrTrue(test);
        this.outputStartTag(envExpression, testExpression);
    }

    protected abstract void outputStartTag(String var1, String var2);

    public void doEndTag() {
        this.out.println("}");
    }

    protected String attributeValueOrNull(String attributeName) {
        String attributeValue = (String)this.attributes.get(attributeName);
        return StringUtils.isBlank((String)attributeValue) ? null : attributeValue;
    }

    private String environmentExpressionOrTrue(String envAttributeValue) {
        String expression = "true";
        if (envAttributeValue != null) {
            expression = "(GrailsUtil.environment == '" + this.calculateExpression(envAttributeValue) + "')";
        }
        return expression;
    }

    private String testExpressionOrTrue(String testAttributeValue) {
        String expression = "true";
        if (testAttributeValue != null) {
            expression = "(" + testAttributeValue + ")";
        }
        return expression;
    }

    public boolean isKeepPrecedingWhiteSpace() {
        return true;
    }

    public boolean isAllowPrecedingContent() {
        return true;
    }
}

