/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.NFIBackendImpl;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.spi.NFIBackendLibrary;
import com.oracle.truffle.nfi.spi.types.NativeSimpleType;
import com.oracle.truffle.nfi.util.ProfiledArrayBuilder;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NFIBackendImpl.class)
final class NFIBackendImplGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private NFIBackendImplGen() {
    }

    static {
        LibraryExport.register(NFIBackendImpl.class, (LibraryExport[])new LibraryExport[]{new NFIBackendLibraryExports()});
    }

    @GeneratedBy(value=NFIBackendImpl.class)
    private static final class NFIBackendLibraryExports
    extends LibraryExport<NFIBackendLibrary> {
        private NFIBackendLibraryExports() {
            super(NFIBackendLibrary.class, NFIBackendImpl.class, false);
        }

        protected NFIBackendLibrary createUncached(Object receiver) {
            assert (receiver instanceof NFIBackendImpl);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected NFIBackendLibrary createCached(Object receiver) {
            assert (receiver instanceof NFIBackendImpl);
            return new Cached();
        }

        @GeneratedBy(value=NFIBackendImpl.class)
        private static final class Uncached
        extends NFIBackendLibrary {
            private final TruffleLanguage.ContextReference<NFIContext> nFILanguageImplContextReference_ = this.lookupContextReference(NFILanguageImpl.class);

            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFIBackendImpl) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFIBackendImpl;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getSimpleType(Object arg0Value_, NativeSimpleType arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFIBackendImpl arg0Value = (NFIBackendImpl)arg0Value_;
                return arg0Value.getSimpleType(arg1Value, (NFIContext)this.nFILanguageImplContextReference_.get());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getArrayType(Object arg0Value_, NativeSimpleType arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFIBackendImpl arg0Value = (NFIBackendImpl)arg0Value_;
                return arg0Value.getArrayType(arg1Value, (NFIContext)this.nFILanguageImplContextReference_.get());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getEnvType(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFIBackendImpl arg0Value = (NFIBackendImpl)arg0Value_;
                return arg0Value.getEnvType((NFIContext)this.nFILanguageImplContextReference_.get());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object createSignatureBuilder(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFIBackendImpl arg0Value = (NFIBackendImpl)arg0Value_;
                return arg0Value.createSignatureBuilder(this, (NFIContext)this.nFILanguageImplContextReference_.get(), ProfiledArrayBuilder.ArrayBuilderFactory.getUncached());
            }
        }

        @GeneratedBy(value=NFIBackendImpl.class)
        private static final class Cached
        extends NFIBackendLibrary {
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<NFIContext> nFILanguageImplContextReference_;
            @CompilerDirectives.CompilationFinal
            private ProfiledArrayBuilder.ArrayBuilderFactory createSignatureBuilderNode__builderFactory_;

            protected Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFIBackendImpl) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFIBackendImpl;
            }

            @Override
            public Object getSimpleType(Object arg0Value_, NativeSimpleType arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                NFIBackendImpl arg0Value = (NFIBackendImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    TruffleLanguage.ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                    NFIContext getSimpleTypeNode__ctx__ = (NFIContext)nFILanguageImplContextReference__.get();
                    return arg0Value.getSimpleType(arg1Value, getSimpleTypeNode__ctx__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getSimpleTypeNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object getSimpleTypeNode_AndSpecialize(NFIBackendImpl arg0Value, NativeSimpleType arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    NFIContext getSimpleTypeNode__ctx__ = null;
                    TruffleLanguage.ContextReference nFILanguageImplContextReference__1 = this.nFILanguageImplContextReference_;
                    if (nFILanguageImplContextReference__1 == null) {
                        this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__1 = super.lookupContextReference(NFILanguageImpl.class);
                    }
                    getSimpleTypeNode__ctx__ = (NFIContext)nFILanguageImplContextReference__1.get();
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.getSimpleType(arg1Value, getSimpleTypeNode__ctx__);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object getArrayType(Object arg0Value_, NativeSimpleType arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                NFIBackendImpl arg0Value = (NFIBackendImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 2) != 0) {
                    TruffleLanguage.ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                    NFIContext getArrayTypeNode__ctx__ = (NFIContext)nFILanguageImplContextReference__.get();
                    return arg0Value.getArrayType(arg1Value, getArrayTypeNode__ctx__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getArrayTypeNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object getArrayTypeNode_AndSpecialize(NFIBackendImpl arg0Value, NativeSimpleType arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    NFIContext getArrayTypeNode__ctx__ = null;
                    TruffleLanguage.ContextReference nFILanguageImplContextReference__1 = this.nFILanguageImplContextReference_;
                    if (nFILanguageImplContextReference__1 == null) {
                        this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__1 = super.lookupContextReference(NFILanguageImpl.class);
                    }
                    getArrayTypeNode__ctx__ = (NFIContext)nFILanguageImplContextReference__1.get();
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.getArrayType(arg1Value, getArrayTypeNode__ctx__);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object getEnvType(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                NFIBackendImpl arg0Value = (NFIBackendImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 4) != 0) {
                    TruffleLanguage.ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                    NFIContext getEnvTypeNode__ctx__ = (NFIContext)nFILanguageImplContextReference__.get();
                    return arg0Value.getEnvType(getEnvTypeNode__ctx__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getEnvTypeNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object getEnvTypeNode_AndSpecialize(NFIBackendImpl arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    NFIContext getEnvTypeNode__ctx__ = null;
                    TruffleLanguage.ContextReference nFILanguageImplContextReference__1 = this.nFILanguageImplContextReference_;
                    if (nFILanguageImplContextReference__1 == null) {
                        this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__1 = super.lookupContextReference(NFILanguageImpl.class);
                    }
                    getEnvTypeNode__ctx__ = (NFIContext)nFILanguageImplContextReference__1.get();
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.getEnvType(getEnvTypeNode__ctx__);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object createSignatureBuilder(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                NFIBackendImpl arg0Value = (NFIBackendImpl)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 8) != 0) {
                    Cached createSignatureBuilderNode__self__ = this;
                    TruffleLanguage.ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                    NFIContext createSignatureBuilderNode__ctx__ = (NFIContext)nFILanguageImplContextReference__.get();
                    return arg0Value.createSignatureBuilder(createSignatureBuilderNode__self__, createSignatureBuilderNode__ctx__, this.createSignatureBuilderNode__builderFactory_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.createSignatureBuilderNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object createSignatureBuilderNode_AndSpecialize(NFIBackendImpl arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    NFIContext createSignatureBuilderNode__ctx__ = null;
                    Cached createSignatureBuilderNode__self__ = null;
                    createSignatureBuilderNode__self__ = this;
                    TruffleLanguage.ContextReference nFILanguageImplContextReference__1 = this.nFILanguageImplContextReference_;
                    if (nFILanguageImplContextReference__1 == null) {
                        this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__1 = super.lookupContextReference(NFILanguageImpl.class);
                    }
                    createSignatureBuilderNode__ctx__ = (NFIContext)nFILanguageImplContextReference__1.get();
                    this.createSignatureBuilderNode__builderFactory_ = ProfiledArrayBuilder.ArrayBuilderFactory.create();
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.createSignatureBuilder(createSignatureBuilderNode__self__, createSignatureBuilderNode__ctx__, this.createSignatureBuilderNode__builderFactory_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

