/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.nfi.NFIType;
import com.oracle.truffle.nfi.NFITypeLibrary;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NFITypeLibrary.class)
final class NFITypeLibraryGen
extends LibraryFactory<NFITypeLibrary> {
    private static final Class<NFITypeLibrary> LIBRARY_CLASS = NFITypeLibraryGen.lazyLibraryClass();
    private static final Message CONVERT_TO_NATIVE = new MessageImpl("convertToNative", 0, Object.class, NFIType.TypeCachedState.class, NFIType.class, Object.class);
    private static final Message CONVERT_FROM_NATIVE = new MessageImpl("convertFromNative", 1, Object.class, NFIType.TypeCachedState.class, NFIType.class, Object.class);
    private static final NFITypeLibraryGen INSTANCE = new NFITypeLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private NFITypeLibraryGen() {
        super(LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(CONVERT_TO_NATIVE, CONVERT_FROM_NATIVE)));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return NFITypeLibrary.class;
    }

    protected NFITypeLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(((MessageImpl)message).index);
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected NFITypeLibrary createDelegate(NFITypeLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        NFITypeLibrary lib = (NFITypeLibrary)originalLib;
        MessageImpl messageImpl = (MessageImpl)message;
        if (messageImpl.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (messageImpl.index) {
            case 0: {
                return lib.convertToNative((NFIType.TypeCachedState)receiver, (NFIType)args[offset], args[offset + 1]);
            }
            case 1: {
                return lib.convertFromNative((NFIType.TypeCachedState)receiver, (NFIType)args[offset], args[offset + 1]);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected NFITypeLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected NFITypeLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<NFITypeLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.nfi.NFITypeLibrary", false, NFITypeLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=NFITypeLibrary.class)
    private static abstract class CachedDispatch
    extends NFITypeLibrary {
        @Node.Child
        NFITypeLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(NFITypeLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop
        public Object convertToNative(NFIType.TypeCachedState receiver_, NFIType type, Object value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    NFITypeLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.convertToNative(receiver_, type, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object convertFromNative(NFIType.TypeCachedState receiver_, NFIType type, Object value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    NFITypeLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.convertFromNative(receiver_, type, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(NFIType.TypeCachedState receiver_) {
            CachedDispatch current = this;
            NFITypeLibrary thisLibrary = current.library;
            if (thisLibrary == null) {
                this.library = (NFITypeLibrary)this.insert((Node)INSTANCE.create(receiver_));
            } else {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    int count = 0;
                    do {
                        NFITypeLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (NFITypeLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((NFITypeLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    @GeneratedBy(value=NFITypeLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(NFITypeLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library == null) continue;
                ++count;
            } while ((current = current.next) != null);
            return NodeCost.fromCount((int)count);
        }
    }

    @GeneratedBy(value=NFITypeLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(NFITypeLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=NFITypeLibrary.class)
    private static final class UncachedDispatch
    extends NFITypeLibrary {
        private UncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object convertToNative(NFIType.TypeCachedState receiver_, NFIType type, Object value) {
            return ((NFITypeLibrary)INSTANCE.getUncached(receiver_)).convertToNative(receiver_, type, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object convertFromNative(NFIType.TypeCachedState receiver_, NFIType type, Object value) {
            return ((NFITypeLibrary)INSTANCE.getUncached(receiver_)).convertFromNative(receiver_, type, value);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=NFITypeLibrary.class)
    private static final class CachedToUncachedDispatch
    extends NFITypeLibrary {
        private CachedToUncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object convertToNative(NFIType.TypeCachedState receiver_, NFIType type, Object value) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((NFITypeLibrary)INSTANCE.getUncached(receiver_)).convertToNative(receiver_, type, value);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object convertFromNative(NFIType.TypeCachedState receiver_, NFIType type, Object value) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((NFITypeLibrary)INSTANCE.getUncached(receiver_)).convertFromNative(receiver_, type, value);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=NFITypeLibrary.class)
    private static final class Delegate
    extends NFITypeLibrary {
        @Node.Child
        private NFITypeLibrary delegateLibrary;

        Delegate(NFITypeLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public Object convertToNative(NFIType.TypeCachedState receiver_, NFIType type, Object value) {
            if (NFITypeLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = NFITypeLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((NFITypeLibrary)NFITypeLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).convertToNative((NFIType.TypeCachedState)delegate, type, value);
            }
            return this.delegateLibrary.convertToNative(receiver_, type, value);
        }

        @Override
        public Object convertFromNative(NFIType.TypeCachedState receiver_, NFIType type, Object value) {
            if (NFITypeLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = NFITypeLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((NFITypeLibrary)NFITypeLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).convertFromNative((NFIType.TypeCachedState)delegate, type, value);
            }
            return this.delegateLibrary.convertFromNative(receiver_, type, value);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=NFITypeLibrary.class)
    private static final class Proxy
    extends NFITypeLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public Object convertToNative(NFIType.TypeCachedState receiver_, NFIType type, Object value) {
            try {
                return this.lib.send((Object)receiver_, CONVERT_TO_NATIVE, new Object[]{type, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object convertFromNative(NFIType.TypeCachedState receiver_, NFIType type, Object value) {
            try {
                return this.lib.send((Object)receiver_, CONVERT_FROM_NATIVE, new Object[]{type, value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=NFITypeLibrary.class)
    private static class MessageImpl
    extends Message {
        final int index;

        MessageImpl(String name, int index, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, returnType, (Class[])parameters);
            this.index = index;
        }
    }

    @GeneratedBy(value=NFITypeLibrary.class)
    private static final class Default
    extends LibraryExport<NFITypeLibrary> {
        private Default() {
            super(NFITypeLibrary.class, NFIType.TypeCachedState.class, false);
        }

        protected NFITypeLibrary createUncached(Object receiver) {
            assert (receiver instanceof NFIType.TypeCachedState);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected NFITypeLibrary createCached(Object receiver) {
            assert (receiver instanceof NFIType.TypeCachedState);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NFITypeLibrary.class)
        private static final class Uncached
        extends NFITypeLibrary {
            private final Class<? extends NFIType.TypeCachedState> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((NFIType.TypeCachedState)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object convertToNative(NFIType.TypeCachedState receiver, NFIType type, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object convertFromNative(NFIType.TypeCachedState receiver, NFIType type, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }

        @GeneratedBy(value=NFITypeLibrary.class)
        private static final class Cached
        extends NFITypeLibrary {
            private final Class<? extends NFIType.TypeCachedState> receiverClass_;

            protected Cached(Object receiver) {
                NFIType.TypeCachedState castReceiver = (NFIType.TypeCachedState)receiver;
                this.receiverClass_ = castReceiver.getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object convertToNative(NFIType.TypeCachedState receiver, NFIType type, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object convertFromNative(NFIType.TypeCachedState receiver, NFIType type, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }
    }
}

