/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;

abstract class HostToGuestRootNode
extends RootNode {
    protected static final int ARGUMENT_OFFSET = 2;
    @CompilerDirectives.CompilationFinal
    private boolean seenEnter;
    @CompilerDirectives.CompilationFinal
    private boolean seenNonEnter;
    @CompilerDirectives.CompilationFinal
    private volatile PolyglotLanguage.ContextProfile profile;
    private final PolyglotEngineImpl engine;
    private final BranchProfile error = BranchProfile.create();

    HostToGuestRootNode(PolyglotEngineImpl engine) {
        this(engine, null);
    }

    HostToGuestRootNode() {
        this((PolyglotEngineImpl)null, (TruffleLanguage<?>)null);
    }

    HostToGuestRootNode(PolyglotLanguageContext languageContext) {
        this(null, languageContext != null ? languageContext.getLanguageInstance().spi : null);
    }

    private HostToGuestRootNode(PolyglotEngineImpl engine, TruffleLanguage<?> language) {
        super(language);
        if (engine == null) {
            this.engine = (PolyglotEngineImpl)EngineAccessor.NODES.getPolyglotEngine(this);
        } else {
            assert (language == null) : "unsupported state";
            this.engine = engine;
            EngineAccessor.NODES.setPolyglotEngine(this, engine);
        }
        assert (this.engine != null) : "all host to guest root nodes need to be initialized when entered";
        assert (this.needsEnter() || !this.needsExceptionWrapping()) : "HostToGuestRootNode which does not require enter cannot have exception wrapping.";
    }

    protected abstract Class<?> getReceiverType();

    protected boolean needsEnter() {
        return true;
    }

    protected boolean needsExceptionWrapping() {
        return true;
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        PolyglotContextImpl prev;
        boolean needsEnter;
        PolyglotContextImpl context;
        Object[] args = frame.getArguments();
        PolyglotLanguageContext languageContext = this.profileContext(args[0]);
        try {
            assert (languageContext != null);
            context = languageContext.context;
            boolean bl = needsEnter = this.needsEnter() && languageContext != null && this.engine.needsEnter(context);
            if (needsEnter) {
                if (!this.seenEnter) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenEnter = true;
                }
                prev = this.engine.enter(context, this, true);
            } else {
                if (!this.seenNonEnter) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenNonEnter = true;
                }
                prev = null;
            }
        }
        catch (Throwable e) {
            throw this.handleException(languageContext, e, false, RuntimeException.class);
        }
        try {
            Object[] arguments = frame.getArguments();
            Object receiver = this.getReceiverType().cast(arguments[1]);
            Object result = this.executeImpl(languageContext, receiver, arguments);
            assert (!(result instanceof TruffleObject));
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            throw this.handleException(languageContext, e, this.needsEnter(), RuntimeException.class);
        }
        finally {
            if (needsEnter) {
                try {
                    this.engine.leave(prev, context);
                }
                catch (Throwable e) {
                    throw this.handleException(languageContext, e, false, RuntimeException.class);
                }
            }
        }
    }

    private <E extends Throwable> E handleException(PolyglotLanguageContext languageContext, Throwable e, boolean entered, Class<E> exceptionType) throws E {
        if (this.needsExceptionWrapping()) {
            this.error.enter();
            throw PolyglotImpl.guestToHostException(languageContext, e, entered);
        }
        throw e;
    }

    private PolyglotLanguageContext profileContext(Object languageContext) {
        PolyglotLanguage.ContextProfile localProfile = this.profile;
        if (localProfile == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.profile = localProfile = ((PolyglotLanguageContext)languageContext).language.profile;
        }
        return localProfile.profile(languageContext);
    }

    protected abstract Object executeImpl(PolyglotLanguageContext var1, Object var2, Object[] var3);

    protected static CallTarget createTarget(HostToGuestRootNode node) {
        return Truffle.getRuntime().createCallTarget(node);
    }

    static <T> T installHostCodeCache(PolyglotLanguageContext languageContext, Object key, T value, Class<T> expectedType) {
        T result = expectedType.cast(languageContext.getLanguageInstance().hostInteropCodeCache.putIfAbsent(key, value));
        if (result != null) {
            return result;
        }
        return value;
    }

    static <T> T lookupHostCodeCache(PolyglotLanguageContext languageContext, Object key, Class<T> expectedType) {
        return expectedType.cast(languageContext.getLanguageInstance().hostInteropCodeCache.get(key));
    }
}

