/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.memory;

import com.oracle.truffle.api.memory.ByteArrayOutOfBoundsException;
import com.oracle.truffle.api.memory.ByteArraySupport;

final class CheckedByteArraySupport
extends ByteArraySupport {
    final ByteArraySupport access;

    CheckedByteArraySupport(ByteArraySupport access) {
        this.access = access;
    }

    private void checkBounds(byte[] buffer, int startIndex, int length) {
        if (!this.inBounds(buffer, startIndex, length)) {
            throw new ByteArrayOutOfBoundsException();
        }
    }

    @Override
    public byte getByte(byte[] buffer, int index) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, index, 1);
        return this.access.getByte(buffer, index);
    }

    @Override
    public void putByte(byte[] buffer, int index, byte value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, index, 1);
        this.access.putByte(buffer, index, value);
    }

    @Override
    public short getShort(byte[] buffer, int index) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, index, 2);
        return this.access.getShort(buffer, index);
    }

    @Override
    public void putShort(byte[] buffer, int index, short value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, index, 2);
        this.access.putShort(buffer, index, value);
    }

    @Override
    public int getInt(byte[] buffer, int index) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, index, 4);
        return this.access.getInt(buffer, index);
    }

    @Override
    public void putInt(byte[] buffer, int index, int value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, index, 4);
        this.access.putInt(buffer, index, value);
    }

    @Override
    public long getLong(byte[] buffer, int index) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, index, 8);
        return this.access.getLong(buffer, index);
    }

    @Override
    public void putLong(byte[] buffer, int index, long value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, index, 8);
        this.access.putLong(buffer, index, value);
    }

    @Override
    public float getFloat(byte[] buffer, int index) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, index, 4);
        return this.access.getFloat(buffer, index);
    }

    @Override
    public void putFloat(byte[] buffer, int index, float value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, index, 4);
        this.access.putFloat(buffer, index, value);
    }

    @Override
    public double getDouble(byte[] buffer, int index) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, index, 8);
        return this.access.getDouble(buffer, index);
    }

    @Override
    public void putDouble(byte[] buffer, int index, double value) throws IndexOutOfBoundsException {
        this.checkBounds(buffer, index, 8);
        this.access.putDouble(buffer, index, value);
    }
}

