/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.interop.AssertUtils;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.LegacyMetaObjectWrapper;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;

final class InteropAccessor
extends Accessor {
    static final InteropAccessor ACCESSOR = new InteropAccessor();

    private InteropAccessor() {
    }

    static Object checkInteropType(Object obj) {
        assert (InteropAccessor.checkInteropTypeImpl(obj));
        return obj;
    }

    private static boolean checkInteropTypeImpl(Object obj) {
        if (AssertUtils.isInteropValue(obj)) {
            return true;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        Class<?> clazz = obj != null ? obj.getClass() : null;
        return InteropAccessor.yieldAnError(clazz);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean yieldAnError(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        sb.append(clazz == null ? "null" : clazz.getName());
        sb.append(" isn't allowed Truffle interop type!\n");
        if (clazz == null) {
            throw new NullPointerException(sb.toString());
        }
        throw new ClassCastException(sb.toString());
    }

    static final class EmptyTruffleObject
    implements TruffleObject {
        static final EmptyTruffleObject INSTANCE = new EmptyTruffleObject();

        EmptyTruffleObject() {
        }
    }

    static class InteropImpl
    extends Accessor.InteropSupport {
        InteropImpl() {
        }

        @Override
        public boolean isTruffleObject(Object value) {
            return value instanceof TruffleObject;
        }

        @Override
        public void checkInteropType(Object result) {
            InteropAccessor.checkInteropType(result);
        }

        @Override
        public boolean isExecutableObject(Object value) {
            return InteropLibrary.getFactory().getUncached().isExecutable(value);
        }

        @Override
        public Object createDefaultNodeObject(Node node) {
            return EmptyTruffleObject.INSTANCE;
        }

        @Override
        public Object createLegacyMetaObjectWrapper(Object receiver, Object result) {
            return new LegacyMetaObjectWrapper(receiver, result);
        }

        @Override
        public Object unwrapLegacyMetaObjectWrapper(Object receiver) {
            if (receiver instanceof LegacyMetaObjectWrapper) {
                return ((LegacyMetaObjectWrapper)receiver).delegate;
            }
            return receiver;
        }
    }
}

