/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotReferences;
import com.oracle.truffle.polyglot.PolyglotSourceCache;
import com.oracle.truffle.polyglot.PolyglotValue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class PolyglotLanguageInstance
implements PolyglotImpl.VMObject {
    final PolyglotLanguage language;
    final TruffleLanguage<Object> spi;
    private final PolyglotSourceCache sourceCache;
    final Map<Class<?>, PolyglotValue.InteropCodeCache> valueCodeCache;
    final Map<Object, Object> hostInteropCodeCache;
    private volatile OptionValuesImpl firstOptionValues;
    private volatile boolean needsInitializeMultiContext;
    private final Assumption singleContext = Truffle.getRuntime().createAssumption("Single context per language instance.");
    private final TruffleLanguage.LanguageReference<TruffleLanguage<Object>> directLanguageSupplier;
    private final TruffleLanguage.ContextReference<Object> directContextSupplier;

    PolyglotLanguageInstance(PolyglotLanguage language) {
        Assumption useInnerContext;
        this.language = language;
        this.sourceCache = new PolyglotSourceCache();
        this.valueCodeCache = new ConcurrentHashMap();
        this.hostInteropCodeCache = new ConcurrentHashMap<Object, Object>();
        try {
            this.spi = language.cache.loadLanguage();
            EngineAccessor.LANGUAGE.initializeLanguage(this.spi, language.info, language, this);
            if (!language.engine.singleContext.isValid()) {
                this.initializeMultiContext();
            } else {
                this.needsInitializeMultiContext = !language.engine.boundEngine && language.cache.getPolicy() != TruffleLanguage.ContextPolicy.EXCLUSIVE;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error initializing language '%s' using class '%s'.", language.cache.getId(), language.cache.getClassName()), e);
        }
        boolean mayBeUsedInInnerContext = language.cache.getPolicy() != TruffleLanguage.ContextPolicy.EXCLUSIVE;
        boolean currentExclusive = language.getEffectiveContextPolicy(language) == TruffleLanguage.ContextPolicy.EXCLUSIVE;
        Assumption useDirectSingleContext = currentExclusive ? null : this.singleContext;
        Assumption assumption = useInnerContext = mayBeUsedInInnerContext ? language.engine.noInnerContexts : null;
        this.directContextSupplier = language.engine.conservativeContextReferences ? language.getConservativeContextReference() : (useDirectSingleContext == null && useInnerContext == null ? PolyglotReferences.createAlwaysSingleContext(language, currentExclusive) : PolyglotReferences.createAssumeSingleContext(language, useInnerContext, useDirectSingleContext, language.getContextReference(), currentExclusive));
        this.directLanguageSupplier = PolyglotReferences.createAlwaysSingleLanguage(language, this);
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.language.engine;
    }

    boolean areOptionsCompatible(OptionValuesImpl newOptionValues) {
        OptionValuesImpl firstOptions = this.firstOptionValues;
        if (this.firstOptionValues == null) {
            return true;
        }
        return EngineAccessor.LANGUAGE.areOptionsCompatible(this.spi, firstOptions, newOptionValues);
    }

    void claim(OptionValuesImpl optionValues) {
        assert (Thread.holdsLock(this.language.engine));
        if (this.firstOptionValues == null) {
            this.firstOptionValues = optionValues;
        }
    }

    void patchFirstOptions(OptionValuesImpl optionValues) {
        this.firstOptionValues = optionValues;
    }

    void ensureMultiContextInitialized() {
        assert (Thread.holdsLock(this.language.engine));
        if (this.needsInitializeMultiContext) {
            this.needsInitializeMultiContext = false;
            this.language.engine.initializeMultiContext(null);
            this.initializeMultiContext();
        }
    }

    void initializeMultiContext() {
        assert (!this.language.engine.singleContext.isValid());
        if (this.language.cache.getPolicy() != TruffleLanguage.ContextPolicy.EXCLUSIVE) {
            this.singleContext.invalidate();
            EngineAccessor.LANGUAGE.initializeMultiContext(this.spi);
        }
    }

    PolyglotSourceCache getSourceCache() {
        return this.sourceCache;
    }

    TruffleLanguage.ContextReference<Object> getDirectContextSupplier() {
        return this.directContextSupplier;
    }

    TruffleLanguage.ContextReference<Object> lookupContextSupplier(PolyglotLanguage sourceLanguage) {
        TruffleLanguage.ContextReference<Object> ref;
        assert (this.language != sourceLanguage);
        switch (this.language.getEffectiveContextPolicy(sourceLanguage)) {
            case EXCLUSIVE: {
                ref = PolyglotReferences.createAssumeSingleContext(this.language, this.language.engine.noInnerContexts, null, this.language.getContextReference(), true);
                break;
            }
            case REUSE: 
            case SHARED: {
                ref = this.language.getContextReference();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return ref;
    }

    TruffleLanguage.LanguageReference<TruffleLanguage<Object>> getDirectLanguageReference() {
        return this.directLanguageSupplier;
    }

    TruffleLanguage.LanguageReference<TruffleLanguage<Object>> lookupLanguageSupplier(PolyglotLanguage sourceLanguage) {
        assert (this.language != sourceLanguage);
        switch (this.language.getEffectiveContextPolicy(sourceLanguage)) {
            case EXCLUSIVE: {
                return PolyglotReferences.createAssumeSingleLanguage(this.language, this, this.language.singleInstance, this.language.getLanguageReference());
            }
            case REUSE: 
            case SHARED: {
                return this.language.getLanguageReference();
            }
        }
        throw new AssertionError();
    }
}

