/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni;

import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.jni.JNIOnLoadFunctionPointer;
import com.oracle.svm.jni.functions.JNIFunctionTables;
import com.oracle.svm.jni.nativeapi.JNIVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public class JNILibraryInitializer
implements NativeLibrarySupport.LibraryInitializer {
    private final EconomicMap<String, CGlobalData<PointerBase>> onLoadCGlobalDataMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY);

    public static String getOnLoadName(String libName, boolean isBuiltIn) {
        String name = "JNI_OnLoad";
        if (isBuiltIn) {
            return name + "_" + libName;
        }
        return name;
    }

    private static void callOnLoadFunction(String libName, PointerBase onLoadFunction) {
        if (onLoadFunction.isNonNull()) {
            JNIOnLoadFunctionPointer onLoad = (JNIOnLoadFunctionPointer)onLoadFunction;
            int expected = onLoad.invoke(JNIFunctionTables.singleton().getGlobalJavaVM(), (VoidPointer)WordFactory.nullPointer());
            JNILibraryInitializer.checkSupportedJNIVersion(libName, expected);
        }
    }

    private static void checkSupportedJNIVersion(String libName, int expected) {
        if (expected != JNIVersion.JNI_VERSION_1_8() && expected != JNIVersion.JNI_VERSION_1_6() && expected != JNIVersion.JNI_VERSION_1_4() && expected != JNIVersion.JNI_VERSION_1_2() && expected != JNIVersion.JNI_VERSION_1_1()) {
            String message = "Unsupported JNI version 0x" + Integer.toHexString(expected) + ", required by " + libName;
            throw new UnsatisfiedLinkError(message);
        }
    }

    public boolean fillCGlobalDataMap(Collection<String> staticLibNames) {
        List<String> libsWithOnLoad = Arrays.asList("net", "java", "nio", "zip", "sunec", "jaas", "sctp", "extnet", "j2gss", "j2pkcs11", "j2pcsc", "prefs", "verify", "awt", "awt_xawt", "awt_headless", "lcms", "fontmanager", "javajpeg", "mlib_image");
        ArrayList<String> localStaticLibNames = new ArrayList<String>(staticLibNames);
        localStaticLibNames.retainAll(libsWithOnLoad);
        boolean mapIsChanged = false;
        for (String libName : localStaticLibNames) {
            if (this.onLoadCGlobalDataMap.containsKey((Object)libName)) continue;
            CGlobalData onLoadCGlobalData = CGlobalDataFactory.forSymbol(JNILibraryInitializer.getOnLoadName(libName, true), true);
            this.onLoadCGlobalDataMap.put((Object)libName, onLoadCGlobalData);
            mapIsChanged = true;
        }
        return mapIsChanged;
    }

    @Override
    public boolean isBuiltinLibrary(String libName) {
        if (PlatformNativeLibrarySupport.singleton().isBuiltinLibrary(libName)) {
            return true;
        }
        String onLoadName = JNILibraryInitializer.getOnLoadName(libName, true);
        PointerBase onLoad = PlatformNativeLibrarySupport.singleton().findBuiltinSymbol(onLoadName);
        return onLoad.isNonNull();
    }

    @Override
    public void initialize(PlatformNativeLibrarySupport.NativeLibrary lib) {
        PointerBase onLoadFunction;
        String libName = lib.getCanonicalIdentifier();
        if (lib.isBuiltin()) {
            onLoadFunction = this.getOnLoadSymbolAddress(libName);
            if (onLoadFunction.isNull()) {
                String symbolName = JNILibraryInitializer.getOnLoadName(libName, true);
                onLoadFunction = lib.findSymbol(symbolName);
            }
        } else {
            String symbolName = JNILibraryInitializer.getOnLoadName(libName, false);
            onLoadFunction = lib.findSymbol(symbolName);
        }
        JNILibraryInitializer.callOnLoadFunction(libName, onLoadFunction);
    }

    private PointerBase getOnLoadSymbolAddress(String libName) {
        CGlobalData symbol = (CGlobalData)this.onLoadCGlobalDataMap.get((Object)libName);
        return symbol == null ? WordFactory.nullPointer() : symbol.get();
    }
}

