/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.spi.UncheckedInterfaceProvider;

class TrivialMethodDetectorParameterPlugin
implements ParameterPlugin {
    private final ValueNode[] args;

    TrivialMethodDetectorParameterPlugin(ValueNode[] args) {
        this.args = args;
    }

    public FloatingNode interceptParameter(GraphBuilderTool b, int index, StampPair stamp) {
        ValueNode arg = this.args[index];
        Stamp argStamp = arg.stamp(NodeView.DEFAULT);
        if (arg.isConstant()) {
            return new ConstantNode(arg.asConstant(), argStamp);
        }
        StampPair stampPair = arg instanceof UncheckedInterfaceProvider ? StampPair.create((Stamp)argStamp, (Stamp)((UncheckedInterfaceProvider)arg).uncheckedStamp()) : StampPair.createSingle((Stamp)argStamp);
        return new ParameterNode(index, stampPair);
    }
}

