/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.annotate.Hybrid;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import java.lang.reflect.Modifier;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public class HybridLayoutSupport {
    public boolean isHybrid(ResolvedJavaType clazz) {
        return clazz.isAnnotationPresent(Hybrid.class);
    }

    public boolean isHybridField(ResolvedJavaField field) {
        return field.getAnnotation(Hybrid.Array.class) != null || field.getAnnotation(Hybrid.TypeIDSlots.class) != null;
    }

    public HybridFields findHybridFields(HostedInstanceClass hybridClass) {
        assert (hybridClass.getAnnotation(Hybrid.class) != null);
        assert (Modifier.isFinal(hybridClass.getModifiers()));
        HostedField foundArrayField = null;
        HostedField foundTypeIDSlotsField = null;
        for (HostedField field : hybridClass.getInstanceFields(true)) {
            if (field.getAnnotation(Hybrid.Array.class) != null) {
                assert (foundArrayField == null) : "must have exactly one hybrid array field";
                assert (field.getType().isArray());
                foundArrayField = field;
            }
            if (field.getAnnotation(Hybrid.TypeIDSlots.class) == null) continue;
            assert (foundTypeIDSlotsField == null) : "must have at most one typeid slot field";
            assert (field.getType().isArray());
            foundTypeIDSlotsField = field;
        }
        assert (foundArrayField != null) : "must have exactly one hybrid array field";
        return new HybridFields(foundArrayField, foundTypeIDSlotsField);
    }

    public static class HybridFields {
        public final HostedField arrayField;
        public final HostedField typeIDSlotsField;

        public HybridFields(HostedField arrayField, HostedField typeIDSlotsField) {
            this.arrayField = arrayField;
            this.typeIDSlotsField = typeIDSlotsField;
        }
    }
}

