/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.info;

import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.c.info.AccessorInfo;
import com.oracle.svm.hosted.c.info.ConstantInfo;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.EnumConstantInfo;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.c.info.EnumLookupInfo;
import com.oracle.svm.hosted.c.info.EnumValueInfo;
import com.oracle.svm.hosted.c.info.NativeCodeInfo;
import com.oracle.svm.hosted.c.info.PointerToInfo;
import com.oracle.svm.hosted.c.info.PropertyInfo;
import com.oracle.svm.hosted.c.info.RawStructureInfo;
import com.oracle.svm.hosted.c.info.StructBitfieldInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.info.StructInfo;

public abstract class InfoTreeVisitor {
    protected final void processChildren(ElementInfo info) {
        for (ElementInfo child : info.getChildren()) {
            try {
                child.accept(this);
            }
            catch (NumberFormatException e) {
                throw UserError.abort("Missing CAP cache value for: %s", child.getUniqueID());
            }
        }
    }

    protected void visitNativeCodeInfo(NativeCodeInfo info) {
        this.processChildren(info);
    }

    protected void visitStructInfo(StructInfo info) {
        this.processChildren(info);
    }

    protected void visitRawStructureInfo(RawStructureInfo info) {
        this.processChildren(info);
    }

    protected void visitStructFieldInfo(StructFieldInfo info) {
        this.processChildren(info);
    }

    protected void visitStructBitfieldInfo(StructBitfieldInfo info) {
        this.processChildren(info);
    }

    protected void visitConstantInfo(ConstantInfo info) {
        this.processChildren(info);
    }

    protected void visitPointerToInfo(PointerToInfo info) {
        this.processChildren(info);
    }

    protected void visitAccessorInfo(AccessorInfo info) {
        this.processChildren(info);
    }

    protected void visitElementPropertyInfo(PropertyInfo<?> info) {
        this.processChildren(info);
    }

    protected void visitEnumInfo(EnumInfo info) {
        this.processChildren(info);
    }

    protected void visitEnumConstantInfo(EnumConstantInfo info) {
        this.processChildren(info);
    }

    protected void visitEnumValueInfo(EnumValueInfo info) {
        this.processChildren(info);
    }

    protected void visitEnumLookupInfo(EnumLookupInfo info) {
        this.processChildren(info);
    }
}

