/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.c.libc.TemporaryBuildDirectoryProvider;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageOptions;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class TemporaryBuildDirectoryProviderImpl
implements TemporaryBuildDirectoryProvider {
    private Path tempDirectory;
    private boolean deleteTempDirectory;

    @Override
    public synchronized Path getTemporaryBuildDirectory() {
        if (this.tempDirectory == null) {
            try {
                String tempName = NativeImageOptions.TempDirectory.getValue();
                if (tempName == null || tempName.isEmpty()) {
                    this.tempDirectory = Files.createTempDirectory("SVM-", new FileAttribute[0]);
                    this.deleteTempDirectory = true;
                } else {
                    this.tempDirectory = FileSystems.getDefault().getPath(tempName, new String[0]).resolve("SVM-" + System.currentTimeMillis());
                    assert (!Files.exists(this.tempDirectory, new LinkOption[0]));
                    Files.createDirectories(this.tempDirectory, new FileAttribute[0]);
                }
            }
            catch (IOException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
        return this.tempDirectory.toAbsolutePath();
    }

    private static void deleteAll(Path path) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    void clean() {
        if (this.deleteTempDirectory) {
            TemporaryBuildDirectoryProviderImpl.deleteAll(this.getTemporaryBuildDirectory());
        }
    }
}

