/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.isolated.ImageHeapRef;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class ImageHeapObjects {
    @Uninterruptible(reason="Called from uninterruptible code.")
    static boolean isInImageHeap(Object obj) {
        return obj == null || Heap.getHeap().isInImageHeap(obj);
    }

    public static <T> ImageHeapRef<T> ref(T t) {
        if (t == null) {
            return (ImageHeapRef)WordFactory.nullPointer();
        }
        VMError.guarantee(ImageHeapObjects.isInImageHeap(t));
        Word result = Word.objectToUntrackedPointer(t);
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            result = result.subtract((UnsignedWord)KnownIntrinsics.heapBase());
        }
        return (ImageHeapRef)result;
    }

    public static <T> T deref(ImageHeapRef<T> ref) {
        if (ref.equal((UnsignedWord)WordFactory.nullPointer())) {
            return null;
        }
        Pointer objectAddress = (Pointer)ref;
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            objectAddress = objectAddress.add((UnsignedWord)KnownIntrinsics.heapBase());
        }
        Object obj = KnownIntrinsics.convertUnknownValue(objectAddress.toObject(), Object.class);
        VMError.guarantee(Heap.getHeap().isInImageHeap(obj));
        Object result = obj;
        return (T)result;
    }

    private ImageHeapObjects() {
    }
}

