/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.util.VMError;
import java.nio.ByteBuffer;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class HostedByteBufferPointer
implements Pointer {
    private final ByteBuffer buffer;
    private final int baseOffset;

    public HostedByteBufferPointer(ByteBuffer buffer, int baseOffset) {
        assert (buffer != null);
        this.buffer = buffer;
        this.baseOffset = baseOffset;
    }

    public byte readByte(int offset) {
        return this.buffer.get(this.baseOffset + offset);
    }

    public byte readByte(int offset, LocationIdentity locationIdentity) {
        return this.readByte(offset);
    }

    public byte readByte(WordBase offset) {
        return this.readByte(HostedByteBufferPointer.offsetAsInt(offset));
    }

    public byte readByte(WordBase offset, LocationIdentity locationIdentity) {
        return this.readByte(offset);
    }

    public void writeByte(int offset, byte val) {
        this.buffer.put(this.baseOffset + offset, val);
    }

    public void writeByte(WordBase offset, byte val) {
        this.writeByte(HostedByteBufferPointer.offsetAsInt(offset), val);
    }

    public void writeByte(int offset, byte val, LocationIdentity locationIdentity) {
        this.writeByte(offset, val);
    }

    public void writeByte(WordBase offset, byte val, LocationIdentity locationIdentity) {
        this.writeByte(offset, val);
    }

    public boolean isNull() {
        return false;
    }

    public boolean isNonNull() {
        return true;
    }

    private static int offsetAsInt(WordBase offset) {
        return NumUtil.safeToInt((long)offset.rawValue());
    }

    private static RuntimeException unsupported() {
        throw VMError.shouldNotReachHere();
    }

    public boolean equal(ComparableWord val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean notEqual(ComparableWord val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public long rawValue() {
        throw HostedByteBufferPointer.unsupported();
    }

    public Object toObject() {
        throw HostedByteBufferPointer.unsupported();
    }

    public Object toObjectNonNull() {
        throw HostedByteBufferPointer.unsupported();
    }

    public char readChar(WordBase offset, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public short readShort(WordBase offset, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public int readInt(WordBase offset, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public long readLong(WordBase offset, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public float readFloat(WordBase offset, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public double readDouble(WordBase offset, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public <T extends WordBase> T readWord(WordBase offset, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public Object readObject(WordBase offset, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public char readChar(int offset, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public short readShort(int offset, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public int readInt(int offset, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public long readLong(int offset, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public float readFloat(int offset, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public double readDouble(int offset, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public <T extends WordBase> T readWord(int offset, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public Object readObject(int offset, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeChar(WordBase offset, char val, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeShort(WordBase offset, short val, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeInt(WordBase offset, int val, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeLong(WordBase offset, long val, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeFloat(WordBase offset, float val, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeDouble(WordBase offset, double val, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeWord(WordBase offset, WordBase val, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void initializeLong(WordBase offset, long val, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeObject(WordBase offset, Object val, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeChar(int offset, char val, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeShort(int offset, short val, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeInt(int offset, int val, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeLong(int offset, long val, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeFloat(int offset, float val, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeDouble(int offset, double val, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeWord(int offset, WordBase val, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void initializeLong(int offset, long val, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeObject(int offset, Object val, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public char readChar(WordBase offset) {
        throw HostedByteBufferPointer.unsupported();
    }

    public short readShort(WordBase offset) {
        throw HostedByteBufferPointer.unsupported();
    }

    public int readInt(WordBase offset) {
        throw HostedByteBufferPointer.unsupported();
    }

    public long readLong(WordBase offset) {
        throw HostedByteBufferPointer.unsupported();
    }

    public float readFloat(WordBase offset) {
        throw HostedByteBufferPointer.unsupported();
    }

    public double readDouble(WordBase offset) {
        throw HostedByteBufferPointer.unsupported();
    }

    public <T extends WordBase> T readWord(WordBase offset) {
        throw HostedByteBufferPointer.unsupported();
    }

    public Object readObject(WordBase offset) {
        throw HostedByteBufferPointer.unsupported();
    }

    public char readChar(int offset) {
        throw HostedByteBufferPointer.unsupported();
    }

    public short readShort(int offset) {
        throw HostedByteBufferPointer.unsupported();
    }

    public int readInt(int offset) {
        throw HostedByteBufferPointer.unsupported();
    }

    public long readLong(int offset) {
        throw HostedByteBufferPointer.unsupported();
    }

    public float readFloat(int offset) {
        throw HostedByteBufferPointer.unsupported();
    }

    public double readDouble(int offset) {
        throw HostedByteBufferPointer.unsupported();
    }

    public <T extends WordBase> T readWord(int offset) {
        throw HostedByteBufferPointer.unsupported();
    }

    public Object readObject(int offset) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeChar(WordBase offset, char val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeShort(WordBase offset, short val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeInt(WordBase offset, int val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeLong(WordBase offset, long val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeFloat(WordBase offset, float val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeDouble(WordBase offset, double val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeWord(WordBase offset, WordBase val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeObject(WordBase offset, Object val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public int compareAndSwapInt(WordBase offset, int expectedValue, int newValue, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public long compareAndSwapLong(WordBase offset, long expectedValue, long newValue, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public <T extends WordBase> T compareAndSwapWord(WordBase offset, T expectedValue, T newValue, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public Object compareAndSwapObject(WordBase offset, Object expectedValue, Object newValue, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean logicCompareAndSwapInt(WordBase offset, int expectedValue, int newValue, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean logicCompareAndSwapLong(WordBase offset, long expectedValue, long newValue, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean logicCompareAndSwapWord(WordBase offset, WordBase expectedValue, WordBase newValue, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean logicCompareAndSwapObject(WordBase offset, Object expectedValue, Object newValue, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeChar(int offset, char val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeShort(int offset, short val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeInt(int offset, int val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeLong(int offset, long val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeFloat(int offset, float val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeDouble(int offset, double val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeWord(int offset, WordBase val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public void writeObject(int offset, Object val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public int compareAndSwapInt(int offset, int expectedValue, int newValue, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public long compareAndSwapLong(int offset, long expectedValue, long newValue, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public <T extends WordBase> T compareAndSwapWord(int offset, T expectedValue, T newValue, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public Object compareAndSwapObject(int offset, Object expectedValue, Object newValue, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean logicCompareAndSwapInt(int offset, int expectedValue, int newValue, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean logicCompareAndSwapLong(int offset, long expectedValue, long newValue, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean logicCompareAndSwapWord(int offset, WordBase expectedValue, WordBase newValue, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean logicCompareAndSwapObject(int offset, Object expectedValue, Object newValue, LocationIdentity locationIdentity) {
        throw HostedByteBufferPointer.unsupported();
    }

    public Pointer add(UnsignedWord val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public Pointer add(int val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public Pointer subtract(UnsignedWord val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public UnsignedWord multiply(UnsignedWord val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public UnsignedWord unsignedDivide(UnsignedWord val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public UnsignedWord unsignedRemainder(UnsignedWord val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public UnsignedWord shiftLeft(UnsignedWord n) {
        throw HostedByteBufferPointer.unsupported();
    }

    public UnsignedWord unsignedShiftRight(UnsignedWord n) {
        throw HostedByteBufferPointer.unsupported();
    }

    public Pointer subtract(int val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public UnsignedWord multiply(int val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public UnsignedWord unsignedDivide(int val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public UnsignedWord unsignedRemainder(int val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public UnsignedWord shiftLeft(int n) {
        throw HostedByteBufferPointer.unsupported();
    }

    public UnsignedWord unsignedShiftRight(int n) {
        throw HostedByteBufferPointer.unsupported();
    }

    public Pointer and(UnsignedWord val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public Pointer and(int val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public Pointer or(UnsignedWord val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public UnsignedWord xor(UnsignedWord val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public UnsignedWord not() {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean equal(UnsignedWord val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean notEqual(UnsignedWord val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean belowThan(UnsignedWord val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean belowOrEqual(UnsignedWord val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean aboveThan(UnsignedWord val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean aboveOrEqual(UnsignedWord val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public Pointer or(int val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public UnsignedWord xor(int val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean equal(int val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean notEqual(int val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean belowThan(int val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean belowOrEqual(int val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean aboveThan(int val) {
        throw HostedByteBufferPointer.unsupported();
    }

    public boolean aboveOrEqual(int val) {
        throw HostedByteBufferPointer.unsupported();
    }
}

