/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jdk.LocalizationFeature;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.spi.LocaleServiceProvider;
import sun.util.locale.provider.LocaleProviderAdapter;

public final class LocalizationSupport {
    final Map<String, Charset> charsets = new HashMap<String, Charset>();
    final Map<Class<? extends LocaleServiceProvider>, LocaleProviderAdapter> adaptersByClass = new HashMap<Class<? extends LocaleServiceProvider>, LocaleProviderAdapter>();
    final Map<LocaleProviderAdapter.Type, LocaleProviderAdapter> adaptersByType = new HashMap<LocaleProviderAdapter.Type, LocaleProviderAdapter>();
    final Map<Class<? extends LocaleServiceProvider>, Object> providerPools = new HashMap<Class<? extends LocaleServiceProvider>, Object>();
    final Map<String, ResourceBundle> resourceBundles = new HashMap<String, ResourceBundle>();
    private final String includeResourceBundlesOption = SubstrateOptionsParser.commandArgument(LocalizationFeature.Options.IncludeResourceBundles, "");

    public ResourceBundle getCached(String baseName, Locale locale) throws MissingResourceException {
        ResourceBundle result = this.resourceBundles.get(baseName);
        if (result == null) {
            String errorMessage = "Resource bundle not found " + baseName + ". Register the resource bundle using the option " + this.includeResourceBundlesOption + baseName + ".";
            throw new MissingResourceException(errorMessage, this.getClass().getName(), baseName);
        }
        return result;
    }
}

