/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.stackvalue;

import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import java.util.HashMap;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.Phase;

public class StackValuePhase
extends Phase {
    protected void run(StructuredGraph graph) {
        HashMap<StackValueNode.StackSlotIdentity, StackValueNode.StackSlotHolder> slots = new HashMap<StackValueNode.StackSlotIdentity, StackValueNode.StackSlotHolder>();
        for (StackValueNode node : graph.getNodes(StackValueNode.TYPE)) {
            StackValueNode.StackSlotHolder slotHolder = (StackValueNode.StackSlotHolder)slots.get(node.slotIdentity);
            if (slotHolder == null) {
                slotHolder = new StackValueNode.StackSlotHolder(node.size);
                slots.put(node.slotIdentity, slotHolder);
            }
            assert (node.stackSlotHolder == null);
            node.stackSlotHolder = slotHolder;
        }
    }
}

