/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.deopt.DeoptimizationRuntime;
import com.oracle.svm.core.graal.nodes.UnreachableNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateIntrinsics;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import java.util.Map;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractDeoptimizeNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.DynamicDeoptimizeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public final class DeoptRuntimeSnippets
extends SubstrateTemplates
implements Snippets {
    @Snippet
    protected static void deoptSnippet(long actionAndReason, SpeculationLog.SpeculationReason speculation) {
        SubstrateIntrinsics.runtimeCall((ForeignCallDescriptor)DeoptimizationRuntime.DEOPTIMIZE, actionAndReason, speculation);
        throw UnreachableNode.unreachable();
    }

    public static void registerLowerings(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new DeoptRuntimeSnippets(options, factories, providers, snippetReflection, lowerings);
    }

    private DeoptRuntimeSnippets(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, factories, providers, snippetReflection);
        AbstractDeoptimizeLowering lowering = new AbstractDeoptimizeLowering();
        lowerings.put(DeoptimizeNode.class, lowering);
        lowerings.put(DynamicDeoptimizeNode.class, lowering);
    }

    protected class AbstractDeoptimizeLowering
    implements NodeLoweringProvider<AbstractDeoptimizeNode> {
        private final SnippetTemplate.SnippetInfo deopt;

        protected AbstractDeoptimizeLowering() {
            this.deopt = DeoptRuntimeSnippets.this.snippet(DeoptRuntimeSnippets.class, "deoptSnippet", new LocationIdentity[0]);
        }

        @Override
        public void lower(AbstractDeoptimizeNode node, LoweringTool tool) {
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
                return;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.deopt, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("actionAndReason", (Object)node.getActionAndReason(tool.getMetaAccess()));
            args.add("speculation", (Object)node.getSpeculation(tool.getMetaAccess()));
            DeoptRuntimeSnippets.this.template((ValueNode)node, args).instantiate(DeoptRuntimeSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

