/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatArrayNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatObjectNode;
import com.oracle.svm.core.graal.snippets.DeoptTester;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.struct.UniqueLocationIdentity;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class ThreadLocalAllocation {
    private static final FastThreadLocalBytes<Descriptor> regularTLAB = (FastThreadLocalBytes)FastThreadLocalFactory.createBytes(ThreadLocalAllocation::getRegularTLABSize).setMaxOffset(127);

    private ThreadLocalAllocation() {
    }

    @Fold
    static Log log() {
        return Log.noopLog();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static int getRegularTLABSize() {
        return SizeOf.get(Descriptor.class);
    }

    public static Word getTlabAddress() {
        return (Word)regularTLAB.getAddress();
    }

    @Uninterruptible(reason="Accesses TLAB", callerMustBe=true)
    private static Descriptor getTlab(IsolateThread vmThread) {
        return regularTLAB.getAddress(vmThread);
    }

    @Uninterruptible(reason="Accesses TLAB", callerMustBe=true)
    private static Descriptor getTlab() {
        return regularTLAB.getAddress();
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object slowPathNewInstance(Word objectHeader) {
        DynamicHub hub = ObjectHeaderImpl.getObjectHeaderImpl().dynamicHubFromObjectHeader((UnsignedWord)objectHeader);
        UnsignedWord gcEpoch = HeapImpl.getHeapImpl().getGCImpl().possibleCollectionPrologue();
        Object result = ThreadLocalAllocation.slowPathNewInstanceWithoutAllocating(hub);
        HeapImpl.getHeapImpl().getGCImpl().possibleCollectionEpilogue(gcEpoch);
        ThreadLocalAllocation.runSlowPathHooks();
        return result;
    }

    private static void runSlowPathHooks() {
        HeapPolicy.samplePhysicalMemorySize();
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of allocation.")
    private static Object slowPathNewInstanceWithoutAllocating(DynamicHub hub) {
        DeoptTester.disableDeoptTesting();
        try {
            HeapImpl.exitIfAllocationDisallowed("ThreadLocalAllocation.allocateNewInstance", DynamicHub.toClass(hub).getName());
            HeapPolicy.maybeCollectOnAllocation();
            AlignedHeapChunk.AlignedHeader newTlab = HeapImpl.getChunkProvider().produceAlignedChunk();
            Object object = ThreadLocalAllocation.allocateInstanceInNewTlab(hub, newTlab);
            return object;
        }
        finally {
            DeoptTester.enableDeoptTesting();
        }
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object slowPathNewArray(Word objectHeader, int length) {
        if (length < 0) {
            throw new NegativeArraySizeException();
        }
        DynamicHub hub = ObjectHeaderImpl.getObjectHeaderImpl().dynamicHubFromObjectHeader((UnsignedWord)objectHeader);
        UnsignedWord size = LayoutEncoding.getArraySize(hub.getLayoutEncoding(), length);
        if (size.aboveOrEqual(HeapPolicy.getMaximumHeapSize())) {
            throw new OutOfMemoryError("Array allocation too large.");
        }
        UnsignedWord gcEpoch = HeapImpl.getHeapImpl().getGCImpl().possibleCollectionPrologue();
        Object result = ThreadLocalAllocation.slowPathNewArrayWithoutAllocating(hub, length, size);
        HeapImpl.getHeapImpl().getGCImpl().possibleCollectionEpilogue(gcEpoch);
        ThreadLocalAllocation.runSlowPathHooks();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of allocation.")
    private static Object slowPathNewArrayWithoutAllocating(DynamicHub hub, int length, UnsignedWord size) {
        DeoptTester.disableDeoptTesting();
        try {
            HeapImpl.exitIfAllocationDisallowed("Heap.allocateNewArray", DynamicHub.toClass(hub).getName());
            HeapPolicy.maybeCollectOnAllocation();
            if (size.aboveOrEqual(HeapPolicy.getLargeArrayThreshold())) {
                UnalignedHeapChunk.UnalignedHeader newTlabChunk = HeapImpl.getChunkProvider().produceUnalignedChunk(size);
                Object object = ThreadLocalAllocation.allocateLargeArrayInNewTlab(hub, length, size, newTlabChunk);
                return object;
            }
            AlignedHeapChunk.AlignedHeader newTlabChunk = HeapImpl.getChunkProvider().produceAlignedChunk();
            Object object = ThreadLocalAllocation.allocateSmallArrayInNewTlab(hub, length, size, newTlabChunk);
            return object;
        }
        finally {
            DeoptTester.enableDeoptTesting();
        }
    }

    @Uninterruptible(reason="Holds uninitialized memory.")
    private static Object allocateInstanceInNewTlab(DynamicHub hub, AlignedHeapChunk.AlignedHeader newTlabChunk) {
        UnsignedWord size = LayoutEncoding.getInstanceSize(hub.getLayoutEncoding());
        Pointer memory = ThreadLocalAllocation.allocateRawMemoryInNewTlab(size, newTlabChunk);
        return FormatObjectNode.formatObject(memory, DynamicHub.toClass(hub), false, true, true);
    }

    @Uninterruptible(reason="Holds uninitialized memory.")
    private static Object allocateSmallArrayInNewTlab(DynamicHub hub, int length, UnsignedWord size, AlignedHeapChunk.AlignedHeader newTlabChunk) {
        Pointer memory = ThreadLocalAllocation.allocateRawMemoryInNewTlab(size, newTlabChunk);
        return FormatArrayNode.formatArray(memory, DynamicHub.toClass(hub), length, false, false, true, true);
    }

    @Uninterruptible(reason="Holds uninitialized memory, modifies TLAB")
    private static Object allocateLargeArrayInNewTlab(DynamicHub hub, int length, UnsignedWord size, UnalignedHeapChunk.UnalignedHeader newTlabChunk) {
        Descriptor tlab = ThreadLocalAllocation.getTlab();
        HeapChunk.setNext(newTlabChunk, tlab.getUnalignedChunk());
        tlab.setUnalignedChunk(newTlabChunk);
        Pointer memory = UnalignedHeapChunk.allocateMemory(newTlabChunk, size);
        assert (memory.isNonNull());
        return FormatArrayNode.formatArray(memory, DynamicHub.toClass(hub), length, false, true, true, true);
    }

    @Uninterruptible(reason="Returns uninitialized memory, modifies TLAB", callerMustBe=true)
    private static Pointer allocateRawMemoryInNewTlab(UnsignedWord size, AlignedHeapChunk.AlignedHeader newTlabChunk) {
        Descriptor tlab = ThreadLocalAllocation.getTlab();
        assert (DeoptTester.enabled() || ThreadLocalAllocation.availableTlabMemory(tlab).belowThan(size)) : "Slowpath allocation was used even though TLAB had sufficient space";
        ThreadLocalAllocation.retireCurrentAllocationChunk(tlab);
        ThreadLocalAllocation.registerNewAllocationChunk(tlab, newTlabChunk);
        assert (size.belowOrEqual(ThreadLocalAllocation.availableTlabMemory(tlab))) : "Not enough TLAB space for allocation";
        Pointer top = KnownIntrinsics.nonNullPointer((Pointer)tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY));
        tlab.setAllocationTop(top.add(size), SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
        return top;
    }

    @Uninterruptible(reason="Accesses TLAB")
    private static UnsignedWord availableTlabMemory(Descriptor allocator) {
        Word top = allocator.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
        Word end = allocator.getAllocationEnd(SubstrateAllocationSnippets.TLAB_END_IDENTITY);
        assert (top.belowOrEqual((UnsignedWord)end));
        if (top.isNull() || end.isNull()) {
            return WordFactory.unsigned((int)0);
        }
        return end.subtract((UnsignedWord)top);
    }

    static boolean isThreadLocalAllocationSpace(Space space) {
        return space == HeapImpl.getHeapImpl().getYoungGeneration().getEden();
    }

    static void disableAndFlushForAllThreads() {
        VMOperation.guaranteeInProgress("ThreadLocalAllocation.disableAndFlushForAllThreads");
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            IsolateThread vmThread = VMThreads.firstThread();
            while (vmThread.isNonNull()) {
                ThreadLocalAllocation.disableAndFlushForThread(vmThread);
                vmThread = VMThreads.nextThread(vmThread);
            }
        } else {
            ThreadLocalAllocation.disableAndFlushForThread((IsolateThread)WordFactory.nullPointer());
        }
    }

    @Uninterruptible(reason="Accesses TLAB")
    static void disableAndFlushForThread(IsolateThread vmThread) {
        ThreadLocalAllocation.retireToSpace(ThreadLocalAllocation.getTlab(vmThread), HeapImpl.getHeapImpl().getYoungGeneration().getEden());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void tearDown() {
        IsolateThread thread = (IsolateThread)WordFactory.nullPointer();
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            thread = VMThreads.firstThreadUnsafe();
            VMError.guarantee(VMThreads.nextThread(thread).isNull(), "Other isolate threads are still active");
        }
        ThreadLocalAllocation.freeHeapChunks(ThreadLocalAllocation.getTlab(thread));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void freeHeapChunks(Descriptor tlab) {
        HeapChunkProvider.freeAlignedChunkList(tlab.getAlignedChunk());
        HeapChunkProvider.freeUnalignedChunkList(tlab.getUnalignedChunk());
    }

    @Uninterruptible(reason="Accesses TLAB")
    static void suspendInCurrentThread() {
        ThreadLocalAllocation.retireCurrentAllocationChunk(ThreadLocalAllocation.getTlab());
    }

    @Uninterruptible(reason="Accesses TLAB")
    static void resumeInCurrentThread() {
        ThreadLocalAllocation.resumeAllocationInCurrentChunk(ThreadLocalAllocation.getTlab());
    }

    @Uninterruptible(reason="Accesses TLAB")
    static void retireToSpace(Descriptor tlab, Space space) {
        HeapChunk.Header<AlignedHeapChunk.AlignedHeader> next;
        VMThreads.guaranteeOwnsThreadMutex("Otherwise, we wouldn't be allowed to access the space.");
        assert (!space.isOldSpace()) : "must not be moved to the old gen - otherwise a remembered set would have to be constructed";
        ThreadLocalAllocation.retireCurrentAllocationChunk(tlab);
        AlignedHeapChunk.AlignedHeader alignedChunk = tlab.getAlignedChunk();
        HeapChunk.Header<UnalignedHeapChunk.UnalignedHeader> unalignedChunk = tlab.getUnalignedChunk();
        tlab.setAlignedChunk((AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer());
        tlab.setUnalignedChunk((UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer());
        while (alignedChunk.isNonNull()) {
            next = HeapChunk.getNext(alignedChunk);
            HeapChunk.setNext(alignedChunk, (HeapChunk.Header)WordFactory.nullPointer());
            space.appendAlignedHeapChunk(alignedChunk);
            alignedChunk = next;
        }
        while (unalignedChunk.isNonNull()) {
            next = HeapChunk.getNext(unalignedChunk);
            HeapChunk.setNext(unalignedChunk, (HeapChunk.Header)WordFactory.nullPointer());
            space.appendUnalignedHeapChunk((UnalignedHeapChunk.UnalignedHeader)unalignedChunk);
            unalignedChunk = next;
        }
    }

    @Uninterruptible(reason="Modifies TLAB")
    private static void registerNewAllocationChunk(Descriptor tlab, AlignedHeapChunk.AlignedHeader newChunk) {
        HeapChunk.setNext(newChunk, tlab.getAlignedChunk());
        tlab.setAlignedChunk(newChunk);
        ThreadLocalAllocation.resumeAllocationInCurrentChunk(tlab);
    }

    @Uninterruptible(reason="Modifies TLAB")
    private static void retireCurrentAllocationChunk(Descriptor tlab) {
        Word allocationTop = tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
        if (allocationTop.isNonNull()) {
            AlignedHeapChunk.AlignedHeader alignedChunk = tlab.getAlignedChunk();
            assert (HeapChunk.getTopPointer(alignedChunk).isNull());
            assert (HeapChunk.getEndPointer(alignedChunk).equal((UnsignedWord)tlab.getAllocationEnd(SubstrateAllocationSnippets.TLAB_END_IDENTITY)));
            HeapChunk.setTopPointer(alignedChunk, (Pointer)allocationTop);
            tlab.setAllocationTop((Pointer)WordFactory.nullPointer(), SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
            tlab.setAllocationEnd((Pointer)WordFactory.nullPointer(), SubstrateAllocationSnippets.TLAB_END_IDENTITY);
        }
    }

    @Uninterruptible(reason="Modifies TLAB.")
    static void resumeAllocationInCurrentChunk(Descriptor tlab) {
        assert (tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY).isNull());
        assert (tlab.getAllocationEnd(SubstrateAllocationSnippets.TLAB_END_IDENTITY).isNull());
        AlignedHeapChunk.AlignedHeader alignedChunk = tlab.getAlignedChunk();
        if (alignedChunk.isNonNull()) {
            tlab.setAllocationTop(HeapChunk.getTopPointer(alignedChunk), SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
            tlab.setAllocationEnd(HeapChunk.getEndPointer(alignedChunk), SubstrateAllocationSnippets.TLAB_END_IDENTITY);
            HeapChunk.setTopPointer(alignedChunk, (Pointer)WordFactory.nullPointer());
        }
    }

    @RawStructure
    public static interface Descriptor
    extends PointerBase {
        @RawField
        @UniqueLocationIdentity
        public AlignedHeapChunk.AlignedHeader getAlignedChunk();

        @RawField
        @UniqueLocationIdentity
        public void setAlignedChunk(AlignedHeapChunk.AlignedHeader var1);

        @RawField
        @UniqueLocationIdentity
        public UnalignedHeapChunk.UnalignedHeader getUnalignedChunk();

        @RawField
        @UniqueLocationIdentity
        public void setUnalignedChunk(UnalignedHeapChunk.UnalignedHeader var1);

        @RawField
        public Word getAllocationTop(LocationIdentity var1);

        @RawField
        public void setAllocationTop(Pointer var1, LocationIdentity var2);

        @RawField
        public Word getAllocationEnd(LocationIdentity var1);

        @RawField
        public void setAllocationEnd(Pointer var1, LocationIdentity var2);
    }
}

